package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.itsys.exception.BaseException;
import com.digiwin.athena.itsys.validator.JsonSchemaValidator;
import com.digiwin.athena.itsys.validator.ValidatorResult;
import com.digiwin.http.client.DWHttpClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractApiProcessor {

	protected final Log log = LogFactory.getLog(getClass());

	protected DWHttpClient dwHttpClient;

	// json訊息驗證器
	final JsonSchemaValidator jsonSchemaValidator = new JsonSchemaValidator();
	// mapper(parse or deserialize JSON content)
	ObjectMapper mapper = new ObjectMapper();

	protected String jsonSchemaFileName;

	public DWEAIResult execute(String pRequestMsg) throws Exception {

		ValidatorResult tValidatorResult = validate(pRequestMsg);
		return process(tValidatorResult);

	}

	private ValidatorResult validate(String pMsg) throws BaseException, Exception {
		return jsonSchemaValidator.validate(pMsg, jsonSchemaFileName);
	}

	protected abstract DWEAIResult process(ValidatorResult validatorResult) throws BaseException, Exception;

}
