package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.exception.BaseException;
import com.digiwin.athena.itsys.queue.rabbitmq.Consumer;
import com.digiwin.athena.itsys.validator.ValidatorResult;
import com.rabbitmq.client.AMQP.BasicProperties;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.Envelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public abstract class AbstractConsumeProcessor {

	protected final Log log = LogFactory.getLog(getClass());

	protected MessageQueueTypeEnum queueType;

	protected int consumerNumber = Integer
			.valueOf(DWApplicationConfigUtils.getProperty("consumer.number"));

	@PostConstruct
	public Map<String, Object> execute() throws Exception {
		for (int i = 0; i < consumerNumber; i++) {
			Consumer consumer = new Consumer(queueType);
			consumeQueue(queueType.getQueueName(), consumer);
		}
		return null;
	}

	private ValidatorResult validate(String pMsg) throws BaseException, Exception {
		return null;
	}

	protected Map<String, Object> consumeQueue(String pQueueName, Consumer consumer) {

		DeliverCallback deliverCallback = (consumerTag, delivery) -> {
			String message = new String(delivery.getBody(), StandardCharsets.UTF_8);
			System.out.println(" [x] Received '" + message + "'");
		};

		try {

			consumer.getChannel().basicConsume(pQueueName, false, new DefaultConsumer(consumer.getChannel()) {
				@Override
				public void handleDelivery(String consumerTag, Envelope envelope, BasicProperties properties,
                                           byte[] body) throws IOException {

					String tMessage = new String(body, "UTF-8");

					log.info(pQueueName + " Message Queue Received A Message: " + tMessage);

					try {

						handleQueueMessage(tMessage);

					} catch (Exception e) {
						log.error(e.getMessage(), e);
					} finally {
						consumer.getChannel().basicAck(envelope.getDeliveryTag(), false);
					}
				}
			});
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}

		return null;

	}

	protected abstract void handleQueueMessage(String pMessage) throws BaseException, Exception;
}
