package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.itsys.dao.ErrorSummaryDao;
import com.digiwin.athena.itsys.enums.ErrorSummaryEnum;
import com.digiwin.athena.itsys.enums.LocaleEnum;
import com.digiwin.athena.itsys.exception.ErrorSummaryFormatException;
import com.digiwin.athena.itsys.model.ErrorSummary;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ErrorSummaryManagementProcessor {

	@Autowired
	private ErrorSummaryDao errorSummaryDao;
	@Autowired
	protected DWHttpClient dwHttpClient;

	protected final Log log = LogFactory.getLog(getClass());
	private ObjectMapper mapper = new ObjectMapper();
	private String DW_TRANSLATE_SERVICE_PATH = "/restful/service/translater/IDWTranslateService/translate";

	public Map<String, Object> execute(String data, String language, String appId) throws Exception {

		log.info("異常分類提交，提交訊息：" + DWServiceContext.getContext().getRequestBody());

//		解析"language":[]
		JsonNode languageObject = mapper.readTree(language);
		LocaleEnum tLocale;
		List<String> convertTypesList = new ArrayList<String>();

//		如果locale沒有值，或是值不正確，則回傳報錯
		if (languageObject.get(LocaleEnum.LOCALE.getType()) != null
				&& languageObject.get(LocaleEnum.LOCALE.getType()).asText().length() != 0) {
			switch (languageObject.get(LocaleEnum.LOCALE.getType()).asText()) {

			case "zh_TW":
				tLocale = LocaleEnum.ZH_TW;
				break;
			case "zh_CN":
				tLocale = LocaleEnum.ZH_CN;
				break;
			case "en_US":
				tLocale = LocaleEnum.EN_US;
				break;
			default:
				throw new ErrorSummaryFormatException("請填入正確的語系", this.getClass());
			}
		} else {
			throw new ErrorSummaryFormatException("請填入正確的語系", this.getClass());
		}

		if (languageObject.get(ErrorSummaryEnum.CONVERT_TYPES.getCode()) != null) {

			ArrayNode convertTypesArrayNode = mapper.createArrayNode();

			convertTypesArrayNode = (ArrayNode) mapper
					.readTree(languageObject.get(ErrorSummaryEnum.CONVERT_TYPES.getCode()).toString());

			for (JsonNode convertType : convertTypesArrayNode) {

				convertTypesList.add(convertType.asText());
			}
		}

		ArrayNode dataArrayNode = mapper.createArrayNode();

		dataArrayNode = (ArrayNode) mapper.readTree(data);

//		解析"data":[]
		for (JsonNode dataNode : dataArrayNode) {

//			將異常分類存入數據庫
			ErrorSummary tErrorSummary = new ErrorSummary();
			List<ErrorSummary> errorSummaries = errorSummaryDao
					.getErrorSummaryByCode(dataNode.get(ErrorSummaryEnum.CODE.getCode()).asText());

			if (errorSummaries != null && errorSummaries.size() != 0) {
				tErrorSummary = errorSummaries.get(0);
			} else {
				tErrorSummary.setCode(dataNode.get(ErrorSummaryEnum.CODE.getCode()).asText());
				tErrorSummary.setAppId(appId);
			}

			switch (tLocale.getType()) {
			case "zh_TW":
				tErrorSummary.setCauseZhTw(dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText());
				break;
			case "zh_CN":
				tErrorSummary.setCauseZhCn(dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText());
				break;
			case "en_US":
				tErrorSummary.setCauseEnUs(dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText());
				break;
			default:
				break;
			}

			for (String convertType : convertTypesList) {
				switch (convertType) {
				case "zh2Hant":
					if (tLocale != LocaleEnum.ZH_CN) {
						throw new ErrorSummaryFormatException("請填入正確的語系轉換類型，convertTypes：（中转繁 ：zh2Hant，中转英 ：zh2En ）",
								this.getClass());
					} else {
						String translateResult = localeTranslate(
								dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText(), tLocale, convertType);
						tErrorSummary.setCauseZhTw(translateResult);
					}
					break;
				case "zh2En":
					if (tLocale != LocaleEnum.ZH_CN) {
						throw new ErrorSummaryFormatException("請填入正確的語系轉換類型，convertTypes：（中转繁 ：zh2Hant，中转英 ：zh2En ）",
								this.getClass());
					} else {
						String translateResult = localeTranslate(
								dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText(), tLocale, convertType);
						tErrorSummary.setCauseEnUs(translateResult);
					}
					break;
				default:
					throw new ErrorSummaryFormatException("請填入正確的語系轉換類型，convertTypes：（中转繁 ：zh2Hant，中转英 ：zh2En ）",
							this.getClass());
				}

			}

			errorSummaryDao.save(tErrorSummary);

			log.info("Save error summary, error code：" + tErrorSummary.getCode());

		}

		log.info(appId + "異常分類提交成功");

		Map tReturn = new HashMap<String, String>();
		tReturn.put("result", appId + "異常分類提交成功");
		return tReturn;
	}

//	翻譯
	private String localeTranslate(String content, LocaleEnum locale, String convertType) throws Exception {

		String tTranslateCenterUrl = DWApplicationConfigUtils.getProperty("translaterUrl");

		URI tTranslateCenterUri = DWURIBuilder.create(tTranslateCenterUrl + DW_TRANSLATE_SERVICE_PATH).build();

		HttpPost tPost = new HttpPost(tTranslateCenterUri);

		ArrayNode convertTypesArrayNode = mapper.createArrayNode();
		convertTypesArrayNode.add(convertType);

		ObjectNode objectNode = mapper.createObjectNode();
		objectNode.put("content", content);
		objectNode.set("convertTypes", convertTypesArrayNode);
		StringEntity entity = new StringEntity(objectNode.toString(), "UTF-8");
		entity.setContentEncoding("UTF-8");
		tPost.setEntity(entity);
		tPost.addHeader("Content-Type", "application/json;charset=UTF-8");
		String result = dwHttpClient.execute(tPost, String.class, new DWRequestOption(false));
		JsonNode responseObject = mapper.readTree(result);
		return responseObject.get("response").get("data").get(convertType).asText();
	}
}
