package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.dao.ExecutionLogDao;
import com.digiwin.athena.itsys.dao.MonitorLogDao;
import com.digiwin.athena.itsys.dao.ProcessLogDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class LogCleanProcessor {

	@Autowired
	private ErrorMessageDao errorMessageDao;

	@Autowired
	private ProcessLogDao processLogDao;

	@Autowired
	private MonitorLogDao monitorLogDao;

	@Autowired
	private ExecutionLogDao executionLogDao;

	protected final Log log = LogFactory.getLog(getClass());

	public Map<String, Object> execute(String pTenantId) {

		errorMessageDao.deleteErrorsByTenantId(pTenantId);

		processLogDao.deleteProcessLogsByTenantId(pTenantId);

		monitorLogDao.deleteMonitorLogsByTenantId(pTenantId);

		executionLogDao.deleteExecutionLogsByTenantId(pTenantId);

		Map tReturn = new HashMap<String, String>();
		tReturn.put("result", true);
		tReturn.put("description", "");

		log.info("Delete all logs by tenant ID：" + pTenantId);

		return tReturn;
	}

}
