package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.MonitorLogDao;
import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.enums.EocLevelEnum;
import com.digiwin.athena.itsys.model.MonitorLog;
import com.digiwin.athena.itsys.model.ProcessLog;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 執行視角查詢處理
 */
@Service
public class MonitorTimeProcessor {

	@Autowired
	private ProcessLogDao processLogDao;
	@Autowired
	private MonitorLogDao monitorLogDao;

	protected final Log log = LogFactory.getLog(getClass());

	ObjectMapper mapper = new ObjectMapper();

	private SimpleDateFormat formatToSecond = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	public Map<String, Object> execute(String tenantId, String ruleCode, String eocId) throws JsonParseException,
            JsonMappingException, IOException, ParseException, DWHttpFailedException, URISyntaxException {

		ObjectNode outerNode = mapper.createObjectNode();

		ArrayNode detectDataNode = mapper.createArrayNode();

		JsonNode eocIdObject = mapper.readTree(eocId);

		Map<String, String> eocConditionMap = new HashMap<String, String>();

		if (eocIdObject.get("eocCompanyId") != null && eocIdObject.get("eocCompanyId").asText().length() != 0) {
			eocConditionMap.put(EocLevelEnum.COMPANY.getLevel(), eocIdObject.get("eocCompanyId").asText());
		}
		if (eocIdObject.get("eocSiteId") != null && eocIdObject.get("eocSiteId").asText().length() != 0) {
			eocConditionMap.put(EocLevelEnum.SITE.getLevel(), eocIdObject.get("eocSiteId").asText());
		}
		if (eocIdObject.get("eocRegionId") != null && eocIdObject.get("eocRegionId").asText().length() != 0) {
			eocConditionMap.put(EocLevelEnum.REGION.getLevel(), eocIdObject.get("eocRegionId").asText());
		}

//		找出正在執行中的偵測，並取得其開始時間(detect_time)
		List<MonitorLog> recentInitialLogs = monitorLogDao.getRecentInitialLog(tenantId, ruleCode, eocConditionMap);

		if (!recentInitialLogs.isEmpty()) {

			MonitorLog tRecentInitialLog = recentInitialLogs.get(0);

			outerNode.put("executingMonitorStartTime",
					formatToSecond.format(tRecentInitialLog.getDetectTime().getTime()));
		}
//		找出最後一筆完成的偵測
		List<MonitorLog> recentFinishedLogs = monitorLogDao.getRecentFinishedLog(tenantId, ruleCode, eocConditionMap);

		if (!recentFinishedLogs.isEmpty()) {

			MonitorLog tRecentFinishedLog = recentFinishedLogs.get(0);

			List<MonitorLog> recentFinishedInitialLogs = monitorLogDao
					.getInitialLogByTraceId(tRecentFinishedLog.getTraceId());

			if (!recentFinishedInitialLogs.isEmpty()) {

				MonitorLog tRecentFinishedInitialLog = recentFinishedInitialLogs.get(0);

				List<ProcessLog> processLogs = processLogDao.getProcessLogsByTraceId(tRecentFinishedLog.getTraceId());

//		將流程按照created_time由小到大排序

				if (!processLogs.isEmpty()) {

					Collections.sort(processLogs, new Comparator() {

						@Override
						public int compare(Object o1, Object o2) {
							return ((ProcessLog) o1).getCreatedTime().compareTo(((ProcessLog) o2).getCreatedTime());
						}

					});

					Date d1 = tRecentFinishedInitialLog.getDetectTime();
					Date d2 = processLogs.get(processLogs.size() - 1).getCreatedTime();
					long seconds = (d2.getTime() - d1.getTime()) / 1000;
					outerNode.put("lastMonitorExecutionTimeInSecond", seconds);

				} else {

					Date d1 = tRecentFinishedInitialLog.getDetectTime();
					Date d2 = tRecentFinishedLog.getCreatedTime();
					long seconds = (d2.getTime() - d1.getTime()) / 1000;
					outerNode.put("lastMonitorExecutionTimeInSecond", seconds);

				}

				if (tRecentFinishedLog.getDetectData() != null) {
					detectDataNode = (ArrayNode) mapper.readTree(tRecentFinishedLog.getDetectData());
				}
			}
		}

		outerNode.set("detectData", detectDataNode);
		Map tReturn = new HashMap<String, String>();
		tReturn.put("result", outerNode.toString());

		return tReturn;

	}

}