package com.digiwin.athena.itsys.dao;

import com.digiwin.athena.itsys.model.ErrorMessage;
import com.fasterxml.jackson.databind.JsonNode;

import java.util.List;
import java.util.Map;

public interface ErrorMessageDao extends GenericDao<ErrorMessage, Long> {

	public List<ErrorMessage> getByBusinessLogicKey(JsonNode tErrorMessage);

	List<ErrorMessage> getErrorsBySerialNumber (String pProcessSerialNumber);

	void deleteErrorsByTenantId (String pTenantId);

	List<ErrorMessage> getErrorsByTenantId (String pTenantId, Integer pageSize, Integer pageNum);

	List<ErrorMessage> fetch (Map<String, String> pConditions);

	List<ErrorMessage> getErrorsBySerialNumbers (List<String> pProcessSerialNumbers, String pTenantId);

	List<ErrorMessage> getErrorBySerialNumberAndActivityOid (String pSerailNumber, String pActivityOid);

	ErrorMessage getExceptionDetail (Long errorLogId, String processSerialNumber);

	Long getErrorLogCnt (String pTenantId);

}
