package com.digiwin.athena.itsys.dao;

import com.digiwin.athena.itsys.model.MonitorLog;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface MonitorLogDao extends GenericDao<MonitorLog, Long> {

	public List<MonitorLog> getMonitorLogsBySourceIdAndTenantId (String pSourceId, String pTenantId);

	void deleteMonitorLogsByTenantId (String pTenantId);

	List<MonitorLog> getRecentInitialLog (String pTenantId, String pRuleCode, Map<String, String> pEocConditionMap);

	List<MonitorLog> getInitialLogByTraceId (String pTraceId);

	List<MonitorLog> getRecentFinishedLog (String pTenantId, String pRuleCode, Map<String, String> pEocConditionMap);

	List<MonitorLog> getMonitorLogsByTraceIds (List<String> pTraceIds, String pTenantId);

	List<MonitorLog> getMonitorLogsByTraceIdsAndRuleCode (Collection<String> pTraceIds, String pTenantId, String ruleCode);
}
