package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.ActivityLogDao;
import com.digiwin.athena.itsys.enums.ActivityLogConditionEnum;
import com.digiwin.athena.itsys.model.ActivityLog;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

@Service
@Transactional("itsysTransactionManager")
public class ActivityLogDaoImpl extends GenericDaoImpl<ActivityLog, Long> implements ActivityLogDao {

	public ActivityLogDaoImpl() {
		super(ActivityLog.class);
	}

	SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<ActivityLog> fetch(Map<String, String> pConditions) {
		List<ActivityLog> tReturn = null;
		tReturn = (List<ActivityLog>) doHibernateQuery(pConditions);
		return tReturn;
	}

	public Object doHibernateQuery(final Map<String, String> pConditions) {

		return getHibernateTemplate().execute(new HibernateCallback<List<ActivityLog>>() {
			@Override
			public List<ActivityLog> doInHibernate(Session pSession) throws HibernateException {

				Criteria criteria = pSession.createCriteria(ActivityLog.class);

				if (pConditions.containsKey(ActivityLogConditionEnum.TENANT_ID.toString())) {
					criteria.add(Restrictions.eq("tenantId",
                                                 pConditions.get(ActivityLogConditionEnum.TENANT_ID.toString())));
				}

				if (pConditions.containsKey(ActivityLogConditionEnum.APP_ID.toString())) {
					criteria.add(Restrictions.eq("appId", pConditions.get(ActivityLogConditionEnum.APP_ID.toString())));
				}

				if (pConditions.containsKey(ActivityLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())) {
					criteria.add(Restrictions.eq("processSerialNumber",
                                                 pConditions.get(ActivityLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())));
				}

				if (pConditions.containsKey(ActivityLogConditionEnum.TASK_UID.toString())) {
					criteria.add(
                            Restrictions.eq("taskUid", pConditions.get(ActivityLogConditionEnum.TASK_UID.toString())));
				}

				if (pConditions.containsKey(ActivityLogConditionEnum.ACTIVITY_UID.toString())) {
					criteria.add(Restrictions.eq("activityUid",
                                                 pConditions.get(ActivityLogConditionEnum.ACTIVITY_UID.toString())));
				}

				if (pConditions.containsKey(ActivityLogConditionEnum.TASK_CARD_ID.toString())) {
					criteria.add(Restrictions.eq("taskCardId",
                                                 pConditions.get(ActivityLogConditionEnum.TASK_CARD_ID.toString())));
				}

				if (pConditions.containsKey(ActivityLogConditionEnum.TOP_ONE_RECORD.toString())) {
					criteria.setMaxResults(1);
				}

				return criteria.list();

			}
		});

	}

	@Override
	public List<ActivityLog> getActivityLogsBySerialNumbers(List<String> pSerialNumbers) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ActivityLog>>() {
			@Override
			public List<ActivityLog> doInHibernate(Session pSession) throws HibernateException {

				Criteria criteria = pSession.createCriteria(ActivityLog.class);
				criteria.add(Restrictions.in("processSerialNumber", pSerialNumbers));
				// criteria.add(Restrictions.in("appId", "ptm"));

				return criteria.list();

			}
		});

	}
}
