package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.model.ProcessLog;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
@Transactional("itsysTransactionManager")
public class ProcessLogDaoImpl extends GenericDaoImpl<ProcessLog, Long> implements ProcessLogDao {

	public ProcessLogDaoImpl() {
		super(ProcessLog.class);
	}

	SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<ProcessLog> fetch(Map<String, String> pConditions) {
		List<ProcessLog> tReturn = null;
		tReturn = (List<ProcessLog>) doHibernateQuery(pConditions);
		return tReturn;
	}

	public Object doHibernateQuery(final Map<String, String> pConditions) {
		Object tReturn = null;

		tReturn = getHibernateTemplate().execute(new HibernateCallback() {

			@Override
			public Object doInHibernate(Session pSession) throws HibernateException {

				StringBuilder tHqlSB = new StringBuilder();

				List<Integer> states = new ArrayList<Integer>();

				tHqlSB.append("from ProcessLog where tenantId=:tenant_id and state in (:state)");

				if (pConditions.containsKey("query_start_date")) {
					tHqlSB.append(" and DATE(createdTime)>=:query_start_date and DATE(createdTime)<=:query_end_date");
				}

				Query<ProcessLog> tQuery = pSession.createQuery(tHqlSB.toString(), ProcessLog.class);

				if (pConditions.containsKey("tenant_id")) {
					tQuery.setParameter("tenant_id", pConditions.get("tenant_id"));
				}

				if (pConditions.containsKey("query_start_date")) {
					try {
						tQuery.setParameter("query_start_date",
								formatToDate.parse(pConditions.get("query_start_date")));
						tQuery.setParameter("query_end_date", formatToDate.parse(pConditions.get("query_end_date")));
					} catch (ParseException e) {
						log.error(e.getMessage(), e);
					}
				}

				states.add(1);
				states.add(2);
				tQuery.setParameterList("state", states);

				return tQuery.getResultList();

			}
		});

		return tReturn;
	}

	@Override
	public List<ProcessLog> getProcessLogsByTraceId(String pTraceId) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ProcessLog>>() {
			@Override
			public List<ProcessLog> doInHibernate(Session pSession) throws HibernateException {

				StringBuilder tHqlSB = new StringBuilder();
				tHqlSB.append("from ProcessLog where traceId=:trace_id");
				Query<ProcessLog> tQuery = pSession.createQuery(tHqlSB.toString(), ProcessLog.class);
				tQuery.setParameter("trace_id", pTraceId);
				return tQuery.getResultList();
			}
		});

	}

	@Override
	public List<ProcessLog> getProcessLogsBySerialNumber(String pSerialNumber) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ProcessLog>>() {
			@Override
			public List<ProcessLog> doInHibernate(Session pSession) throws HibernateException {

				StringBuilder tHqlSB = new StringBuilder();
				tHqlSB.append("from ProcessLog where processSerialNumber=:processSerialNumber");
				Query<ProcessLog> tQuery = pSession.createQuery(tHqlSB.toString(), ProcessLog.class);
				tQuery.setParameter("processSerialNumber", pSerialNumber);
				return tQuery.getResultList();
			}
		});

	}

	@Override
	public List<ProcessLog> getRunningProcessesBySerialNumbers(List<String> pSerialNumbers) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ProcessLog>>() {
			@Override
			public List<ProcessLog> doInHibernate(Session pSession) throws HibernateException {

				Criteria criteria = pSession.createCriteria(ProcessLog.class);
				criteria.add(Restrictions.in("processSerialNumber", pSerialNumbers));
				criteria.add(
                        Restrictions.disjunction().add(Restrictions.eq("state", 1)).add(Restrictions.eq("state", 2)));
				return criteria.list();

			}
		});

	}

	@Override
	public void deleteProcessLogsByTenantId(String pTenantId) {

		getHibernateTemplate().execute(new HibernateCallback() {
			@Override
			public Object doInHibernate(Session pSession) throws HibernateException {
				Query tQuery = pSession.createQuery("delete ProcessLog where tenantId =:tenantId");
				tQuery.setParameter("tenantId", pTenantId);
				return tQuery.executeUpdate();
			}
		});

	}

}
