package com.digiwin.athena.itsys.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * 項目project
 * 
 */
@Entity
@Table(name = "project_log")
public class ProjectLog implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "trace_id")
	@JsonProperty("trace_id")
	private String traceId;

	@Column(name = "process_serial_number")
	@JsonProperty("process_serial_number")
	private String processSerialNumber;

	@Column(name = "app_id")
	@JsonProperty("app_id")
	private String appId;

	@Column(name = "source_ids")
	@JsonProperty("source_ids")
	private String sourceIds;

	@Column(name = "tenant_id")
	@JsonProperty("tenant_id")
	private String tenantId;

	@Column(name = "state")
	@JsonProperty("state")
	private int state;

	@Column(name = "sub_state")
	@JsonProperty("sub_state")
	private int subState;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "last_update_time")
	private Calendar lastUpdateTime;

	@Column(name = "created_time")
	private Date createdTime;

	@Column(name = "completed_time")
	private Date completedTime;

	@Column(name = "person_in_charge")
	@JsonProperty("person_in_charge")
	private String personInCharge;

	@Column(name = "person_in_charge_name")
	@JsonProperty("person_in_charge_name")
	private String personInChargeName;

	@Column(name = "project_name_zh_tw")
	@JsonProperty("project_name_zh_tw")
	private String projectNameZhTw;

	@Column(name = "project_name_zh_cn")
	@JsonProperty("project_name_zh_cn")
	private String projectNameZhCn;

	@Column(name = "project_name_en_us")
	@JsonProperty("project_name_en_us")
	private String projectNameEnUs;

	@Column(name = "project_start_time")
	private Date projectStartTime;

	@Column(name = "project_end_time")
	private Date projectEndTime;

	@Column(name = "project_id")
	@JsonProperty("project_id")
	private String projectId;

	@Column(name = "project_card_id")
	@JsonProperty("project_card_id")
	private String projectCardId;

	@Column(name = "app_name_zh_cn")
	@JsonProperty("app_name_zh_cn")
	private String appNameZhCn;

	@Column(name = "app_name_zh_tw")
	@JsonProperty("app_name_zh_tw")
	private String appNameZhTw;

	@Column(name = "app_name_en_us")
	@JsonProperty("app_name_en_us")
	private String appNameEnUs;

	@Column(name = "app_code")
	@JsonProperty("app_code")
	private String appCode;

	@Column(name = "project_code")
	@JsonProperty("project_code")
	private String projectCode;

	public ProjectLog() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Calendar getBuildTime() {
		return this.buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getProcessSerialNumber() {
		return processSerialNumber;
	}

	public void setProcessSerialNumber(String processSerialNumber) {
		this.processSerialNumber = processSerialNumber;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public int getState() {
		return state;
	}

	public void setState(int state) {
		this.state = state;
	}

	public int getSubState() {
		return subState;
	}

	public void setSubState(int subState) {
		this.subState = subState;
	}

	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	public Date getCompletedTime() {
		return completedTime;
	}

	public void setCompletedTime(Date completedTime) {
		this.completedTime = completedTime;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public Calendar getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(Calendar lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	public String getPersonInCharge() {
		return personInCharge;
	}

	public void setPersonInCharge(String personInCharge) {
		this.personInCharge = personInCharge;
	}

	public Date getProjectStartTime() {
		return projectStartTime;
	}

	public void setProjectStartTime(Date projectStartTime) {
		this.projectStartTime = projectStartTime;
	}

	public Date getProjectEndTime() {
		return projectEndTime;
	}

	public void setProjectEndTime(Date projectEndTime) {
		this.projectEndTime = projectEndTime;
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	public String getProjectCardId() {
		return projectCardId;
	}

	public void setProjectCardId(String projectCardId) {
		this.projectCardId = projectCardId;
	}

	public String getProjectNameZhTw() {
		return projectNameZhTw;
	}

	public void setProjectNameZhTw(String projectNameZhTw) {
		this.projectNameZhTw = projectNameZhTw;
	}

	public String getProjectNameZhCn() {
		return projectNameZhCn;
	}

	public void setProjectNameZhCn(String projectNameZhCn) {
		this.projectNameZhCn = projectNameZhCn;
	}

	public String getProjectNameEnUs() {
		return projectNameEnUs;
	}

	public void setProjectNameEnUs(String projectNameEnUs) {
		this.projectNameEnUs = projectNameEnUs;
	}

	public String getSourceIds() {
		return sourceIds;
	}

	public void setSourceIds(String sourceIds) {
		this.sourceIds = sourceIds;
	}

	public String getPersonInChargeName() {
		return personInChargeName;
	}

	public void setPersonInChargeName(String personInChargeName) {
		this.personInChargeName = personInChargeName;
	}

	public String getAppNameZhCn() {
		return appNameZhCn;
	}

	public void setAppNameZhCn(String appNameZhCn) {
		this.appNameZhCn = appNameZhCn;
	}

	public String getAppNameZhTw() {
		return appNameZhTw;
	}

	public void setAppNameZhTw(String appNameZhTw) {
		this.appNameZhTw = appNameZhTw;
	}

	public String getAppNameEnUs() {
		return appNameEnUs;
	}

	public void setAppNameEnUs(String appNameEnUs) {
		this.appNameEnUs = appNameEnUs;
	}

	public String getAppCode() {
		return appCode;
	}

	public void setAppCode(String appCode) {
		this.appCode = appCode;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

}