package com.digiwin.athena.itsys.queue.rabbitmq;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.impl.ForgivingExceptionHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.Map;

public class Consumer {

	private Log log = LogFactory.getLog(getClass());

	ConnectionFactory factory = new ConnectionFactory();
	Connection connection;
	Channel channel;

	public Consumer (MessageQueueTypeEnum queueType) {
		buildChannel(queueType);
	}

	public void buildChannel(MessageQueueTypeEnum queueType) {
		try {

			factory.setVirtualHost(DWApplicationConfigUtils.getProperty("mq.vhost"));
			factory.setHost(DWApplicationConfigUtils.getProperty("mq.host"));
			factory.setUsername(DWApplicationConfigUtils.getProperty("mq.user"));
			factory.setPassword(DWApplicationConfigUtils.getProperty("mq.password"));
			factory.setPort(
					Integer.valueOf(DWApplicationConfigUtils.getProperty("mq.amqp.ssl.port")));
			factory.setExceptionHandler(new ForgivingExceptionHandler());
			factory.setAutomaticRecoveryEnabled(true);
			factory.setTopologyRecoveryEnabled(true);
			factory.setRequestedHeartbeat(10);
			connection = factory.newConnection();
			channel = connection.createChannel();
			channel.basicQos(5);

			// 建立queue(declare a durable queue with the exclusive and auto-delete properties
			// disabled)
			Map<String, Object> queueArguments = new HashMap<String, Object>();
			channel.queueDeclare(queueType.getQueueName(), true, false, false, queueArguments);

			// 建立exchange
			channel.exchangeDeclare("it.sys.exchange", BuiltinExchangeType.DIRECT, true);

			// 建立binding
			channel.queueBind(queueType.getQueueName(), "it.sys.exchange", queueType.getBinding());

		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
	}

	public ConnectionFactory getFactory() {
		return factory;
	}

	public void setFactory(ConnectionFactory factory) {
		this.factory = factory;
	}

	public Connection getConnection() {
		return connection;
	}

	public void setConnection(Connection connection) {
		this.connection = connection;
	}

	public Channel getChannel() {
		return channel;
	}

	public void setChannel(Channel channel) {
		this.channel = channel;
	}

}