package com.digiwin.athena.itsys.service;

import com.digiwin.athena.itsys.enums.ActivityLogConditionEnum;
import com.digiwin.athena.itsys.enums.MappingTypeEnum;
import com.digiwin.athena.itsys.model.*;

import java.util.*;

@org.springframework.stereotype.Service
public class LogManipulateService {

	/** 用MappingTypeEnum將異常做分組 **/
	public Map<String, List<ErrorMessage>> mapErrorMessageByType(List<ErrorMessage> errorMessages, String pType) {

		Map<String, List<ErrorMessage>> returnMap = new HashMap<String, List<ErrorMessage>>();

		if (pType.equals(MappingTypeEnum.SERIAL_NUMBER.getType())) {

			for (ErrorMessage errorMessage : errorMessages) {
				if (returnMap.get(errorMessage.getProcessSerialNumber()) != null) {
					returnMap.get(errorMessage.getProcessSerialNumber()).add(errorMessage);
				} else {
					List<ErrorMessage> errorList = new ArrayList<>();
					errorList.add(errorMessage);
					returnMap.put(errorMessage.getProcessSerialNumber(), errorList);
				}
			}
		} else if (pType.equals(MappingTypeEnum.TRACE_ID.getType())) {
			for (ErrorMessage errorMessage : errorMessages) {
				if (returnMap.get(errorMessage.getTraceId()) != null) {
					returnMap.get(errorMessage.getTraceId()).add(errorMessage);
				} else {
					List<ErrorMessage> errorList = new ArrayList<>();
					errorList.add(errorMessage);
					returnMap.put(errorMessage.getTraceId(), errorList);
				}
			}
		}

		return returnMap;

	}

	/** 用MappingTypeEnum將流程做分組 **/
	public Map<String, List<ProcessLog>> mapProcessLogByType(List<ProcessLog> processLogs, String pType) {

		Map<String, List<ProcessLog>> returnMap = new HashMap<String, List<ProcessLog>>();

		if (pType.equals(MappingTypeEnum.SERIAL_NUMBER.getType())) {

			for (ProcessLog processLog : processLogs) {
				if (returnMap.get(processLog.getProcessSerialNumber()) != null) {
					returnMap.get(processLog.getProcessSerialNumber()).add(processLog);
				} else {
					List<ProcessLog> processLogList = new ArrayList<ProcessLog>();
					processLogList.add(processLog);
					returnMap.put(processLog.getProcessSerialNumber(), processLogList);
				}
			}
		} else if (pType.equals(MappingTypeEnum.TRACE_ID.getType())) {

			for (ProcessLog processLog : processLogs) {
				if (returnMap.get(processLog.getTraceId()) != null) {
					returnMap.get(processLog.getTraceId()).add(processLog);
				} else {
					List<ProcessLog> processLogList = new ArrayList<ProcessLog>();
					processLogList.add(processLog);
					returnMap.put(processLog.getTraceId(), processLogList);
				}
			}
		}

		return returnMap;

	}

	public Map<String, List<MonitorLog>> mapMonitorLogByType(List<MonitorLog> MonitorLogs, String pType) {

		Map<String, List<MonitorLog>> returnMap = new HashMap<String, List<MonitorLog>>();

		if (pType.equals(MappingTypeEnum.TRACE_ID.getType())) {

			for (com.digiwin.athena.itsys.model.MonitorLog MonitorLog : MonitorLogs) {
				if (returnMap.get(MonitorLog.getTraceId()) != null) {
					returnMap.get(MonitorLog.getTraceId()).add(MonitorLog);
				} else {
					List<com.digiwin.athena.itsys.model.MonitorLog> MonitorLogList = new ArrayList<com.digiwin.athena.itsys.model.MonitorLog>();
					MonitorLogList.add(MonitorLog);
					returnMap.put(MonitorLog.getTraceId(), MonitorLogList);
				}
			}
		}

		return returnMap;

	}

	/** 用MappingTypeEnum將項目做分組 **/
	public Map<String, List<ProjectLog>> mapProjectLogByType(List<ProjectLog> projectLogs, String pType) {

		Map<String, List<ProjectLog>> returnMap = new HashMap<String, List<ProjectLog>>();

		if (pType.equals(MappingTypeEnum.SERIAL_NUMBER.getType())) {

			for (ProjectLog projectLog : projectLogs) {
				if (returnMap.get(projectLog.getProcessSerialNumber()) != null) {
					returnMap.get(projectLog.getProcessSerialNumber()).add(projectLog);
				} else {
					List<ProjectLog> projectLogList = new ArrayList<ProjectLog>();
					projectLogList.add(projectLog);
					returnMap.put(projectLog.getProcessSerialNumber(), projectLogList);
				}
			}
		} else if (pType.equals(MappingTypeEnum.TRACE_ID.getType())) {

			for (ProjectLog projectLog : projectLogs) {
				if (returnMap.get(projectLog.getTraceId()) != null) {
					returnMap.get(projectLog.getTraceId()).add(projectLog);
				} else {
					List<ProjectLog> projectLogList = new ArrayList<ProjectLog>();
					projectLogList.add(projectLog);
					returnMap.put(projectLog.getTraceId(), projectLogList);
				}
			}
		} else if (pType.equals(MappingTypeEnum.APP_ID.getType())) {

			for (ProjectLog projectLog : projectLogs) {
				if (returnMap.get(projectLog.getAppId()) != null) {
					returnMap.get(projectLog.getAppId()).add(projectLog);
				} else {
					List<ProjectLog> projectLogList = new ArrayList<ProjectLog>();
					projectLogList.add(projectLog);
					returnMap.put(projectLog.getAppId(), projectLogList);
				}
			}
		}

		return returnMap;

	}

	/** 用MappingTypeEnum將任務做分組 **/
	public Map<String, List<TaskLog>> mapTaskLogByType(List<TaskLog> taskLogs, String pType) {

		Map<String, List<TaskLog>> returnMap = new HashMap<String, List<TaskLog>>();

		if (pType.equals(MappingTypeEnum.TASK_UID.getType())) {

			for (TaskLog taskLog : taskLogs) {
				if (returnMap.get(taskLog.getTaskUid()) != null) {
					returnMap.get(taskLog.getTaskUid()).add(taskLog);
				} else {
					List<TaskLog> taskLogList = new ArrayList<TaskLog>();
					taskLogList.add(taskLog);
					returnMap.put(taskLog.getTaskUid(), taskLogList);
				}
			}
		} else if (pType.equals(MappingTypeEnum.APP_ID.getType())) {

			for (TaskLog taskLog : taskLogs) {
				if (returnMap.get(taskLog.getAppId()) != null) {
					returnMap.get(taskLog.getAppId()).add(taskLog);
				} else {
					List<TaskLog> taskLogList = new ArrayList<TaskLog>();
					taskLogList.add(taskLog);
					returnMap.put(taskLog.getAppId(), taskLogList);
				}
			}
		}

		return returnMap;

	}

	/**
	 * 將projectLogMapBySerialNumber中重複的projectLog剃除，優先取app_id =
	 * ptm的最新紀錄，沒有的話則取app_id = taskengine的最新紀錄
	 **/
	public void sortLatestProjectLog(Map<String, List<ProjectLog>> pProjectLogMaps) {

		for (String tSerialNmber : pProjectLogMaps.keySet()) {
			// (new)用app_id將項目分組[tProjectLogMapByAppId]
			Map<String, List<ProjectLog>> tProjectLogMapByAppId = mapProjectLogByType(pProjectLogMaps.get(tSerialNmber),
                                                                                      MappingTypeEnum.APP_ID.getType());

			if (tProjectLogMapByAppId.get("ptm") != null) {
				Collections.sort(tProjectLogMapByAppId.get("ptm"), new Comparator() {
					@Override
					public int compare(Object o1, Object o2) {
						return ((ProjectLog) o1).getBuildTime().getTime()
								.compareTo(((ProjectLog) o2).getBuildTime().getTime());
					}
				});

				List<ProjectLog> latestLog = new ArrayList<ProjectLog>();

				latestLog.add(tProjectLogMapByAppId.get("ptm").get(tProjectLogMapByAppId.get("ptm").size() - 1));

				pProjectLogMaps.put(tSerialNmber, latestLog);
			} else if (tProjectLogMapByAppId.get("taskengine") != null) {
				Collections.sort(tProjectLogMapByAppId.get("taskengine"), new Comparator() {

					@Override
					public int compare(Object o1, Object o2) {
						return ((ProjectLog) o1).getBuildTime().getTime()
								.compareTo(((ProjectLog) o2).getBuildTime().getTime());
					}
				});

				List<ProjectLog> latestLog = new ArrayList<ProjectLog>();

				latestLog.add(tProjectLogMapByAppId.get("taskengine")
						.get(tProjectLogMapByAppId.get("taskengine").size() - 1));

				pProjectLogMaps.put(tSerialNmber, latestLog);
			}

		}
	}

	/** 取得最新的taskLog任務紀錄 **/
	public TaskLog getLatestTaskLog(List<TaskLog> pTaskLogs) {

		TaskLog tReturnTaskLog = null;

		Map<String, List<TaskLog>> tTaskLogMapByAppId = mapTaskLogByType(pTaskLogs, MappingTypeEnum.APP_ID.getType());
		// 有ptm的任務紀錄
		if (tTaskLogMapByAppId.get("ptm") != null) {

			Collections.sort(tTaskLogMapByAppId.get("ptm"), new Comparator() {
				@Override
				public int compare(Object o1, Object o2) {
					return ((TaskLog) o1).getBuildTime().getTime().compareTo(((TaskLog) o2).getBuildTime().getTime());
				}
			});

			tReturnTaskLog = tTaskLogMapByAppId.get("ptm").get(tTaskLogMapByAppId.get("ptm").size() - 1);
		} else if (tTaskLogMapByAppId.get("taskengine") != null) {
			Collections.sort(tTaskLogMapByAppId.get("taskengine"), new Comparator() {

				@Override
				public int compare(Object o1, Object o2) {
					return ((TaskLog) o1).getBuildTime().getTime().compareTo(((TaskLog) o2).getBuildTime().getTime());
				}

			});
			tReturnTaskLog = tTaskLogMapByAppId.get("taskengine").get(tTaskLogMapByAppId.get("taskengine").size() - 1);
		}

		return tReturnTaskLog;
	}

	public void sortLatestMonitorLog(Map<String, List<MonitorLog>> pMonitorLogMaps) {

		for (String tTraceId : pMonitorLogMaps.keySet()) {

			if (!pMonitorLogMaps.get(tTraceId).isEmpty()) {

				Collections.sort(pMonitorLogMaps.get(tTraceId), new Comparator() {
					@Override
					public int compare(Object o1, Object o2) {
						return ((MonitorLog) o1).getBuildTime().getTime()
								.compareTo(((MonitorLog) o2).getBuildTime().getTime());
					}
				});

				List<MonitorLog> latestLog = new ArrayList<MonitorLog>();

				latestLog.add(pMonitorLogMaps.get(tTraceId).get(pMonitorLogMaps.get(tTraceId).size() - 1));

				pMonitorLogMaps.put(tTraceId, latestLog);
			}
		}
	}

	public List<TaskLog> getTargetTaskLogs(List<TaskLog> pAllTaskLogs, Map<String, String> pCondition) {

		List<TaskLog> tFilterResult = new ArrayList<TaskLog>();
		List<TaskLog> result = new ArrayList<TaskLog>();

		tFilterResult.addAll(pAllTaskLogs);
		result.addAll(pAllTaskLogs);

		for (String conditionKey : pCondition.keySet()) {
			switch (conditionKey) {
			case "TENANT_ID":
				for (TaskLog taskLog : tFilterResult) {
					if (pCondition.get(conditionKey) == null) {
						result.remove(taskLog);
					} else if (!pCondition.get(conditionKey).equals(taskLog.getTenantId())) {
						result.remove(taskLog);
					}
				}

				break;
			case "PROCESS_SERIAL_NUMBER":
				for (TaskLog taskLog : tFilterResult) {
					if (pCondition.get(conditionKey) == null) {
						result.remove(taskLog);
					} else if (!pCondition.get(conditionKey).equals(taskLog.getProcessSerialNumber())) {
						result.remove(taskLog);
					}
				}

				break;
			case "TASK_UID":
				for (TaskLog taskLog : tFilterResult) {
					if (pCondition.get(conditionKey) == null) {
						result.remove(taskLog);
					} else if (!pCondition.get(conditionKey).equals(taskLog.getTaskUid())) {
						result.remove(taskLog);
					}
				}

				break;

			default:
				break;
			}
			tFilterResult.clear();

			tFilterResult.addAll(result);
		}

		return result;
	}

	public List<ActivityLog> getTargetActivityLogs(List<ActivityLog> pAllActivityLogs, Map<String, String> pCondition) {

		List<ActivityLog> tFilterResult = new ArrayList<ActivityLog>();
		List<ActivityLog> result = new ArrayList<ActivityLog>();

		tFilterResult.addAll(pAllActivityLogs);
		result.addAll(pAllActivityLogs);

		for (String conditionKey : pCondition.keySet()) {

			switch (conditionKey) {
			case "TENANT_ID":
				for (ActivityLog activityLog : tFilterResult) {
					if (pCondition.get(conditionKey) == null) {
						result.remove(activityLog);
					} else if (!pCondition.get(conditionKey).equals(activityLog.getTenantId())) {
						result.remove(activityLog);
					}
				}

				break;
			case "APP_ID":
				for (ActivityLog activityLog : tFilterResult) {
					if (pCondition.get(conditionKey) == null) {
						result.remove(activityLog);
					} else if (!pCondition.get(conditionKey).equals(activityLog.getAppId())) {
						result.remove(activityLog);
					}
				}

				break;
			case "TASK_UID":
				for (ActivityLog activityLog : tFilterResult) {
					if (pCondition.get(conditionKey) == null) {
						result.remove(activityLog);
					} else if (!pCondition.get(conditionKey).equals(activityLog.getTaskUid())) {
						result.remove(activityLog);
					}
				}

				break;
			case "ACTIVITY_UID":
				for (ActivityLog activityLog : tFilterResult) {

					if (pCondition.get(conditionKey) == null) {
						result.remove(activityLog);
					} else if (!pCondition.get(conditionKey).equals(activityLog.getActivityUid())) {
						result.remove(activityLog);
					}
				}

				break;
			case "TASK_CARD_ID":
				for (ActivityLog activityLog : tFilterResult) {

					if (pCondition.get(conditionKey) == null) {
						result.remove(activityLog);
					} else if (!pCondition.get(conditionKey).equals(activityLog.getTaskCardId())) {
						result.remove(activityLog);
					}
				}

				break;

			default:
				break;
			}
			tFilterResult.clear();

			tFilterResult.addAll(result);
		}

		if (!result.isEmpty() && pCondition.containsKey(ActivityLogConditionEnum.TOP_ONE_RECORD.toString())) {

			Collections.sort(result, new Comparator() {
				@Override
				public int compare(Object o1, Object o2) {
					return ((ActivityLog) o1).getBuildTime().getTime()
							.compareTo(((ActivityLog) o2).getBuildTime().getTime());
				}
			});

			List<ActivityLog> latestLog = new ArrayList<ActivityLog>();

			latestLog.add(result.get(result.size() - 1));

			result = latestLog;
		}

		return result;
	}
}
