/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.aop;

import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.service.impl.BMRedirectService;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BMAppInfoInterceptor
implements MethodInterceptor {
    private static final String CLASS_LOG_TAG = "[" + BMAppInfoInterceptor.class.getSimpleName() + "]";
    private static Logger logger = LoggerFactory.getLogger(BMAppInfoInterceptor.class);
    @Autowired(required=false)
    BMRedirectService bmRedirectService;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        logger.debug(CLASS_LOG_TAG + " invoke eaiId({})", (Object)digiServiceName);
        Object[] objects = invocation.getArguments();
        Map headers = (Map)objects[0];
        Map messageBody = (Map)objects[1];
        DWEAIResult dwEaiResult = (DWEAIResult)this.bmRedirectService.invokeBMDService(headers, messageBody);
        String eaiResutlCode = dwEaiResult.getCode();
        if (!NumberUtils.isDigits((String)eaiResutlCode) || !eaiResutlCode.equals("0")) {
            Map parameter = dwEaiResult.getParameter();
            logger.debug("getMetadata: error code({}), parameter({})", (Object)eaiResutlCode, (Object)parameter);
        } else if (BMConstants.SERVICE_MODEL_PUBLISH.contains(digiServiceName)) {
            dwEaiResult = (DWEAIResult)invocation.proceed();
        }
        return dwEaiResult;
    }
}

