/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeCrudInterceptor
extends DWEAICommonCrudInterceptor {
    private static Logger logger = LoggerFactory.getLogger(CustomizeCrudInterceptor.class);
    private static final String CLASS_LOG_TAG = "[" + CustomizeCrudInterceptor.class.getSimpleName() + "]";
    Map<String, LinkedList<DWEAICrudInvocationListener>> listeners = new HashMap<String, LinkedList<DWEAICrudInvocationListener>>();

    @Override
    public Map<String, LinkedList<DWEAICrudInvocationListener>> getListeners() {
        return this.listeners;
    }

    @Override
    public void setListeners(Map<String, LinkedList<DWEAICrudInvocationListener>> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void register(String eaiId, DWEAICrudInvocationListener listener) {
        LinkedList<DWEAICrudInvocationListener> linkedLists = this.listeners.getOrDefault(eaiId, new LinkedList());
        linkedLists.add(listener);
        this.listeners.put(eaiId, linkedLists);
        logger.debug("{} add eaiId({}), listener({})", new Object[]{CLASS_LOG_TAG, eaiId, listener.getClass().getTypeName()});
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result;
        block13: {
            String digiServiceName;
            block12: {
                digiServiceName = DWServiceContext.getContext().getDigiServiceName();
                logger.debug("{} invoke eaiId({})", (Object)CLASS_LOG_TAG, (Object)digiServiceName);
                LinkedList<DWEAICrudInvocationListener> serviceListeners = this.listeners.get(digiServiceName);
                result = null;
                if (!CollectionUtils.isNotEmpty(serviceListeners)) break block12;
                Object[] objects = invocation.getArguments();
                Map headers = (Map)objects[0];
                Object messageBody = objects[1];
                StopWatch stopWatch = StopWatch.createStarted();
                StringBuffer timeRecord = new StringBuffer();
                try {
                    timeRecord.append(String.format("beforeInvoke(%d) ", stopWatch.getTime()));
                    logger.debug(timeRecord.toString());
                    for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                        logger.debug("{} invoke ({}) , service({}) interceptor({}) beforeInvoke ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
                        targetListener.beforeInvoke(headers, messageBody);
                    }
                    timeRecord.append(String.format("afterBeforeInvoke(%d) ", stopWatch.getTime()));
                    result = invocation.proceed();
                    timeRecord.append(String.format("invocation.proceed()(%d) ", stopWatch.getTime()));
                    for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                        logger.debug("{} invoke ({}) , service({}) interceptor({}) around ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
                        targetListener.around(headers, messageBody);
                    }
                }
                catch (Throwable e) {
                    try {
                        timeRecord.append(String.format("before doException(%d) ", stopWatch.getTime()));
                        for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                            logger.debug("{} invoke ({}) , service({}) interceptor({}) doException ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
                            targetListener.doException(e);
                        }
                        timeRecord.append(String.format("after doException(%d) ", stopWatch.getTime()));
                        if (!stopWatch.isStopped()) {
                            stopWatch.stop();
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                            logger.debug("{} invoke ({}) , service({}) interceptor({}) afterInvoke ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
                            targetListener.afterInvoke(invocation, result);
                        }
                        if (!stopWatch.isStopped()) {
                            stopWatch.stop();
                        }
                        throw throwable;
                    }
                }
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug("{} invoke ({}) , service({}) interceptor({}) afterInvoke ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
                    targetListener.afterInvoke(invocation, result);
                }
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                break block13;
            }
            logger.debug(" didn't have registered interceptor when invoke eaiId({})", (Object)CLASS_LOG_TAG, (Object)digiServiceName);
            result = invocation.proceed();
        }
        return result;
    }
}

