/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListenerRegistry;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledCondition;
import com.digiwin.lcdp.modeldriven.customize.BMDInvoker;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.aop.BMAppInfoInterceptor;
import com.digiwin.lcdp.modeldriven.customize.aop.BMCrudInterceptor;
import com.digiwin.lcdp.modeldriven.customize.config.CustomizeAutoConfiguration;
import com.digiwin.lcdp.modeldriven.customize.config.condition.BMAdapterCondition;
import com.digiwin.lcdp.modeldriven.customize.config.condition.BMRoleCondition;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.constants.CustomizeConstants;
import com.digiwin.lcdp.modeldriven.customize.eai.BMEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterDefaultCustomizeHandler;
import com.digiwin.lcdp.modeldriven.customize.handler.BMDefaultCRUDHandler;
import com.digiwin.lcdp.modeldriven.customize.handler.ICustomizeCRUDHandler;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.registry.BMBusinessLayerRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.service.impl.BMRedirectService;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.utils.ModelDrivenESPUtil;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import com.digiwin.lcdp.modeldriven.utils.json.ModelDrivenJacksonUtil;
import com.digiwin.lcdp.modeldriven.utils.service.RegTypeUtil;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.aop.Advice;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

@Configuration
@Conditional(value={ModelDrivenEnabledCondition.class, BMRoleCondition.class})
@ConditionalOnBean(value={CustomizeAutoConfiguration.class})
@AutoConfigureAfter(value={CustomizeAutoConfiguration.class})
public class BMAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BMAutoConfiguration.class);
    private static final String CLASS_LOG_TAG = "[" + BMAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"modeldriven-customize-bm-crud-adapter"})
    @Conditional(value={BMAdapterCondition.class})
    public Object getBMAdapter() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String adapterName = BMProperties.getProperties().getBmCrudAdapter();
        Object bmAdapterImplClazz = Class.forName(adapterName).newInstance();
        log.info("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"modeldriven-customize-bm-crud-adapter");
        return bmAdapterImplClazz;
    }

    @Bean(name={"lcdp-bm-eai-method-repo"})
    public BMEaiMethodRepository getModelDrivenEaiMethodRepository(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider) {
        Map commonsInterfaces = serviceCommonsProvider.getInterfaceServices();
        List interfList = (List)commonsInterfaces.get("commons");
        Optional<Class<?>> bmEaiClazz = interfList.stream().filter(p -> p.getTypeName().equals(CustomizeConstants.CUSTOMIZE_COMMON_BM_CRUD_INTERFACE_NAME)).findFirst();
        Method[] commonsCrudEaiClazzMethods = bmEaiClazz.get().getMethods();
        BMEaiMethodRepository bmEaiMethodRepo = new BMEaiMethodRepository();
        bmEaiMethodRepo.setEaiClazz(bmEaiClazz);
        for (Method method : commonsCrudEaiClazzMethods) {
            ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO;
            String[] methodIdToken;
            String methodIdPrefix;
            if (!method.isAnnotationPresent(EAIService.class)) continue;
            EAIService methodAnnotation = method.getAnnotation(EAIService.class);
            String methodAnnotEaiId = methodAnnotation.id();
            for (String postFix : BMConstants.BM_METHOD_POSTFIX_ALL) {
                if (!methodAnnotEaiId.endsWith(postFix)) continue;
                String[] postFixToken = postFix.split("\\.");
                String eaiServicePostfix = postFixToken[2];
                if (postFixToken.length > 3) {
                    for (int i = 3; i < postFixToken.length; ++i) {
                        eaiServicePostfix = String.join((CharSequence)".", eaiServicePostfix, postFixToken[i]);
                    }
                }
                ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO2 = EaiServiceUtil.getModelDrivenEaiMethodDTO(method, methodAnnotEaiId, eaiServicePostfix, bmEaiClazz);
                log.debug("{} serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", new Object[]{CLASS_LOG_TAG, methodAnnotEaiId, eaiServicePostfix});
                bmEaiMethodRepo.add(methodAnnotEaiId, modelDrivenEaiMethodDTO2);
            }
            if (methodAnnotEaiId.endsWith(".crud.eai.get")) {
                bmEaiMethodRepo.setListGetMethod(method);
                for (String eaiServicePostfix : BMConstants.SERVICE_GET_TYPE_POSTFIX) {
                    methodIdPrefix = "";
                    methodIdToken = methodAnnotEaiId.split("\\.");
                    for (int i = 0; i < methodIdToken.length - 1; ++i) {
                        methodIdPrefix = i != 0 ? String.join((CharSequence)".", methodIdPrefix, methodIdToken[i]) : methodIdToken[i];
                    }
                    String eaiId = String.join((CharSequence)".", methodIdPrefix, eaiServicePostfix);
                    modelDrivenEaiMethodDTO = EaiServiceUtil.getModelDrivenEaiMethodDTO(method, eaiId, eaiServicePostfix, bmEaiClazz);
                    log.debug("{} serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", new Object[]{CLASS_LOG_TAG, methodAnnotEaiId, eaiServicePostfix});
                    bmEaiMethodRepo.add(eaiId, modelDrivenEaiMethodDTO);
                }
            }
            if (!methodAnnotEaiId.endsWith(".crud.eai.update")) continue;
            for (String eaiServicePostfix : BMConstants.SERVICE_VALID_TYPE_POSTFIX) {
                methodIdPrefix = "";
                methodIdToken = methodAnnotEaiId.split("\\.");
                for (int i = 0; i < methodIdToken.length - 1; ++i) {
                    methodIdPrefix = i != 0 ? String.join((CharSequence)".", methodIdPrefix, methodIdToken[i]) : methodIdToken[i];
                }
                String methodRepoId = String.join((CharSequence)".", methodIdPrefix, eaiServicePostfix);
                modelDrivenEaiMethodDTO = EaiServiceUtil.getModelDrivenEaiMethodDTO(method, methodRepoId, eaiServicePostfix, bmEaiClazz);
                log.debug("{} serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", new Object[]{CLASS_LOG_TAG, methodAnnotEaiId, eaiServicePostfix});
                bmEaiMethodRepo.add(methodRepoId, modelDrivenEaiMethodDTO);
            }
        }
        return bmEaiMethodRepo;
    }

    @Bean(value={"modeldriven-customize-bm-crud-handler"})
    public ICustomizeCRUDHandler getCustomizeRuntimeHandler() {
        BMDefaultCRUDHandler customizeCrudHandler = new BMDefaultCRUDHandler();
        log.info("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"modeldriven-customize-bm-crud-handler");
        return customizeCrudHandler;
    }

    @Bean(value={"modeldriven-customize-bm-adapter-handler"})
    public BMAdapterCustomizeHandler bmAdapterHandler() {
        BMAdapterDefaultCustomizeHandler bmAdapterDefaultHandler = new BMAdapterDefaultCustomizeHandler();
        log.info("{} bean:{} created!", (Object)CLASS_LOG_TAG, (Object)"modeldriven-customize-bm-adapter-handler");
        return bmAdapterDefaultHandler;
    }

    @Bean(value={"dw-modeldriven-customize-bm-crud-eai-interceptor"})
    public BMCrudInterceptor getBMCrudInterceptor(@Qualifier(value="modeldriven-customize-bm-adapter-handler") BMAdapterCustomizeHandler bmAdapterHandler) {
        BMCrudInterceptor interceptor = new BMCrudInterceptor();
        log.info("{} bean:eai {} created!", (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-customize-bm-crud-eai-interceptor");
        return interceptor;
    }

    @Primary
    @Bean(name={"dw-modeldriven-commons-eai-crud-advisor"})
    public Advisor dwEAICommonServiceAdvisor(@Qualifier(value="dw-modeldriven-service-commons-eai-registry") DWEAICrudInvocationListenerRegistry registry) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        String bmExpress = "execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getList(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.get(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.put(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putValid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.putInvalid(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.delete(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.post(..))  || execution(* " + CustomizeConstants.CUSTOMIZE_COMMON_BM_CRUD_INTERFACE_NAME + ".*(..))";
        pointcut.setExpression(bmExpress);
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)((DWEAICommonCrudInterceptor)registry));
        log.info("{} bean:eai {} created!", (Object)CLASS_LOG_TAG, (Object)"dw-modeldriven-commons-eai-crud-advisor");
        return advisor;
    }

    @Bean(name={"modeldriven-customize-crud-eai-builder"})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="bm")
    public EaiHeaderBuilder bmEaiHeaderBuilder() {
        return new BMEaiHeaderBuilder();
    }

    @Bean
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="bm")
    public BMAbstractRegistryApplicationListener buildBMNacosRegistionApplicationListener() {
        return new BMBusinessLayerRegistryApplicationListener();
    }

    @Bean(name={"modeldriven-customize-genEaiHeaders"})
    @DependsOn(value={"modeldriven-tech-eaiheader"})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="bm")
    public Object autoGenBMEaiHeaders(@Qualifier(value="modeldriven-tech-eaiheader") TechEaiData targetTechEaiData, BMDInvoker bmdInvoker, EaiHeaderUtil eaiHeaderUtil, ESPLoadBalanceUtil espLoadBalanceUtil) throws JsonProcessingException {
        Map<String, List<DWEAIHeader>> newTechEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        String bmTargetProds = DWApplicationConfigUtils.getProperty((String)"lcdp.bm.target.prod");
        if (StringUtils.isBlank((CharSequence)bmTargetProds)) {
            log.warn("{}[genEaiHeaders] *** BM *** bmTargetProds is blank(properties:{} is not configured)", (Object)CLASS_LOG_TAG, (Object)"lcdp.bm.target.prod");
        } else {
            BMRole currentBMRole = BMProperties.getProperties().getRole();
            ModelDrivenESPUtil.initEspSdkInvoker();
            List bmTargetProdList = Stream.of(bmTargetProds.split(",")).collect(Collectors.toList());
            LinkedBlockingDeque<Object> queue = new LinkedBlockingDeque<Object>();
            queue.addAll(bmTargetProdList);
            String bmdProdForQueryModelData = null;
            DWEAIResult result = null;
            while ((bmdProdForQueryModelData = (String)queue.poll()) != null) {
                try {
                    result = bmdInvoker.invokeGetBMDCodes(bmdProdForQueryModelData);
                    if ("0".equals(result.getCode())) break;
                    log.error("{} <<< get codes failed from target prod:{},caused by :{},it'll be try another target prod", new Object[]{CLASS_LOG_TAG, bmdProdForQueryModelData, result.getDescription()});
                    queue.add(bmdProdForQueryModelData);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Exception e) {
                    String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                    log.error("{} <<< get codes failed from target prod:{},it'll be try another target prod", new Object[]{CLASS_LOG_TAG, bmdProdForQueryModelData, errorRootCauseMessage});
                    queue.add(bmdProdForQueryModelData);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Map params = result.getParameter();
            String serviceMappingStr = ModelDrivenJacksonUtil.toJson(params.get("serviceMapping"));
            List<DWServiceMapping> serviceMappings = ModelDrivenJacksonUtil.fromJson(serviceMappingStr, new TypeReference<List<DWServiceMapping>>(){});
            String modelInfoStrFromServiceMapping = ModelDrivenJacksonUtil.toJson(params.get("mappingModelInfos"));
            List<MappingModelInfo> mappingModelInfos = ModelDrivenJacksonUtil.fromJson(modelInfoStrFromServiceMapping, new TypeReference<List<MappingModelInfo>>(){});
            if (log.isDebugEnabled()) {
                List serviceModelCodes = serviceMappings.stream().map(DWServiceMapping::getCode).collect(Collectors.toList());
                log.debug("{} *** BM({}) *** get codes(total:{}) successfully(from bmd target prod):{}", new Object[]{CLASS_LOG_TAG, currentBMRole.getRole(), serviceModelCodes.size(), serviceModelCodes});
            }
            ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
            if (CollectionUtils.isNotEmpty(serviceMappings)) {
                try {
                    newTechEaiHeaders = eaiHeaderUtil.genServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
                }
                catch (Exception e) {
                    String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                    log.error("{} *** BM({}) *** get codes failed, cause:{}", new Object[]{CLASS_LOG_TAG, currentBMRole.getRole(), errorRootCauseMessage});
                }
            }
            Map<String, List<DWEAIHeader>> targetTechEai = targetTechEaiData.getTechHeaders();
            RegTypeUtil.mergeTechType(targetTechEai, newTechEaiHeaders);
            String espTech = RegisterServiceTechTypeEnum.ESP.getTechType();
            List newEspEaiHeaders = targetTechEai.getOrDefault(espTech, new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)newEspEaiHeaders)) {
                try {
                    eaiHeaderUtil.addAndUpdateCommonsHeaders(newEspEaiHeaders);
                    log.info("{} *** BM *** updated eai header, size:{}", new Object[]{CLASS_LOG_TAG, espTech, newEspEaiHeaders.size()});
                }
                catch (Exception e) {
                    String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                    log.error("{} *** BM *** {} updated eai header failed, cause:{}", new Object[]{CLASS_LOG_TAG, espTech, errorRootCauseMessage});
                }
            }
        }
        return newTechEaiHeaders;
    }

    @Bean(name={"modeldriven-bm-registry-nacos-service"})
    @ConditionalOnBean(type={"com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener"}, name={"modeldriven-customize-genEaiHeaders"})
    @ConditionalOnProperty(name={"lcdp.bm.role"}, havingValue="bm")
    public Object registryNacosService(@Qualifier(value="modeldriven-tech-eaiheader") TechEaiData targetTechEaiData, EaiHeaderUtil eaiHeaderUtil, NacosRegisterUtils nacosRegisterUtils) {
        Map targetTechEai = targetTechEaiData.getTechHeaders();
        String nacosTech = RegisterServiceTechTypeEnum.NACOS.getTechType();
        List nacosEaiHeaders = targetTechEai.getOrDefault(nacosTech, new ArrayList());
        try {
            if (CollectionUtils.isNotEmpty((Collection)nacosEaiHeaders)) {
                eaiHeaderUtil.addAndUpdateCommonsHeaders(nacosEaiHeaders);
            }
            List<DWHeader> modelDrivenGroupHeaders = eaiHeaderUtil.getCommonsEaiHeaders();
            modelDrivenGroupHeaders.stream().filter(commonsEaiHeader -> nacosEaiHeaders.stream().noneMatch(newNacosHeader -> ((DWEAIHeader)commonsEaiHeader).getEAIServiceId().equals(newNacosHeader.getEAIServiceId()))).forEach(commonsEaiHeader -> nacosEaiHeaders.add((DWEAIHeader)commonsEaiHeader));
            log.info("{} nacos service start register, size:{}", (Object)CLASS_LOG_TAG, (Object)nacosEaiHeaders.size());
            nacosRegisterUtils.registerService(nacosEaiHeaders);
            log.info("{} nacos service registered finished", (Object)CLASS_LOG_TAG);
        }
        catch (Exception e) {
            String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            log.error("{} nacos service register failed:{}", (Object)CLASS_LOG_TAG, (Object)errorRootCauseMessage);
        }
        return nacosEaiHeaders;
    }

    @Bean(name={"bmRedirectService"})
    public BMRedirectService bmRedirectService(@Qualifier(value="modeldriven-customize-bm-crud-handler") BMDInvoker bmdInvoker) {
        return new BMRedirectService();
    }

    @Bean(name={"dw-modeldriven-appinfo-advisor"})
    public Advisor dwModelDrivenAppinfoAdvisor(BMAppInfoInterceptor dwBMAppInfoInterceptor) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        String serviceWithAppInfo = "execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getMetadata(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getModelSql(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.getSqlReport(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.invoke(..)) || execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.dataViewGet(..))";
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(serviceWithAppInfo);
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dwBMAppInfoInterceptor);
        log.info("{} bean:eai dw-modeldriven-appinfo-advisor created!", (Object)CLASS_LOG_TAG);
        return advisor;
    }
}

