/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.eai;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.BMCodeUtil;
import com.digiwin.lcdp.modeldriven.utils.BindedApiUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BMDataEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(BMDataEaiHeaderBuilder.class);
    private static final String CLASS_LOG_TAG = "[" + BMDataEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    BMDataEaiMethodRepository bmdEaiMethodRepository;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> standardEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        String targetProdOfSite = BMCenterUtil.getProdOfSite();
        this.clearEaiHeaders();
        int serviceMapCount = 0;
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = eaiService.getProd();
            log.debug("{}[{}] serviceMapping: prod({}), eaiService({}), userExposePrefixEaiId({}) processing...", new Object[]{CLASS_LOG_TAG, serviceMapCount, eaiProd, eaiService.toSimpleString(), userExposePrefixEaiId});
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping)) {
                List<DWEAIHeader> newStdEaiHeaders = this.modelStandardEAIHeaderBuilder.generateStdEaiHeader(modelSchema, setMappingMethod, eaiService);
                standardEaiHeaders.addAll(newStdEaiHeaders);
                if (!CollectionUtils.isNotEmpty(newStdEaiHeaders) || this.bmCodes == null) continue;
                this.updateStdBMCodes(eaiService, newStdEaiHeaders);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) && targetProdOfSite.equalsIgnoreCase(targetProdOfDWServiceMapping) || BMProperties.getProperties().getRole() == BMRole.mix) {
                List<BindApi> bmdApiListConfig = modelSchema.getBmdApiListConfig();
                List<DWEAIHeader> newBMDEaiHeaders = this.generateBMDataEaiHeaders(setMappingMethod, eaiService, this.bmdEaiMethodRepository, bmdApiListConfig);
                log.debug("{}[{}] targetProd matched, actual({}), expected(site:{}), add eaiservice({})", new Object[]{CLASS_LOG_TAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite, newBMDEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList())});
                this.bmdEaiMethodRepository.addEaiHeaders(newBMDEaiHeaders);
                if (this.bmCodes == null) continue;
                this.updateBMCodes(eaiService, newBMDEaiHeaders, bmdApiListConfig);
                continue;
            }
            log.info("{}[{}] targetProd not match, actual({}), expected(site:{})", new Object[]{CLASS_LOG_TAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite});
        }
        int newNacosServiceMappingHeaderCount = this.bmdEaiMethodRepository.getEaiHeaders().size();
        boolean newMappingModelInfoHeaderCount = false;
        int newNacosMappingModelInfoHeaderCount = 0;
        if (CollectionUtils.isNotEmpty(mappingModelInfos)) {
            List<MappingModelInfo> stdMappingModelInfos;
            Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
            Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
            List<MappingModelInfo> bmdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmdMappingModelInfos)) {
                List<DWEAIHeader> newBMDChildrenListGetHeaders = this.getBMDataListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, bmdMappingModelInfos);
                this.bmdEaiMethodRepository.addEaiHeaders(newBMDChildrenListGetHeaders);
            }
            if (CollectionUtils.isNotEmpty(stdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())).collect(Collectors.toList()))) {
                List<DWEAIHeader> newStdListGetHeaders = this.modelStandardEAIHeaderBuilder.getStdListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfos, null);
                standardEaiHeaders.addAll(newStdListGetHeaders);
            }
        }
        this.modelStandardEAIHeaderBuilder.addIgnoreIntercepter(standardEaiHeaders);
        this.bmdEaiMethodRepository.addEaiHeaders(standardEaiHeaders);
        log.debug("{}[getEaiHeaders] *** BMD *** getNacosEaiHeaders({})=std({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{CLASS_LOG_TAG, this.bmdEaiMethodRepository.getEaiHeaders().size(), newNacosServiceMappingHeaderCount, newNacosMappingModelInfoHeaderCount, serviceMapCount});
        return standardEaiHeaders;
    }

    public <T> List<T> generateBMDataEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository bmdEaiMethodRepo, List<BindApi> bmdApiListConfig) throws InvocationTargetException, IllegalAccessException {
        List<Object> newEaiHeaders = new ArrayList();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
        Map<String, ModelDrivenEaiMethodDTO> bmdRepoEaiMethods = bmdEaiMethodRepo.getEaiMethodRepo();
        log.info("{} enter BMD master eai service", (Object)CLASS_LOG_TAG);
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String bmdEaiId = EaiServiceNameUtil.covertToServiceName(eaiTableName);
        String bmdPrefixExposeEaiId = String.join((CharSequence)".", targetProdOfCode, bmdEaiId);
        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
        log.debug("{} *** BMD *** serviceMapping: expose_eai_id prefix({}) from target prod ({}->{}), table_name({})", new Object[]{CLASS_LOG_TAG, bmdPrefixExposeEaiId, targetProdOfDWServiceMapping, targetProdOfCode, eaiTableName});
        boolean hasBindApiList = BindedApiUtil.hasBindApiConfig(bmdApiListConfig);
        if (hasBindApiList) {
            List mdServiceNames = bmdRepoEaiMethods.keySet().stream().collect(Collectors.toList());
            for (BindApi bindApi : bmdApiListConfig) {
                String apiName = bindApi.getApiName();
                String apiType = bindApi.getApiType();
                ModelDrivenEaiMethodDTO bmdEaiMethodDTO = this.getEaiMethod(apiType, bmdRepoEaiMethods);
                if (bmdEaiMethodDTO != null) {
                    Optional<Class<?>> eaiClazz = Optional.of(bmdEaiMethodDTO.getMethod().getDeclaringClass());
                    DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, bmdEaiMethodDTO.getMethod(), false);
                    newEaiHeaders.add(headerV);
                    continue;
                }
                log.warn("{} code({}) can't find lcdp base method, apiName({}) apiType({})", new Object[]{CLASS_LOG_TAG, eaiService.getCode(), apiName, apiType});
            }
        } else {
            newEaiHeaders = this.generateBMDataStdEaiHeaders(setMappingMethod, eaiService, bmdEaiMethodRepo);
        }
        log.debug("{}[getBMDataEaiHeaders] stdEaiHeaders({}) <== code({}), table_name({}), hasBindApiList({})", new Object[]{CLASS_LOG_TAG, CollectionUtils.isNotEmpty(newEaiHeaders) ? newEaiHeaders.size() : 0, eaiService.getCode(), eaiTableName, hasBindApiList});
        return newEaiHeaders;
    }

    protected List<DWEAIHeader> getBMDataBindApiEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository bmdEaiMethodRepo, List<BindApi> bmdApiListConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmdEaiMethodRepo.getEaiMethodRepo();
        log.info("{} enter BMD master eai service", (Object)CLASS_LOG_TAG);
        String eaiTableName = eaiService.getTableName();
        String bmdEaiId = EaiServiceNameUtil.covertToServiceName(eaiTableName);
        String bmdPrefixExposeEaiId = String.join((CharSequence)".", targetProdOfCode, bmdEaiId);
        log.debug("{} *** BMD *** serviceMapping: expose_eai_id prefix({}) from target prod ({}->{}), table_name({})", new Object[]{CLASS_LOG_TAG, bmdPrefixExposeEaiId, targetProdOfDWServiceMapping, targetProdOfCode, eaiTableName});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", bmdPrefixExposeEaiId, "std", mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
        }
        log.debug("{}[getBMDataEaiHeaders] serviceMapping: gen headerV expose_eai_id({})", (Object)CLASS_LOG_TAG, newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
        return newEaiHeaders;
    }

    protected <T> List<T> generateBMDataStdEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository bmdEaiMethodRepo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String bmdEaiIdPrefixPart = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmdEaiMethodRepo.getEaiMethodRepo();
        log.info("{} enter BMD master eai service({})", (Object)CLASS_LOG_TAG, (Object)eaiService.getExposeEaiId());
        String eaiTableName = eaiService.getTableName();
        String bmdEaiIdMiddlePart = EaiServiceNameUtil.covertToServiceName(eaiTableName);
        String bmdPrefixExposeEaiId = String.join((CharSequence)".", bmdEaiIdPrefixPart, bmdEaiIdMiddlePart);
        log.debug("{} *** BMD *** serviceMapping: expose_eai_id prefix({}) from target prod ({}->{}), table_name({})", new Object[]{CLASS_LOG_TAG, bmdPrefixExposeEaiId, targetProdOfDWServiceMapping, bmdEaiIdPrefixPart, eaiTableName});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
            String bmdEaiServiceId = String.join((CharSequence)".", bmdPrefixExposeEaiId, "std", mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", bmdEaiServiceId, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
        }
        log.debug("{}[getBMDataEaiHeaders] serviceMapping: gen headerV expose_eai_id({})", (Object)CLASS_LOG_TAG, newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMDataListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{}[getBMDataListGetHeaders] ------ enter children .list.get -------", (Object)CLASS_LOG_TAG);
            int modelinfoCount = 0;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ++modelinfoCount;
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String modelCode = mappingModelInfo.getCode();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String bmdEaiIdPrefixPart = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{CLASS_LOG_TAG, modelinfoCount, modelCode, bmdEaiIdPrefixPart, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String bmdEaiIdMiddlePart = EaiServiceNameUtil.covertToServiceName(childTableName);
                    String bmdChildEaiServiceId = String.join((CharSequence)".", bmdEaiIdPrefixPart, bmdEaiIdMiddlePart, "std", "get");
                    log.info("{} *** BMD *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", new Object[]{CLASS_LOG_TAG, modelCode, bmdChildEaiServiceId});
                    DWEAIHeader headerV = new DWEAIHeader("commons", bmdChildEaiServiceId, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)modelCode);
                    }
                    if (this.bmCodes == null) continue;
                    BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, BMRole.bmd);
                    bmCode.setApiType(ModelApiTypeEnum.LIST.getValue());
                    this.bmCodes.put(bmdEaiIdMiddlePart, bmCode);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("{}[getBMDataListGetHeaders]  --->> ignored to add eai service(childTableName({}) equals masterTableName({}))", new Object[]{CLASS_LOG_TAG, childTableName, eaiTableName});
            }
            log.info("{}[getBMDataListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{}[getBMDataListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
        }
        return childTableListGetHeaders;
    }

    @Override
    public List<DWEAIHeader> getSubListGetHeaders(Method setMappingMethod, List<MappingModelInfo> mappingModelInfos, ModelSchemaDTO modelSchema) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        Method listGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
        Optional<Class<?>> eaiClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{}[getSubListGetHeaders] enter children .list.get", (Object)CLASS_LOG_TAG);
            Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
            int modelinfoCount = 0;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ++modelinfoCount;
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String modelCode = mappingModelInfo.getCode();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{CLASS_LOG_TAG, modelinfoCount, modelCode, targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    ModelSchemaDTO subModelSchema = modelSchemaMap.get(childTableName);
                    if (subModelSchema != null) {
                        List<BindApi> subBmdApiListConfig = subModelSchema.getBmdApiListConfig();
                        boolean hasBindApiList = BindedApiUtil.hasBindApiConfig(subBmdApiListConfig);
                        if (hasBindApiList) {
                            for (BindApi bindApi : subBmdApiListConfig) {
                                String apiName = bindApi.getApiName();
                                String apiType = bindApi.getApiType();
                                DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                                setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                                childTableListGetHeaders.add(headerV);
                                log.debug("{} *** BMD *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{CLASS_LOG_TAG, hasBindApiList, headerV.getEAIServiceId(), apiName});
                                BMCode bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, true, childTableName);
                                bmCode.setApiType(apiType);
                                this.bmCodes.put(apiName, bmCode);
                            }
                            continue;
                        }
                        log.debug("{}[getSubListGetHeaders] code({}) ignored to generate .list.get, cause child({})", new Object[]{CLASS_LOG_TAG, modelCode, childTableName});
                        continue;
                    }
                    log.error("{}[getSubListGetHeaders] code({}) ignored to generate children .list.get, cause child({} in model_info) not exists in modelSchemaMap({})", new Object[]{CLASS_LOG_TAG, modelCode, childTableName, modelSchemaMap.keySet()});
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{}[getSubListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{}[getSubListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
        }
        return childTableListGetHeaders;
    }

    public List<DWEAIHeader> convertBMDataEAIHeader(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository eaiMethodRepo, List<BindApi> bindApiListConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = eaiMethodRepo.getEaiMethodRepo();
        for (BindApi bindApi : bindApiListConfig) {
            String apiName = bindApi.getApiName();
            String apiType = bindApi.getApiType();
            List mdServiceNames = mdEaiMethods.keySet().stream().collect(Collectors.toList());
            Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiType)).findFirst();
            if (optMatchServiceName.isPresent()) {
                String actualEaiId = optMatchServiceName.get();
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethods.get(actualEaiId);
                Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
                DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz.get());
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                continue;
            }
            log.info("{}[convertBMDataEAIHeader] can't find lcdp base method, bindApi({}) ", (Object)CLASS_LOG_TAG, (Object)bindApi);
        }
        return newEaiHeaders;
    }

    @Override
    public Map<String, List<DWEAIHeader>> getTechEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> nacosEaiHeaders = new ArrayList<DWEAIHeader>();
        ArrayList<DWEAIHeader> espEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        String targetProdOfSite = BMCenterUtil.getProdOfSite();
        int serviceMapCount = 0;
        boolean newServiceMappingHeaderCount = false;
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            if (log.isDebugEnabled()) {
                String userExposePrefixEaiId = eaiService.getExposeEaiId();
                String eaiProd = eaiService.getProd();
                log.debug("{}[{}] serviceMapping: prod({}), eaiService({}), userExposePrefixEaiId({}}) processing...", new Object[]{CLASS_LOG_TAG, serviceMapCount, eaiProd, eaiService.toSimpleString(), userExposePrefixEaiId});
            }
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping)) {
                List<MappingModelInfo> stdMappingModelInfos;
                List<DWEAIHeader> newStdEaiHeaders = this.modelStandardEAIHeaderBuilder.generateStdEaiHeader(modelSchema, setMappingMethod, eaiService);
                espEaiHeaders.addAll(newStdEaiHeaders);
                if (CollectionUtils.isNotEmpty(newStdEaiHeaders) && this.bmCodes != null) {
                    this.updateStdBMCodes(eaiService, newStdEaiHeaders);
                }
                if (!CollectionUtils.isNotEmpty(stdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getCode().equals(modelCode) && !mappingModelInfo.getChildtbl().equals(eaiTableName)).collect(Collectors.toList()))) continue;
                List<DWEAIHeader> stdListGetHeaders = this.modelStandardEAIHeaderBuilder.getSubListGetHeaders(setMappingMethod, stdMappingModelInfos, modelSchema);
                espEaiHeaders.addAll(stdListGetHeaders);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) && targetProdOfSite.equalsIgnoreCase(targetProdOfDWServiceMapping)) {
                List<BindApi> bmdApiListConfig = modelSchema.getBmdApiListConfig();
                List<DWEAIHeader> bmdEaiHeaders = this.generateBMDataEaiHeaders(setMappingMethod, eaiService, this.bmdEaiMethodRepository, bmdApiListConfig);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] targetProd matched, actual({}), expected(site:{}), add eaiservice({})", new Object[]{CLASS_LOG_TAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite, bmdEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList())});
                }
                this.updateBMCodes(eaiService, bmdEaiHeaders, bmdApiListConfig);
                List<MappingModelInfo> currentSubModels = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getCode().equals(modelCode) && !mappingModelInfo.getChildtbl().equals(eaiTableName)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(currentSubModels)) {
                    log.debug("{}[getTechEaiService] code({}) have children list api", (Object)CLASS_LOG_TAG, (Object)modelCode);
                    List<DWEAIHeader> newBMDChildrenListGetHeaders = this.getSubListGetHeaders(setMappingMethod, currentSubModels, modelSchema);
                    bmdEaiHeaders.addAll(newBMDChildrenListGetHeaders);
                } else {
                    log.debug("{}[getTechEaiService] code({}) have none children list api", (Object)CLASS_LOG_TAG, (Object)modelCode);
                }
                nacosEaiHeaders.addAll(bmdEaiHeaders);
                continue;
            }
            log.info("{}[{}] targetProd not match, actual({}), expected(site:{})", new Object[]{CLASS_LOG_TAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite});
        }
        List addEaiNames = espEaiHeaders.stream().filter(newEaiHeader -> BMConstants.BMD_OLD_MODEL_SERVIC_NAME.stream().noneMatch(existedName -> StringUtils.equals((CharSequence)existedName, (CharSequence)newEaiHeader.getEAIServiceId()))).map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        BMConstants.BMD_OLD_MODEL_SERVIC_NAME.addAll(addEaiNames);
        HashMap<String, List<DWEAIHeader>> prodEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        prodEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), espEaiHeaders);
        prodEaiHeaders.put(RegisterServiceTechTypeEnum.NACOS.getTechType(), nacosEaiHeaders);
        return prodEaiHeaders;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdEaiHeadersByService(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        HashMap<String, Map<String, List<DWEAIHeader>>> prodEaiHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        ArrayList nacosEaiHeaders = new ArrayList();
        ArrayList<DWEAIHeader> espEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        String targetProdOfSite = BMCenterUtil.getProdOfSite();
        this.clearEaiHeaders();
        int serviceMapCount = 0;
        int newServiceMappingHeaderCount = 0;
        BMRole bmRole = BMProperties.getProperties().getRole();
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            if (log.isDebugEnabled()) {
                String eaiServiceInfo = eaiService.toSimpleString();
                log.debug("{}[{}] *** BM({}) *** serviceMapping: prod({}), targetProd({}), eaiService({}), userExposePrefixEaiId({}}) processing...", new Object[]{CLASS_LOG_TAG, serviceMapCount, bmRole, eaiProd, targetProdOfDWServiceMapping, eaiServiceInfo, userExposePrefixEaiId});
            }
            Map prodRegTypeEaiHeaders = prodEaiHeadersMap.getOrDefault(targetProdOfDWServiceMapping, new HashMap());
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping)) {
                log.info("{}[getProdEaiHeadersByService][{}] mix-bmd serviceMapping: ignored, cause target_prod is blank for prod({}) eaiService({})", new Object[]{CLASS_LOG_TAG, serviceMapCount, eaiService.getProd(), eaiService.toSimpleString()});
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) && targetProdOfSite.equalsIgnoreCase(targetProdOfDWServiceMapping) || bmRole == BMRole.mix) {
                List bmdEaiHeaders = this.generateBMDataStdEaiHeaders(setMappingMethod, eaiService, this.bmdEaiMethodRepository);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] *** BM({}) targetProd matched, actual({}), expected(site:{}), add eaiservice({})", new Object[]{CLASS_LOG_TAG, serviceMapCount, bmRole.getRole(), targetProdOfDWServiceMapping, targetProdOfSite, bmdEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList())});
                }
                List prodNacosEaiHeaders = prodRegTypeEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.NACOS.getTechType(), new ArrayList());
                prodNacosEaiHeaders.addAll(bmdEaiHeaders);
                prodRegTypeEaiHeaders.put(RegisterServiceTechTypeEnum.NACOS.getTechType(), prodNacosEaiHeaders);
                prodEaiHeadersMap.put(targetProdOfDWServiceMapping, prodRegTypeEaiHeaders);
                continue;
            }
            log.info("{}[{}] targetProd not match, actual({}), expected(site:{})", new Object[]{CLASS_LOG_TAG, serviceMapCount, targetProdOfDWServiceMapping, targetProdOfSite});
        }
        int newNacosServiceMappingHeaderCount = nacosEaiHeaders.size();
        newServiceMappingHeaderCount = espEaiHeaders.size();
        int newMappingModelInfoHeaderCount = 0;
        int newNacosMappingModelInfoHeaderCount = 0;
        if (mappingModelInfos.size() > 0) {
            Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
            Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
            List<MappingModelInfo> bmdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmdMappingModelInfos)) {
                Map<String, Map<String, List<DWEAIHeader>>> bmdChildrenListGetHeadersMap = this.getBMDataListGetHeadersByProd(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, bmdMappingModelInfos);
                for (String prod : bmdChildrenListGetHeadersMap.keySet()) {
                    Map bmdProdChildrenListGet;
                    Map prodTechTypeEaiHeaderMap = (Map)prodEaiHeadersMap.get(prod);
                    List prodTechTypeNacosEaiHeaders = prodTechTypeEaiHeaderMap.getOrDefault(RegisterServiceTechTypeEnum.NACOS.getTechType(), new ArrayList());
                    if (prodEaiHeadersMap.containsKey(prod)) {
                        bmdProdChildrenListGet = bmdChildrenListGetHeadersMap.getOrDefault(prod, new HashMap());
                        if (!bmdProdChildrenListGet.containsKey(RegisterServiceTechTypeEnum.NACOS.getTechType())) continue;
                        prodTechTypeNacosEaiHeaders.addAll((Collection)bmdProdChildrenListGet.get(RegisterServiceTechTypeEnum.NACOS.getTechType()));
                        prodEaiHeadersMap.put(prod, prodTechTypeEaiHeaderMap);
                        continue;
                    }
                    bmdProdChildrenListGet = bmdChildrenListGetHeadersMap.getOrDefault(prod, new HashMap());
                    if (!MapUtils.isNotEmpty((Map)bmdProdChildrenListGet)) continue;
                    prodEaiHeadersMap.put(prod, bmdProdChildrenListGet);
                }
            }
        }
        this.modelStandardEAIHeaderBuilder.addIgnoreIntercepter(espEaiHeaders);
        log.debug("{}[getEaiHeaders] *** BM({}) *** getEspEaiHeaders({})=std({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{CLASS_LOG_TAG, bmRole.getRole(), espEaiHeaders.size(), newServiceMappingHeaderCount, newMappingModelInfoHeaderCount, serviceMapCount});
        log.debug("{}[getEaiHeaders] *** BMD *** getNacosEaiHeaders({})=std({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{CLASS_LOG_TAG, this.bmdEaiMethodRepository.getEaiHeaders().size(), newNacosServiceMappingHeaderCount, newNacosMappingModelInfoHeaderCount, serviceMapCount});
        return prodEaiHeadersMap;
    }

    public Map<String, Map<String, List<DWEAIHeader>>> getBMDataListGetHeadersByProd(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Map<String, List<DWEAIHeader>>> childTableListGetHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("{} EaiServiceUtil] enter children .list.get", (Object)CLASS_LOG_TAG);
            int modelinfoCount = 0;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ++modelinfoCount;
                ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{} [{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{CLASS_LOG_TAG, modelinfoCount, mappingModelInfo.getCode(), targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String bmdEaiId = EaiServiceNameUtil.covertToServiceName(childTableName);
                    String childEaiServiceIdForServiceMapping = String.join((CharSequence)".", targetProdOfCode, bmdEaiId, "std", "get");
                    log.info("{} *** BMD *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", new Object[]{CLASS_LOG_TAG, mappingModelInfo.getCode(), childEaiServiceIdForServiceMapping});
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    Map prodEaiHeaders = childTableListGetHeadersMap.getOrDefault(targetProdOfDWServiceMapping, new HashMap());
                    List prodNacosEaiHeaders = prodEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.NACOS.getTechType(), new ArrayList());
                    prodNacosEaiHeaders.addAll(childTableListGetHeaders);
                    prodEaiHeaders.put(RegisterServiceTechTypeEnum.NACOS.getTechType(), prodNacosEaiHeaders);
                    childTableListGetHeadersMap.put(targetProdOfDWServiceMapping, prodEaiHeaders);
                    if (log.isDebugEnabled()) {
                        log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                } else {
                    log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
                }
                log.info("{}[getBMDataListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)childTableListGetHeaders.size());
            }
        } else {
            log.warn("{}[getBMDataListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
        }
        return childTableListGetHeadersMap;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdTechEaiHeaders(Map<String, List<DWServiceMapping>> serviceMappingMap, Map<String, List<MappingModelInfo>> mappingModelInfosMap) throws Exception {
        return new HashMap<String, Map<String, List<DWEAIHeader>>>();
    }

    @Override
    public void clearEaiHeaders() {
        this.bmdEaiMethodRepository.getEaiHeaders().clear();
        log.debug("{} bmdEaiMethodRepository clearEaiHeaders", (Object)CLASS_LOG_TAG);
    }

    public void updateBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders, List<BindApi> bmdApiListConfig) {
        Map<String, BMCode> newBMCodes = BMCodeUtil.getBMDataLayerBMCodes(eaiService, eaiHeaders, bmdApiListConfig, BMRole.bmd);
        this.bmCodes.putAll(newBMCodes);
    }

    public void updateStdBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders) {
        Map<String, BMCode> newBMCodes = BMCodeUtil.getStandardBMCodes(eaiService, eaiHeaders);
        this.bmCodes.putAll(newBMCodes);
    }

    public ModelDrivenEaiMethodDTO getEaiMethod(String apiType, Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods) {
        ModelDrivenEaiMethodDTO bmdEaiMethodDTO = null;
        switch (apiType) {
            case "get": {
                bmdEaiMethodDTO = mdEaiMethods.get("lcdp.bmd.crud.eai.get");
                break;
            }
            case "create": {
                bmdEaiMethodDTO = mdEaiMethods.get("lcdp.bmd.crud.eai.create");
                break;
            }
            case "update": {
                bmdEaiMethodDTO = mdEaiMethods.get("lcdp.bmd.crud.eai.update");
                break;
            }
            case "delete": {
                bmdEaiMethodDTO = mdEaiMethods.get("lcdp.bmd.crud.eai.delete");
                break;
            }
            default: {
                log.warn("{} *** BMD *** can't match BMDataEaiMethodRepository's method using apiType({}) ", (Object)CLASS_LOG_TAG, (Object)apiType);
            }
        }
        return bmdEaiMethodDTO;
    }

    @Override
    public List<TechEaiData> getTechEaiData(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        return new ArrayList<TechEaiData>();
    }
}

