/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eai.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIErrorResult;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.lcdp.modeldriven.customize.handler.BMAdapterCustomizeHandler;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenMessageInfo;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenMessageLang;
import com.digiwin.lcdp.modeldriven.eai.ModelDrivenMessageUtils;
import com.digiwin.lcdp.modeldriven.eai.utils.ESPStdDataBuilder;
import com.digiwin.lcdp.modeldriven.pojo.ESPStdData;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiServiceInvoker {
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bm-adapter-handler")
    private BMAdapterCustomizeHandler bmAdapterHandler;
    private static final Logger log = LoggerFactory.getLogger(EaiServiceInvoker.class);
    private static final String CLASS_LOG_TAG = "[" + EaiServiceInvoker.class.getSimpleName() + "]";
    private static Map<String, ModelDrivenMessageInfo> messageInfoCache = new HashMap<String, ModelDrivenMessageInfo>();

    public Object invokeInnerService(DWEAIHeader header, Map<String, Object> headers, Map<String, Object> messageBody, boolean opException) throws Exception {
        try {
            String eaiServiceName = header.getEAIServiceId();
            DWContainerContext containerContext = DWContainerContext.getInstance();
            log.debug("{} invokeInnerService({}) start", (Object)CLASS_LOG_TAG, (Object)eaiServiceName);
            DWTargetAPI api = new DWTargetAPI((DWHeader)header, header.getMappingMethod());
            DWDefaultParameters apiParameters = new DWDefaultParameters();
            apiParameters.put("headers", headers);
            apiParameters.put("messageBody", messageBody);
            Map profile = DWServiceContext.getContext().getProfile();
            Object executeResult = containerContext.invoke(api, (DWParameters)apiParameters, profile);
            Gson gson = DWGsonProvider.getGson();
            if (executeResult instanceof DWEAIResult) {
                DWEAIResult eaiResult = (DWEAIResult)executeResult;
                log.debug("{} invokeThisDapService end, response parameter(DWEAIResult) is: {}", (Object)CLASS_LOG_TAG, (Object)gson.toJson((Object)eaiResult));
            } else if (executeResult instanceof String) {
                log.debug("{} invokeThisDapService end ,response parameter(String) is:{}", (Object)CLASS_LOG_TAG, executeResult);
                executeResult = this.bmAdapterHandler != null ? this.bmAdapterHandler.processBMDataResult((String)executeResult) : gson.fromJson((String)executeResult, DWEAIResult.class);
            }
            return executeResult;
        }
        catch (Throwable var10) {
            Throwable ex = var10;
            log.error("invokeInnerService error.", ex);
            if (opException) {
                String code = EaiServiceInvoker.buildBmpFullMessageCode("0601054");
                String content = EaiServiceInvoker.getMessage("0601054", EaiServiceInvoker.getRootCauseMessage(ex));
                throw new DWEaiException(code, content);
            }
            String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)var10);
            throw new RuntimeException(errorMessage);
        }
    }

    public Object invokeThisDapService(Map<String, Object> headers, Map<String, Object> messageBody, String moduleName, String serviceName, String methodName, boolean opException) throws Exception {
        try {
            DWDefaultParameters defaultParameters = new DWDefaultParameters();
            defaultParameters.put("headers", headers);
            defaultParameters.put("messageBody", messageBody);
            log.debug("{} invokeThisDapService start, request parameter is:{}", (Object)CLASS_LOG_TAG, (Object)new Gson().toJson((Object)defaultParameters));
            Object executeResult = DWContainerContext.getInstance().invoke(moduleName, serviceName, methodName, (DWParameters)defaultParameters, DWServiceContext.getContext().getProfile());
            Gson gson = DWGsonProvider.getGson();
            if (executeResult instanceof DWEAIResult) {
                DWEAIResult eaiResult = (DWEAIResult)executeResult;
                log.debug("{} invokeThisDapService end, response parameter(DWEAIResult) is: {}", (Object)CLASS_LOG_TAG, (Object)gson.toJson((Object)eaiResult));
            } else if (executeResult instanceof String) {
                log.debug("{} invokeThisDapService end ,response parameter(String) is:{}", (Object)CLASS_LOG_TAG, executeResult);
                executeResult = this.bmAdapterHandler != null ? this.bmAdapterHandler.processBMDataResult((String)executeResult) : gson.fromJson((String)executeResult, DWEAIResult.class);
            }
            return executeResult;
        }
        catch (Throwable var10) {
            Throwable ex = var10;
            log.error("{} invokeThisDapService error.", (Object)CLASS_LOG_TAG, (Object)ex);
            if (opException) {
                String code = EaiServiceInvoker.buildBmpFullMessageCode("0601054");
                String content = EaiServiceInvoker.getMessage("0601054", EaiServiceInvoker.getRootCauseMessage(ex));
                throw new DWEaiException(code, content);
            }
            DWEAIErrorResult errorResult = new DWEAIErrorResult("-1", "", ex.getMessage(), new HashMap());
            errorResult.setMessage(errorResult.getDescription());
            errorResult.setStacktrace(ExceptionUtils.getStackTrace((Throwable)ex));
            return errorResult;
        }
    }

    public DWEAIResult org_invokeThisDapService(Map<String, Object> headers, Map<String, Object> parameter, String moduleName, String serviceName, String methodName, boolean opException) throws Exception {
        try {
            DWDefaultParameters defaultParameters = new DWDefaultParameters();
            Map body = EaiServiceInvoker.buildReqStdData(parameter);
            defaultParameters.put("headers", headers);
            defaultParameters.put("messageBody", (Object)body);
            log.debug("start invokeThisDapService, request parameter is : " + new Gson().toJson((Object)defaultParameters));
            Object obj = DWContainerContext.getInstance().invoke(moduleName, serviceName, methodName, (DWParameters)defaultParameters, DWServiceContext.getContext().getProfile());
            DWEAIResult eaiResult = (DWEAIResult)obj;
            log.debug("end invokeThisDapService, response parameter is : " + new Gson().toJson((Object)eaiResult));
            return eaiResult;
        }
        catch (Throwable var10) {
            Throwable ex = var10;
            log.error("org_invokeThisDapService error.", ex);
            String code = EaiServiceInvoker.buildBmpFullMessageCode("0601054");
            String content = EaiServiceInvoker.getMessage("0601054", EaiServiceInvoker.getRootCauseMessage(ex));
            if (opException) {
                throw new DWEaiException(code, content);
            }
            DWEAIErrorResult errorResult = new DWEAIErrorResult(code, "", content, new HashMap());
            errorResult.setMessage(errorResult.getDescription());
            errorResult.setStacktrace(ExceptionUtils.getStackTrace((Throwable)ex));
            return errorResult;
        }
    }

    public static Map buildReqStdData(Map para) {
        HashMap<String, Map> paraMap = new HashMap<String, Map>();
        paraMap.put("parameter", para);
        HashMap<String, HashMap<String, Map>> stdPara = new HashMap<String, HashMap<String, Map>>();
        stdPara.put("std_data", paraMap);
        return stdPara;
    }

    public static String getRootCauseMessage(Throwable exception) {
        Throwable targetCause = null;
        Throwable rootCause = EaiServiceInvoker.getRootCause(exception);
        targetCause = rootCause != null ? rootCause : exception;
        String message = null;
        message = targetCause.getMessage();
        if (message == null || message.isEmpty()) {
            message = targetCause.toString();
        }
        return message;
    }

    public static Throwable getRootCause(Throwable exception) {
        return ExceptionUtils.getRootCause((Throwable)exception);
    }

    public static String buildBmpFullMessageCode(String messageCode) {
        String code = messageCode.substring(0, 3) + "." + messageCode.substring(3);
        return "B." + EaiServiceInvoker.appIdWithoutPrefix() + "." + code;
    }

    public static String appIdWithoutPrefix() {
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        int index = appId.indexOf(45);
        return index > 0 ? appId.substring(index + 1) : appId;
    }

    public static String getMessage(String messageCode) throws Exception {
        String locale = ((Object)((Object)DWServiceContext.getContext().getRequestHeader().getOrDefault("locale", ModelDrivenMessageLang.ZH_CN))).toString();
        return EaiServiceInvoker.getMessageByLang(ModelDrivenMessageLang.valueOf(locale.toUpperCase()), messageCode, new Object[0]);
    }

    public static String getMessage(String messageCode, Object ... params) throws Exception {
        String locale = ((Object)((Object)DWServiceContext.getContext().getRequestHeader().getOrDefault("locale", ModelDrivenMessageLang.ZH_CN))).toString();
        return EaiServiceInvoker.getMessageByLang(ModelDrivenMessageLang.valueOf(locale.toUpperCase()), messageCode, params);
    }

    public static String getMessageByLang(ModelDrivenMessageLang lang, String messageCode, Object ... params) throws Exception {
        Map<String, String> messageData = EaiServiceInvoker.getMessageByLang(lang, Arrays.asList(messageCode));
        if (messageData != null && messageData.size() > 0) {
            String message = messageData.get(messageCode);
            return String.format(message, params);
        }
        return null;
    }

    public static Map<String, String> getMessageByLang(ModelDrivenMessageLang lang, List<String> messageCodeList) throws Exception {
        List<ModelDrivenMessageInfo> infos = EaiServiceInvoker.getMessageInfo(messageCodeList);
        if (infos.size() <= 0) {
            return null;
        }
        HashMap<String, String> messageResult = new HashMap<String, String>();
        for (ModelDrivenMessageInfo item : infos) {
            messageResult.put(item.getMessageNo(), item.getMessage(lang));
        }
        return messageResult;
    }

    public static List<ModelDrivenMessageInfo> getMessageInfo(List<String> messageCodeList) throws Exception {
        ArrayList<ModelDrivenMessageInfo> result = new ArrayList<ModelDrivenMessageInfo>();
        ArrayList messageList = new ArrayList();
        for (String item : messageCodeList) {
            ModelDrivenMessageInfo messageInfo = messageInfoCache.get(item);
            if (messageInfo != null) {
                result.add(messageInfo);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("message_no", item);
            messageList.add(map);
        }
        if (messageList.size() > 0) {
            HashMap parameter = new HashMap();
            parameter.put("message_data", messageList);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("digi-host", "{}");
            ESPStdData stdData = EaiServiceInvoker.invokeSyncApi(headers, "bm.ommsc.message.get", parameter, true);
            List codeResult = (List)stdData.getParameter().get("message_data");
            for (Map item : codeResult) {
                ModelDrivenMessageInfo info = new ModelDrivenMessageInfo(item);
                messageInfoCache.put(info.getMessageNo(), info);
                result.add(info);
            }
        }
        return result;
    }

    public static ESPStdData invokeSyncApi(Map headers, String serviceName, Map parameter, boolean opException) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String headersStr = mapper.writeValueAsString((Object)headers);
        log.info("invokeESPHeader-origin:{}", (Object)headersStr);
        ResponseModel responseModel = EaiServiceInvoker.invokeSyncStableApi(headers, serviceName, parameter);
        ESPStdData stdData = EaiServiceInvoker.toStdData(responseModel.getBodyJsonString());
        if (opException && stdData != null && !"0".equals(stdData.getCode())) {
            throw new DWEaiException(stdData.getCode(), ModelDrivenMessageUtils.getMessage("0400001", serviceName, stdData.getDescription()));
        }
        return stdData;
    }

    public static ResponseModel invokeSyncStableApi(Map headers, String serviceName, Map para) throws Exception {
        String bodyStr = EaiServiceInvoker.buildReqStdJson(para);
        ResponseModel rtn = EaiServiceInvoker.invokeSyncStableApi(headers, serviceName, bodyStr);
        log.debug("ResponseModel is: " + new Gson().toJson((Object)rtn));
        return rtn;
    }

    public static ResponseModel invokeSyncStableApi(Map headers, String serviceName, String bodyJsonStr) throws Exception {
        RequestModel requestModel = new RequestModel();
        ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
        return responseModel;
    }

    public static String buildReqStdJson(Map para) {
        Map map = EaiServiceInvoker.buildReqStdData(para);
        return EaiServiceInvoker.formateToJson(map);
    }

    public static String formateToJson(Map obj) {
        Gson gson = new Gson();
        return gson.toJson((Object)obj);
    }

    public static ESPStdData toStdData(String jsonResult) {
        Map mapResult = EaiServiceInvoker.formateJson(jsonResult);
        if (mapResult == null) {
            return null;
        }
        Map stdData = (Map)mapResult.get("std_data");
        if (stdData == null) {
            return mapResult.containsKey("error") ? ESPStdDataBuilder.build(ModelDrivenMessageUtils.buildBmpFullMessageCode("0400001"), mapResult.get("error").toString()) : ESPStdDataBuilder.build(ModelDrivenMessageUtils.buildBmpFullMessageCode("0400001"), jsonResult);
        }
        Map execution = (Map)stdData.get("execution");
        if (!"0".equals(execution.get("code"))) {
            return ESPStdDataBuilder.build(execution.get("code").toString(), execution.get("description").toString(), execution.getOrDefault("stacktrace", "").toString());
        }
        ESPStdData data = ESPStdDataBuilder.build();
        data.setParameter((Map)stdData.get("parameter"));
        return data;
    }

    public static Map formateJson(String json) {
        Map obj = new HashMap();
        if (!"".equals(json)) {
            Gson gson = new Gson();
            HashMap map = new HashMap();
            obj = (Map)gson.fromJson(json, map.getClass());
        }
        return obj;
    }
}

