/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eoc;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.http.client.exception.DWExternalAPIHttpFailedException;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.ServiceModel;
import com.digiwin.lcdp.modeldriven.eoc.EocProperties;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EocHttpRequester {
    private static final Logger log = LoggerFactory.getLogger(EocHttpRequester.class);
    private static EocProperties properties;

    EocHttpRequester() {
    }

    public static void setProperties(EocProperties properties) {
        EocHttpRequester.properties = properties;
    }

    public static EocProperties getProperties() {
        if (properties == null) {
            throw new DWRuntimeException("EocHttpRequester properties is not ready, please contact lcdp modeldriven for this issue.");
        }
        return properties;
    }

    public static Object submit(ServiceModel serviceModel) throws Exception {
        Map<String, String> requestHeader = EocHttpRequester.createRequestHeader(serviceModel);
        String requestBody = null;
        if (serviceModel.getParams() != null) {
            requestBody = EocHttpRequester.createRequestBody(serviceModel.getParams());
        } else if (serviceModel.getBody() != null) {
            requestBody = EocHttpRequester.createRequestBody(serviceModel.getBody());
        }
        HttpRequestModel requestModel = EocHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setRequestMethod(serviceModel.getRequestMethod());
        String eocUrl = EocHttpRequester.getProperties().getUrl();
        if (StringUtils.isEmpty((CharSequence)eocUrl)) {
            throw new DWException("value of 'eocUrl' can not be null, it should be configed in properties");
        }
        requestModel.setUrl(eocUrl + serviceModel.getInvokeURL());
        HttpResponseModel responseModel = HttpRequester.submitRequest((HttpRequestModel)requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            throw EocHttpRequester.handleHttpStatus(requestModel, responseModel);
        }
        return responseModel;
    }

    public static HttpRequestModel getHttpRequestModel() {
        EocProperties properties = EocHttpRequester.getProperties();
        HttpRequestModel requestModel = new HttpRequestModel();
        requestModel.setContentType(properties.getContentType());
        requestModel.setCharSet(properties.getCharset());
        requestModel.setConnectionPoolRequestTimeout(properties.getConnectionRequestTimeout());
        requestModel.setConnectionTimeout(properties.getConnectionTimeout());
        requestModel.setSoTimeout(properties.getRequestSocketTimeout());
        requestModel.setEncode(properties.getEncode());
        requestModel.setMaxTotalConnections(properties.getConnectionMaxTotal());
        requestModel.setKeepAliveTimeout(properties.getKeepAliveTimeout());
        return requestModel;
    }

    public static String createRequestBody(Object params) throws Exception {
        return DWGsonProvider.getGson().toJson(params);
    }

    public static Map<String, String> createRequestHeader(ServiceModel serviceModel) throws Exception {
        Map header = IAMHttpRequester.createRequestHeader((ServiceModel)serviceModel);
        return header;
    }

    public static DWException handleHttpStatus(HttpRequestModel requestModel, HttpResponseModel responseModel) {
        String iamErrorMessage = DWApplicationMessageResourceBundleUtils.getString((String)"10900", (Object[])new Object[]{requestModel.getUrl(), requestModel.getRequestHeader().toString(), requestModel.getRequestBody(), responseModel.getHttpStatusCode(), responseModel.getResponseBody()});
        boolean login = false;
        String errorCode = "10903";
        if (responseModel.getHttpStatusCode() == 406 || responseModel.getHttpStatusCode() == 401) {
            errorCode = "10904";
            login = true;
        }
        DWExternalAPIHttpFailedException exception = new DWExternalAPIHttpFailedException(errorCode, iamErrorMessage, requestModel.getUrl(), responseModel.getHttpStatusCode(), responseModel.getResponseBody());
        if (login) {
            exception.getInstructors().put("login", true);
        }
        return exception;
    }
}

