/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledCondition;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.service.ServiceMappingUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ModelDrivenEnabledCondition.class})
public class EaiHeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiHeaderUtil.class);
    private static final String CLASS_LOG_TAG = "[" + EaiHeaderUtil.class.getSimpleName() + "]";
    private EaiHeaderBuilder customizeEAIHeaderBuilder;
    private EaiHeaderBuilder bmMixEAIHeaderBuilder;
    private final DWEAIHeaderRepository dwEAIHeaderRepository;
    private final DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser;
    private final Map<String, BMCode> bmCodes;
    private final ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;

    @Autowired
    public EaiHeaderUtil(DWEAIHeaderRepository dwEAIHeaderRepository, DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser, @Qualifier(value="bmCodes") Optional<Map<String, BMCode>> optionalBmCodes, @Qualifier(value="dw-modeldriven-crud-eai-builder") Optional<ModelStandardEaiHeaderBuilder> optionalModelStandardEAIHeaderBuilder, @Qualifier(value="modeldriven-customize-crud-eai-builder") Optional<EaiHeaderBuilder> optionalCustomizeEAIHeaderBuilder, @Qualifier(value="modeldriven-customize-bmmix-builder") Optional<EaiHeaderBuilder> optionalBMMixEAIHeaderBuilder) {
        this.dwEAIHeaderRepository = dwEAIHeaderRepository;
        this.dwEaiServiceDefinitionParser = dwEaiServiceDefinitionParser;
        this.bmCodes = optionalBmCodes.orElse(null);
        this.modelStandardEAIHeaderBuilder = optionalModelStandardEAIHeaderBuilder.orElse(null);
        this.customizeEAIHeaderBuilder = optionalCustomizeEAIHeaderBuilder.orElse(null);
        this.bmMixEAIHeaderBuilder = optionalBMMixEAIHeaderBuilder.orElse(null);
    }

    public Map<String, List<DWEAIHeader>> genServiceDiscoveryModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        BMProperties bmProperties = BMProperties.getProperties();
        Map<String, List<DWEAIHeader>> techEaiHeaders = bmProperties == null || !bmProperties.isEnabled() ? this.genServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.modelStandardEAIHeaderBuilder) : this.genServiceDiscoveryModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.customizeEAIHeaderBuilder);
        return techEaiHeaders;
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties == null || !bmProperties.isEnabled()) {
            return this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.modelStandardEAIHeaderBuilder);
        }
        EaiHeaderBuilder targetBuilder = bmProperties.getRole() == BMRole.mix ? this.bmMixEAIHeaderBuilder : this.customizeEAIHeaderBuilder;
        return this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, targetBuilder);
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        return eaiHeaderBuilder.getEaiHeaders(serviceMappings, mappingModelInfos);
    }

    public Map<String, List<DWEAIHeader>> genServiceDiscoveryModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        log.info("{} genEaiHeaders using {}", (Object)CLASS_LOG_TAG, (Object)eaiHeaderBuilder);
        return eaiHeaderBuilder.getTechEaiHeaders(serviceMappings, mappingModelInfos);
    }

    public List<DWEAIHeader> updateAndGetModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        List<DWEAIHeader> newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
        if (CollectionUtils.isNotEmpty(newEaiHeaders)) {
            this.addAndUpdateCommonsHeaders(newEaiHeaders);
        }
        return newEaiHeaders;
    }

    public void addAndUpdateCommonsHeaders(List<DWEAIHeader> candidateEaiHeaders) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (CollectionUtils.isNotEmpty(candidateEaiHeaders)) {
            List orgModelDrivenDWEAIHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            int candidateEaiHeaderCount = candidateEaiHeaders.size();
            int orgInitHeaderCount = orgModelDrivenDWEAIHeaders.size();
            List existedOrgDWHeaders = orgModelDrivenDWEAIHeaders.stream().filter(orgDWHeader -> candidateEaiHeaders.stream().anyMatch(candiHeader -> StringUtils.equals((CharSequence)((DWEAIHeader)orgDWHeader).getEAIServiceId(), (CharSequence)candiHeader.getEAIServiceId()))).collect(Collectors.toList());
            List existedEaiHeaderNames = existedOrgDWHeaders.stream().map(oldEaiHeader -> ((DWEAIHeader)oldEaiHeader).getEAIServiceId()).collect(Collectors.toList());
            int duplicatedCount = existedEaiHeaderNames.size();
            log.info("{}[init] orgHeaderCount({}), candidateHeaderCount({}), duplicatedCount({})", new Object[]{CLASS_LOG_TAG, CollectionUtils.isNotEmpty((Collection)orgModelDrivenDWEAIHeaders) ? orgModelDrivenDWEAIHeaders.size() : 0, candidateEaiHeaderCount, duplicatedCount});
            List newEaiHeaders = candidateEaiHeaders.stream().filter(candiHeader -> !existedEaiHeaderNames.contains(candiHeader.getEAIServiceId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newEaiHeaders)) {
                orgModelDrivenDWEAIHeaders.addAll(newEaiHeaders);
                Method registerHeaderMethod = ModelDrivenMethodHelper.getRegisterHeaderAccessibleOfDWEAIServiceDefinitionParser();
                registerHeaderMethod.invoke((Object)this.dwEaiServiceDefinitionParser, "commons", orgModelDrivenDWEAIHeaders);
                log.debug("{}[addAndUpdateDWEaiHeaders] added to eai repo({}): {}", new Object[]{CLASS_LOG_TAG, newEaiHeaders.size(), newEaiHeaders.stream().map(newEaiHeader -> newEaiHeader.getEAIServiceId()).collect(Collectors.toList())});
                log.info("{}[addAndUpdateDWEaiHeaders] refreshed eai repo, total({}) = org({}) + (candidateEaiHeader({}) - duplicated({}))", new Object[]{CLASS_LOG_TAG, orgModelDrivenDWEAIHeaders.size(), orgInitHeaderCount, candidateEaiHeaderCount, duplicatedCount});
            } else {
                log.debug("{}[addAndUpdateDWEaiHeaders] ignored to add to eai repo(filtered new:{}, cadidate:{})", new Object[]{CLASS_LOG_TAG, newEaiHeaders.size(), candidateEaiHeaderCount});
            }
            log.info("{}[addAndUpdateDWEaiHeaders] orgHeaderCount({})= initOrgHeaderCount({}) + newEaiHeaders({})", new Object[]{CLASS_LOG_TAG, orgModelDrivenDWEAIHeaders.size(), orgInitHeaderCount, newEaiHeaders.size()});
        } else {
            log.info("{}[addAndUpdateDWEaiHeaders] ignored to refresh eai repo, cause empty newEaiHeaders.", (Object)CLASS_LOG_TAG);
        }
    }

    public List<DWHeader> getDropEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<Object> dropEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(actualHeaders)) {
            dropEaiHeaders = actualHeaders.stream().filter(actual -> draftEaiHeaders.stream().noneMatch(draft -> ((DWEAIHeader)actual).getEAIServiceId().equals(draft.getEAIServiceId()))).collect(Collectors.toList());
            log.info("{}[addAndUpdateDWEaiHeaders] drop size({}) ({})", new Object[]{CLASS_LOG_TAG, dropEaiHeaders.size(), dropEaiHeaders});
        } else {
            log.info("{} ignored drop any DWEAIHeader", (Object)CLASS_LOG_TAG);
        }
        return dropEaiHeaders;
    }

    public void executeDropExistedEaiHeaders(List<DWHeader> dropEaiHeaders) {
        List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
        int repoBefore = orgDWHeaders.size();
        dropEaiHeaders.stream().forEach(orgDWHeaders::remove);
        List dropList = dropEaiHeaders.stream().map(dropEaiHeader -> ((DWEAIHeader)dropEaiHeader).getEAIServiceId()).collect(Collectors.toList());
        log.info("{} drop DWEAIHeaderRepository--> dropped({},{})(dwEAIHeaderRepo: before({}), after({}))", new Object[]{CLASS_LOG_TAG, dropList.size(), dropList, repoBefore, orgDWHeaders.size()});
    }

    public List<DWEAIHeader> getAddEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<DWEAIHeader> addEaiHeaders = draftEaiHeaders.stream().filter(draft -> actualHeaders.stream().noneMatch(actual -> Objects.equals(draft.getEAIServiceId(), ((DWEAIHeader)actual).getEAIServiceId()))).collect(Collectors.toList());
        log.info("{} drop size({}) ({})", new Object[]{CLASS_LOG_TAG, addEaiHeaders.size(), addEaiHeaders});
        return addEaiHeaders;
    }

    public List<DWEAIHeader> genServiceModelInfoData(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) throws Exception {
        String masterTableName = masterModelSchema.getName();
        String userExposePrefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, masterTableName);
        String modelSchemaStr = ModelDataUtil.getModelSchemaStr(masterModelSchema);
        List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(masterModelSchema.getChildren());
        DWServiceMapping serviceMapping = new DWServiceMapping();
        serviceMapping.setTableName(masterTableName);
        serviceMapping.setExposeEaiId(userExposePrefixEaiId);
        serviceMapping.setModelSchema(modelSchemaStr);
        serviceMapping.setCode(code);
        ArrayList<DWServiceMapping> serviceMappings = new ArrayList<DWServiceMapping>();
        serviceMappings.add(serviceMapping);
        List<MappingModelInfo> mappingModelInfos = ModelDataUtil.getChildrenMappingModelInfo(allChildrenSchemas, masterTableName, userExposePrefixEaiId, code);
        ServiceMappingUtil.updateProd(serviceMappings, mappingModelInfos);
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled()) {
            BMCenterUtil.modifyServiceMapping(serviceMappings);
            BMCenterUtil.modifyMappingModelInfo(mappingModelInfos);
        }
        return this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
    }

    public List<DWHeader> getExistedEaiHeaders(List<DWEAIHeader> dweaiHeaders) {
        List<Object> existedEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(dweaiHeaders)) {
            List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            existedEaiHeaders = orgDWHeaders.stream().filter(orgDWHeader -> orgDWHeader instanceof DWEAIHeader && dweaiHeaders.stream().anyMatch(dweaiHeader -> ((DWEAIHeader)orgDWHeader).getEAIServiceId().equals(dweaiHeader.getEAIServiceId()))).collect(Collectors.toList());
            log.info("{} get existedEaiHeaders({} from DWEAIHeaderRepository({}({})))", new Object[]{CLASS_LOG_TAG, existedEaiHeaders.size(), "commons", orgDWHeaders.size()});
        } else {
            log.info("{} ignored get existedEaiHeaders  from DWEAIHeaderRepository", (Object)CLASS_LOG_TAG);
        }
        return existedEaiHeaders;
    }

    public String getTableName(String serviceName) {
        BMCode bmCode = this.bmCodes.getOrDefault(serviceName, null);
        return bmCode != null ? bmCode.getTableName() : "";
    }

    public List<DWEAIHeader> refreshEaiService(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) throws Exception {
        List<DWEAIHeader> newEaiHeaders = this.genServiceModelInfoData(masterModelSchema, modelDrivenProdPrefix, code);
        this.addAndUpdateCommonsHeaders(newEaiHeaders);
        return newEaiHeaders;
    }

    public List<DWHeader> getCommonsEaiHeaders() {
        return this.dwEAIHeaderRepository.getHeaders("commons");
    }

    public List<DWEAIHeader> getNacosHeadersCombindCommons(Map<String, List<DWEAIHeader>> prodEaiHeaders) {
        String nacosTech = RegisterServiceTechTypeEnum.NACOS.getTechType();
        List nacosEaiHeaders = prodEaiHeaders.computeIfAbsent(nacosTech, key -> new ArrayList());
        List<DWHeader> modelDrivenGroupHeaders = this.getCommonsEaiHeaders();
        modelDrivenGroupHeaders.stream().filter(commonsEaiHeader -> nacosEaiHeaders.stream().noneMatch(newNacosHeader -> ((DWEAIHeader)commonsEaiHeader).getEAIServiceId().equals(newNacosHeader.getEAIServiceId()))).forEach(commonsEaiHeader -> nacosEaiHeaders.add((DWEAIHeader)commonsEaiHeader));
        return nacosEaiHeaders;
    }
}

