/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.service;

import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ServiceMappingUtil {
    public static Map<String, Object> genServiceModelInfoMap(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) {
        String masterTableName = masterModelSchema.getName();
        String userExposePrefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, masterTableName);
        String modelSchemaStr = ModelDataUtil.getModelSchemaStr(masterModelSchema);
        List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(masterModelSchema.getChildren());
        DWServiceMapping serviceMapping = new DWServiceMapping();
        serviceMapping.setTableName(masterTableName);
        serviceMapping.setExposeEaiId(userExposePrefixEaiId);
        serviceMapping.setModelSchema(modelSchemaStr);
        serviceMapping.setCode(code);
        ArrayList<DWServiceMapping> serviceMappings = new ArrayList<DWServiceMapping>();
        serviceMappings.add(serviceMapping);
        List<MappingModelInfo> mappingModelInfos = ModelDataUtil.getChildrenMappingModelInfo(allChildrenSchemas, masterTableName, userExposePrefixEaiId, code);
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled()) {
            BMCenterUtil.modifyServiceMapping(serviceMappings);
            BMCenterUtil.modifyMappingModelInfo(mappingModelInfos);
        }
        HashMap<String, Object> serviceModelInfoMap = new HashMap<String, Object>();
        serviceModelInfoMap.put("serviceMappings", serviceMappings);
        serviceModelInfoMap.put("mappingModelInfos", mappingModelInfos);
        return serviceModelInfoMap;
    }

    public static void updateProd(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) {
        serviceMappings.stream().forEach(serviceMapping -> {
            String appInfoProd = BMEaiServiceNameUtil.getAppProd(serviceMapping.getExposeEaiId(), serviceMapping.getTableName());
            if (StringUtils.isNotBlank((CharSequence)appInfoProd)) {
                serviceMapping.setProd(appInfoProd);
            }
        });
    }
}

