/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.eai;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.ApiTypeUtil;
import com.digiwin.lcdp.modeldriven.utils.BMCodeUtil;
import com.digiwin.lcdp.modeldriven.utils.BindedApiUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.service.RegTypeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BMEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(BMEaiHeaderBuilder.class);
    private static final String CLASS_LOG_TAG = "[" + BMEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-crud-eai-builder")
    ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired
    @Qualifier(value="lcdp-bm-eai-method-repo")
    BMEaiMethodRepository bmEaiMethodRepository;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        int serviceMapCount = 0;
        int newServiceMappingHeaderCount = 0;
        int newMappingModelInfoHeaderCount = 0;
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            log.debug("{}[{}] serviceMapping: prod({}), eaiService({}),userExposePrefixEaiId({}}) processing ... ", new Object[]{CLASS_LOG_TAG, serviceMapCount, eaiProd, eaiService.toSimpleString(), userExposePrefixEaiId});
            List<DWEAIHeader> bmEaiHeaders = this.generateBMEaiHeaders(setMappingMethod, eaiService, this.bmEaiMethodRepository, bindApiListConfig);
            List<MappingModelInfo> currentSubModels = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getCode().equals(modelCode) && !mappingModelInfo.getChildtbl().equals(mappingModelInfo.getTablename())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(currentSubModels)) {
                log.debug("{}[getEaiHeaders] code({}) have children", (Object)CLASS_LOG_TAG, (Object)modelCode);
                ArrayList<DWEAIHeader> bmSubListGetHeaders = new ArrayList<DWEAIHeader>();
                List<DWEAIHeader> currentSubListGetHeaders = this.getSubListGetHeaders(setMappingMethod, currentSubModels, modelSchema);
                bmSubListGetHeaders.addAll(currentSubListGetHeaders);
                newMappingModelInfoHeaderCount += bmSubListGetHeaders.size();
                bmEaiHeaders.addAll(bmSubListGetHeaders);
            } else {
                log.debug("{}[getTechEaiService] code({}) have none children list api", (Object)CLASS_LOG_TAG, (Object)modelCode);
            }
            newEaiHeaders.addAll(bmEaiHeaders);
        }
        log.debug("{}[getEaiHeaders] *** BM *** getEaiHeaders({})=bm({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{CLASS_LOG_TAG, CollectionUtils.isNotEmpty(newEaiHeaders) ? newEaiHeaders.size() : 0, newServiceMappingHeaderCount, newMappingModelInfoHeaderCount, serviceMapCount});
        return newEaiHeaders;
    }

    public List<DWEAIHeader> generateBMEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMEaiMethodRepository bmEaiMethodRepo, List<BindApi> bindApiListConfig) throws InvocationTargetException, IllegalAccessException {
        boolean hasBindApiList;
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        log.info("{} enter md master eai service", (Object)CLASS_LOG_TAG);
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> optionalEaiClazz = bmEaiMethodRepo.getEaiClazz();
        if (!optionalEaiClazz.isPresent()) {
            log.warn("{}[generateBMEaiHeaders] *** BM *** optionalEaiClazz is null when code({}) ", (Object)CLASS_LOG_TAG, (Object)eaiService.getCode());
            return newEaiHeaders;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        if (log.isDebugEnabled()) {
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            String serviceSimpleInfo = eaiService.toSimpleString();
            log.debug("{} serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({})", new Object[]{CLASS_LOG_TAG, eaiProd, serviceSimpleInfo, eaiTableName, userExposePrefixEaiId});
        }
        if (hasBindApiList = BindedApiUtil.hasBindApiConfig(bindApiListConfig)) {
            for (BindApi bindApi : bindApiListConfig) {
                String apiName = bindApi.getApiName();
                String apiType = bindApi.getApiType();
                List mdServiceNames = mdEaiMethods.keySet().stream().collect(Collectors.toList());
                Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiType)).findFirst();
                if (optMatchServiceName.isPresent()) {
                    String actualEaiId = optMatchServiceName.get();
                    ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethods.get(actualEaiId);
                    DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz);
                    setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                    newEaiHeaders.add(headerV);
                    BMCode bmCode = new BMCode(eaiService.getCode(), eaiService.getTargetProd(), eaiTableName, BMRole.bm);
                    bmCode.setApiType(apiType);
                    this.bmCodes.put(apiName, bmCode);
                    log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{CLASS_LOG_TAG, hasBindApiList, headerV.getEAIServiceId(), eaiService.getExposeEaiId()});
                    continue;
                }
                log.info("{} can't find lcdp base method, bindApi({}) ", (Object)CLASS_LOG_TAG, (Object)bindApi);
            }
        } else {
            for (Map.Entry entry : mdEaiMethods.entrySet()) {
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = (ModelDrivenEaiMethodDTO)entry.getValue();
                String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, "std", mdEaiMethodDTO.getEaiServicePostfix());
                DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz);
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                this.bmCodes.put(eaiServiceIdForServiceMapping, new BMCode(eaiService.getCode(), eaiService.getTargetProd(), eaiTableName));
                log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})", new Object[]{CLASS_LOG_TAG, hasBindApiList, headerV.getEAIServiceId()});
            }
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMEaiMethodRepository bmEaiMethodRepo, List<BindApi> bindApiListConfig, List<BindApi> bmdApiConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> bmEaiMethods = bmEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> optionalBmEaiClazz = bmEaiMethodRepo.getEaiClazz();
        if (!optionalBmEaiClazz.isPresent()) {
            log.warn("{}[getBMEaiHeaders] *** BM *** optionalEaiClazz is null when code({}) ", (Object)CLASS_LOG_TAG, (Object)eaiService.getCode());
            return newEaiHeaders;
        }
        Class<?> eaiClazz = optionalBmEaiClazz.get();
        log.info("{}[getBMEaiHeaders] enter md master eai service code:{}", (Object)CLASS_LOG_TAG, (Object)eaiService.getCode());
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
        String eaiServiceInfo = eaiService.toSimpleString();
        log.debug("{} serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({})", new Object[]{CLASS_LOG_TAG, eaiProd, eaiServiceInfo, eaiTableName, userExposePrefixEaiId});
        boolean hasBindApiList = BindedApiUtil.hasBindApiConfig(bindApiListConfig);
        if (hasBindApiList) {
            for (BindApi bindApi : bindApiListConfig) {
                String apiName = bindApi.getApiName();
                String apiType = bindApi.getApiType();
                List mdServiceNames = bmEaiMethods.keySet().stream().collect(Collectors.toList());
                Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiType)).findFirst();
                if (optMatchServiceName.isPresent()) {
                    BindApi targetBmdApiConfig;
                    Optional<BindApi> optionalGetApi;
                    String actualEaiId = optMatchServiceName.get();
                    ModelDrivenEaiMethodDTO mdEaiMethodDTO = bmEaiMethods.get(actualEaiId);
                    DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz);
                    setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                    newEaiHeaders.add(headerV);
                    BMCode bmCode = new BMCode(eaiService.getCode(), eaiService.getTargetProd(), eaiTableName, BMRole.bm);
                    bmCode.setApiType(apiType);
                    if (StringUtils.equalsAny((CharSequence)apiType, (CharSequence[])new CharSequence[]{"list", "detail"})) {
                        optionalGetApi = bmdApiConfig.stream().filter(eachBmdApiConfig -> eachBmdApiConfig.getApiType().equals("get")).findFirst();
                        if (optionalGetApi.isPresent()) {
                            targetBmdApiConfig = optionalGetApi.get();
                            bmCode.setBmdApi(targetBmdApiConfig.getApiName());
                        } else {
                            log.warn("{}[getBMEaiHeaders] bmApi({}) type({}) can't find bmdApi", new Object[]{CLASS_LOG_TAG, apiName, apiType});
                        }
                    } else {
                        optionalGetApi = bmdApiConfig.stream().filter(eachBmdApiConfig -> eachBmdApiConfig.getApiType().equals(apiType)).findFirst();
                        if (optionalGetApi.isPresent()) {
                            targetBmdApiConfig = optionalGetApi.get();
                            bmCode.setBmdApi(targetBmdApiConfig.getApiName());
                        } else {
                            log.warn("{}[getBMEaiHeaders] bmApi({}) type({}) can't find bmdApi", new Object[]{CLASS_LOG_TAG, apiName, apiType});
                        }
                    }
                    this.bmCodes.put(apiName, bmCode);
                    log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{CLASS_LOG_TAG, hasBindApiList, headerV.getEAIServiceId(), eaiService.getExposeEaiId()});
                    continue;
                }
                log.info("{} can't find lcdp base method, bindApi({}) ", (Object)CLASS_LOG_TAG, (Object)bindApi);
            }
        } else {
            for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : bmEaiMethods.entrySet()) {
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
                String eaiServicePostfix = mdEaiMethodDTO.getEaiServicePostfix();
                String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, "std", eaiServicePostfix);
                DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz);
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                BMCode bmCode = new BMCode(eaiService.getCode(), eaiService.getTargetProd(), eaiTableName);
                String apiType = ApiTypeUtil.getStdApiType(headerV, eaiServicePostfix);
                bmCode.setApiType(apiType);
                this.bmCodes.put(eaiServiceIdForServiceMapping, bmCode);
                log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})", new Object[]{CLASS_LOG_TAG, hasBindApiList, headerV.getEAIServiceId()});
            }
        }
        return newEaiHeaders;
    }

    @Override
    public List<DWEAIHeader> getSubListGetHeaders(Method setMappingMethod, List<MappingModelInfo> mappingModelInfos, ModelSchemaDTO modelSchema) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (CollectionUtils.isNotEmpty(mappingModelInfos)) {
            log.info("{}[getSubListGetHeaders] enter children .list.get", (Object)CLASS_LOG_TAG);
            Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
            int modelinfoCount = 0;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ++modelinfoCount;
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String modelCode = mappingModelInfo.getCode();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{CLASS_LOG_TAG, modelinfoCount, modelCode, targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    Method subListGetMethod;
                    Optional<Class<?>> optionalSubEaiCrudClazz;
                    if (StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())) {
                        optionalSubEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
                        subListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
                    } else {
                        optionalSubEaiCrudClazz = this.bmEaiMethodRepository.getEaiClazz();
                        subListGetMethod = this.bmEaiMethodRepository.getListGetMethod();
                    }
                    if (!optionalSubEaiCrudClazz.isPresent()) {
                        log.warn("{}[getSubListGetHeaders] *** BM *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
                        return childTableListGetHeaders;
                    }
                    Class<?> eaiClazz = optionalSubEaiCrudClazz.get();
                    ModelSchemaDTO subModelSchema = modelSchemaMap.get(childTableName);
                    if (subModelSchema != null) {
                        BMCode bmCode;
                        DWEAIHeader headerV;
                        List<BindApi> subApiListConfig = subModelSchema.getBindApiListConfig();
                        boolean hasBindApiList = BindedApiUtil.hasBindApiConfig(subApiListConfig);
                        if (hasBindApiList) {
                            for (BindApi bindApi : subApiListConfig) {
                                String apiName = bindApi.getApiName();
                                headerV = new DWEAIHeader("commons", apiName, eaiClazz);
                                setMappingMethod.invoke((Object)headerV, subListGetMethod, false);
                                childTableListGetHeaders.add(headerV);
                                log.debug("{} *** BM *** serviceMapping: hasBindApiList({}) add headerV expose_eai_id({})(ignored org serviceMapping eaiid prefix({})", new Object[]{CLASS_LOG_TAG, hasBindApiList, headerV.getEAIServiceId(), apiName});
                                bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, true, childTableName);
                                bmCode.setApiType(bindApi.getApiType());
                                bmCode.setRole(BMRole.bm);
                                this.bmCodes.put(apiName, bmCode);
                            }
                            continue;
                        }
                        String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                        String childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getBMChildListGetEaiServiceId(eaiProd, childTableName);
                        log.info("{} *** BM *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", new Object[]{CLASS_LOG_TAG, modelCode, childEaiServiceIdForServiceMapping});
                        headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz);
                        setMappingMethod.invoke((Object)headerV, subListGetMethod, false);
                        childTableListGetHeaders.add(headerV);
                        if (log.isDebugEnabled()) {
                            log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)modelCode);
                        }
                        bmCode = new BMCode(modelCode, targetProdOfDWServiceMapping, eaiTableName, true, childTableName);
                        bmCode.setApiType(ModelApiTypeEnum.LIST.getApiTypeName());
                        this.bmCodes.put(childEaiServiceIdForServiceMapping, bmCode);
                        continue;
                    }
                    log.error("{}[getSubListGetHeaders] code({}) ignored to generate children .list.get, cause child({} in model_info) not exists in modelSchemaMap({})", new Object[]{CLASS_LOG_TAG, modelCode, childTableName, modelSchemaMap.keySet()});
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{}[getSubListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)childTableListGetHeaders.size());
        } else {
            log.warn("{}[getSubListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({})", (Object)CLASS_LOG_TAG, (Object)0);
        }
        return childTableListGetHeaders;
    }

    public Map<String, Map<String, List<DWEAIHeader>>> getBMListGetHeadersByProd(Method setMappingMethod, Optional<Class<?>> optionalEaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Map<String, List<DWEAIHeader>>> childTableListGetHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        if (!optionalEaiClazz.isPresent()) {
            log.warn("{}[getBMListGetHeadersByProd] *** BM *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
            return childTableListGetHeadersMap;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        List validMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> !StringUtils.equals((CharSequence)mappingModelInfo.getChildtbl(), (CharSequence)mappingModelInfo.getTablename())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(validMappingModelInfos) && listGetMethod != null) {
            log.info("{} [getBMListGetHeaders] *** BM *** enter children .list.get", (Object)CLASS_LOG_TAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo2 : validMappingModelInfos) {
                ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
                String childTableName = mappingModelInfo2.getChildtbl();
                String eaiTableName = mappingModelInfo2.getTablename();
                String targetProdOfDWServiceMapping = mappingModelInfo2.getTargetProd();
                String userExposePrefixEaiId = mappingModelInfo2.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] *** BM *** code({}), serviceMapping-child: prod({}), child table({}), tableName({})", new Object[]{CLASS_LOG_TAG, modelinfoCount++, mappingModelInfo2.getCode(), eaiProd, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && CollectionUtils.isNotEmpty((Collection)((List)childBindApiObj))) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo2.getCode()});
                        } else if (childBindApiObj != null && CollectionUtils.isEmpty((Collection)((List)childBindApiObj))) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo2.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) ? EaiServiceNameUtil.getBMChildListGetEaiServiceId(eaiProd, childTableName) : EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child bm Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo2.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz);
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    String regProdName = BMEaiServiceNameUtil.getAppProd(userExposePrefixEaiId, eaiTableName);
                    Map prodEaiHeaders = childTableListGetHeadersMap.getOrDefault(regProdName, new HashMap());
                    List prodEspEaiHeaders = prodEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.ESP.getTechType(), new ArrayList());
                    prodEspEaiHeaders.addAll(childTableListGetHeaders);
                    prodEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), prodEspEaiHeaders);
                    childTableListGetHeadersMap.put(regProdName, prodEaiHeaders);
                    if (log.isDebugEnabled()) {
                        log.debug("{}[getBMListGetHeadersByProd] BM()  --->> ESP add prod{} eai service id:({}) by code [{}] ", new Object[]{CLASS_LOG_TAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo2.getCode()});
                    }
                    if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping)) {
                        List prodNacosEaiHeaders = prodEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.NACOS.getTechType(), new ArrayList());
                        prodNacosEaiHeaders.addAll(childTableListGetHeaders);
                        prodEaiHeaders.put(RegisterServiceTechTypeEnum.NACOS.getTechType(), prodNacosEaiHeaders);
                        childTableListGetHeadersMap.put(regProdName, prodEaiHeaders);
                        this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo2.getCode(), mappingModelInfo2.getTargetProd(), eaiTableName, true, childTableName));
                        if (log.isDebugEnabled()) {
                            log.debug("{}  --->> NACOS add prod{} eai service id:({}) by code [{}] ", new Object[]{CLASS_LOG_TAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo2.getCode()});
                        }
                    }
                } else {
                    log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
                }
                log.info("{} serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)childTableListGetHeaders.size());
            }
        } else {
            log.warn("{} serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
        }
        return childTableListGetHeadersMap;
    }

    public Map<String, List<DWEAIHeader>> getTechBMListGetHeadersByProd(Method setMappingMethod, Optional<Class<?>> optionalEaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, List<DWEAIHeader>> childTableListGetHeadersMap = new HashMap<String, List<DWEAIHeader>>();
        if (!optionalEaiClazz.isPresent()) {
            log.warn("{}[getBMListGetHeadersByProd] *** BM *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
            return childTableListGetHeadersMap;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        ArrayList espEaiHeaders = new ArrayList();
        ArrayList nacosEaiHeaders = new ArrayList();
        List validMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> !StringUtils.equals((CharSequence)mappingModelInfo.getChildtbl(), (CharSequence)mappingModelInfo.getTablename())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(validMappingModelInfos) && listGetMethod != null) {
            log.info("{} [getBMListGetHeaders] *** BM *** enter children .list.get", (Object)CLASS_LOG_TAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo2 : validMappingModelInfos) {
                ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
                String childTableName = mappingModelInfo2.getChildtbl();
                String eaiTableName = mappingModelInfo2.getTablename();
                String targetProdOfDWServiceMapping = mappingModelInfo2.getTargetProd();
                String userExposePrefixEaiId = mappingModelInfo2.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] *** BM *** code({}), serviceMapping-child: prod({}), child table({}), tableName({})", new Object[]{CLASS_LOG_TAG, modelinfoCount++, mappingModelInfo2.getCode(), eaiProd, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && CollectionUtils.isNotEmpty((Collection)((List)childBindApiObj))) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo2.getCode()});
                        } else if (childBindApiObj != null && CollectionUtils.isEmpty((Collection)((List)childBindApiObj))) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo2.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) ? EaiServiceNameUtil.getBMChildListGetEaiServiceId(eaiProd, childTableName) : EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child bm Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo2.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz);
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    String regProdName = BMEaiServiceNameUtil.getAppProd(userExposePrefixEaiId, eaiTableName);
                    espEaiHeaders.addAll(childTableListGetHeaders);
                    if (log.isDebugEnabled()) {
                        log.debug("{}[getBMListGetHeadersByProd] BM()  --->> ESP add prod{} eai service id:({}) by code [{}] ", new Object[]{CLASS_LOG_TAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo2.getCode()});
                    }
                    if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping)) {
                        nacosEaiHeaders.addAll(childTableListGetHeaders);
                        this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo2.getCode(), mappingModelInfo2.getTargetProd(), eaiTableName, true, childTableName));
                        if (log.isDebugEnabled()) {
                            log.debug("{}  --->> NACOS add prod{} eai service id:({}) by code [{}] ", new Object[]{CLASS_LOG_TAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo2.getCode()});
                        }
                    }
                } else {
                    log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
                }
                log.info("{} serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)childTableListGetHeaders.size());
            }
        } else {
            log.warn("{} serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
        }
        childTableListGetHeadersMap.put(RegisterServiceTechTypeEnum.ESP.getTechType(), espEaiHeaders);
        childTableListGetHeadersMap.put(RegisterServiceTechTypeEnum.NACOS.getTechType(), nacosEaiHeaders);
        return childTableListGetHeadersMap;
    }

    @Override
    public Map<String, List<DWEAIHeader>> getTechEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> espEaiHeaders = new ArrayList<DWEAIHeader>();
        ArrayList<DWEAIHeader> nacosEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Optional<Class<?>> optionalStdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        HashMap<String, Object> childrenBindApi = new HashMap<String, Object>();
        int serviceMapCount = 0;
        int newServiceMappingHeaderCount = 0;
        ArrayList<String> modelCodesForUserExistTable = new ArrayList<String>();
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String modelCode = eaiService.getCode();
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            String useExistedTable = modelSchema.getUseExistedTable();
            ModelCreateTypeEnum useExistedTableEnum = ModelCreateTypeEnum.getTypeEnum(useExistedTable);
            if (useExistedTableEnum != null && useExistedTableEnum == ModelCreateTypeEnum.EXISTED_TABLE) {
                modelCodesForUserExistTable.add(modelCode);
                continue;
            }
            if (log.isDebugEnabled()) {
                String userExposePrefixEaiId = eaiService.getExposeEaiId();
                String regProdName = eaiService.getProd();
                String serviceSimpleInfo = eaiService.toSimpleString();
                log.debug("{}[{}] serviceMapping: regProd({}), eaiService({}),userExposePrefixEaiId({}}) processing ... ", new Object[]{CLASS_LOG_TAG, serviceMapCount, regProdName, serviceSimpleInfo, userExposePrefixEaiId});
            }
            List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping) && bindApiListConfig == null) {
                List<DWEAIHeader> stdListGetHeaders = this.modelStandardEAIHeaderBuilder.getStdEaiHeaders(setMappingMethod, eaiService, this.modelDrivenEaiMethodRepo);
                espEaiHeaders.addAll(stdListGetHeaders);
                continue;
            }
            List<BindApi> bmdBindApiListConfig = modelSchema.getBmdApiListConfig();
            List<DWEAIHeader> bmEaiHeaders = this.getBMEaiHeaders(setMappingMethod, eaiService, this.bmEaiMethodRepository, bindApiListConfig, bmdBindApiListConfig);
            espEaiHeaders.addAll(bmEaiHeaders);
            nacosEaiHeaders.addAll(bmEaiHeaders);
        }
        newServiceMappingHeaderCount = espEaiHeaders.size();
        HashMap<String, List<DWEAIHeader>> techEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        techEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), espEaiHeaders);
        techEaiHeaders.put(RegisterServiceTechTypeEnum.NACOS.getTechType(), nacosEaiHeaders);
        mappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> !modelCodesForUserExistTable.contains(mappingModelInfo.getCode())).collect(Collectors.toList());
        int newMappingModelInfoHeaderCount = 0;
        if (CollectionUtils.isNotEmpty(mappingModelInfos)) {
            List<MappingModelInfo> stdMappingModelInfo;
            Method bmListGetMethod = this.bmEaiMethodRepository.getListGetMethod();
            Optional<Class<?>> bmEaiCrudClazz = this.bmEaiMethodRepository.getEaiClazz();
            List<MappingModelInfo> bmMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmMappingModelInfos)) {
                Map<String, List<DWEAIHeader>> bmSubListGetHeadersMap = this.getTechBMListGetHeadersByProd(setMappingMethod, bmEaiCrudClazz, bmListGetMethod, bmMappingModelInfos, childrenBindApi);
                RegTypeUtil.mergeTechType(techEaiHeaders, bmSubListGetHeadersMap);
                int bmSubListGetHeaderCount = MapUtils.isNotEmpty(bmSubListGetHeadersMap) ? bmSubListGetHeadersMap.size() : 0;
                newMappingModelInfoHeaderCount += bmSubListGetHeaderCount;
            }
            if (CollectionUtils.isNotEmpty(stdMappingModelInfo = mappingModelInfos.stream().filter(mappingModelInfo -> StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())).collect(Collectors.toList()))) {
                Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
                Map<String, List<DWEAIHeader>> stdListGetHeadersMap = this.modelStandardEAIHeaderBuilder.getTechStdListGetHeaders(setMappingMethod, optionalStdEaiCrudClazz, stdListGetMethod, stdMappingModelInfo, childrenBindApi);
                if (MapUtils.isNotEmpty(stdListGetHeadersMap)) {
                    RegTypeUtil.mergeTechType(techEaiHeaders, stdListGetHeadersMap);
                }
                int stdSubListGetHeaderCount = MapUtils.isNotEmpty(stdListGetHeadersMap) ? stdListGetHeadersMap.size() : 0;
                newMappingModelInfoHeaderCount += stdSubListGetHeaderCount;
            }
            log.debug("{}[getEaiHeaders] *** BM *** getEaiHeaders=bm({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{CLASS_LOG_TAG, newServiceMappingHeaderCount, newMappingModelInfoHeaderCount, serviceMapCount});
        }
        return techEaiHeaders;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdEaiHeadersByService(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        HashMap<String, Map<String, List<DWEAIHeader>>> prodEaiHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        ArrayList espEaiHeaders = new ArrayList();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        HashMap<String, Object> childrenBindApi = new HashMap<String, Object>();
        int serviceMapCount = 0;
        int newServiceMappingHeaderCount = 0;
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            String regProdName = eaiService.getProd();
            if (log.isDebugEnabled()) {
                String userExposePrefixEaiId = eaiService.getExposeEaiId();
                String serviceSimpleInfo = eaiService.toSimpleString();
                log.debug("{}[{}] serviceMapping: regProd({}), eaiService({}),userExposePrefixEaiId({}}) processing ... ", new Object[]{CLASS_LOG_TAG, serviceMapCount, regProdName, serviceSimpleInfo, userExposePrefixEaiId});
            }
            List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
            String targetProdOfDWServiceMapping = eaiService.getTargetProd();
            Map prodEaiHeaders = prodEaiHeadersMap.getOrDefault(regProdName, new HashMap());
            if (StringUtils.isBlank((CharSequence)targetProdOfDWServiceMapping) && bindApiListConfig == null) {
                List<DWEAIHeader> stdListGetHeaders = this.modelStandardEAIHeaderBuilder.getStdEaiHeaders(setMappingMethod, eaiService, this.modelDrivenEaiMethodRepo);
                List prodNacosEaiHeaders = prodEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.ESP.getTechType(), new ArrayList());
                prodNacosEaiHeaders.addAll(stdListGetHeaders);
                prodEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), prodNacosEaiHeaders);
                prodEaiHeadersMap.put(regProdName, prodEaiHeaders);
                continue;
            }
            List<DWEAIHeader> bmEaiHeaders = this.generateBMEaiHeaders(setMappingMethod, eaiService, this.bmEaiMethodRepository, bindApiListConfig);
            List prodEspEaiHeaders = prodEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.ESP.getTechType(), new ArrayList());
            prodEspEaiHeaders.addAll(bmEaiHeaders);
            List prodNacosEaiHeaders = prodEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.NACOS.getTechType(), new ArrayList());
            prodNacosEaiHeaders.addAll(bmEaiHeaders);
            prodEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), prodEspEaiHeaders);
            prodEaiHeaders.put(RegisterServiceTechTypeEnum.NACOS.getTechType(), prodNacosEaiHeaders);
            prodEaiHeadersMap.put(regProdName, prodEaiHeaders);
        }
        newServiceMappingHeaderCount = espEaiHeaders.size();
        int newMappingModelInfoHeaderCount = 0;
        if (CollectionUtils.isNotEmpty(mappingModelInfos)) {
            List<MappingModelInfo> stdMappingModelInfo;
            Method bmListGetMethod = this.bmEaiMethodRepository.getListGetMethod();
            Optional<Class<?>> bmEaiCrudClazz = this.bmEaiMethodRepository.getEaiClazz();
            List<MappingModelInfo> bmMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bmMappingModelInfos)) {
                Map<String, Map<String, List<DWEAIHeader>>> bmSubListGetHeadersMap = this.getBMListGetHeadersByProd(setMappingMethod, bmEaiCrudClazz, bmListGetMethod, bmMappingModelInfos, childrenBindApi);
                RegTypeUtil.mergeRegType(prodEaiHeadersMap, bmSubListGetHeadersMap);
                int bmSubListGetHeaderCount = MapUtils.isNotEmpty(bmSubListGetHeadersMap) ? bmSubListGetHeadersMap.size() : 0;
                newMappingModelInfoHeaderCount += bmSubListGetHeaderCount;
            }
            if (CollectionUtils.isNotEmpty(stdMappingModelInfo = mappingModelInfos.stream().filter(mappingModelInfo -> StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())).collect(Collectors.toList()))) {
                Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
                Map<String, Map<String, List<DWEAIHeader>>> stdListGetHeadersMap = this.modelStandardEAIHeaderBuilder.getStdListGetHeadersByProd(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfo, childrenBindApi);
                if (MapUtils.isNotEmpty(stdListGetHeadersMap)) {
                    RegTypeUtil.mergeRegType(prodEaiHeadersMap, stdListGetHeadersMap);
                }
                int stdSubListGetHeaderCount = MapUtils.isNotEmpty(stdListGetHeadersMap) ? stdListGetHeadersMap.size() : 0;
                newMappingModelInfoHeaderCount += stdSubListGetHeaderCount;
            }
            log.debug("{}[getEaiHeaders] *** BM *** getEaiHeaders=bm({})+mappingModelInfos({}) from serviceMappings({})", new Object[]{CLASS_LOG_TAG, newServiceMappingHeaderCount, newMappingModelInfoHeaderCount, serviceMapCount});
        }
        return prodEaiHeadersMap;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdTechEaiHeaders(Map<String, List<DWServiceMapping>> serviceMappingMap, Map<String, List<MappingModelInfo>> mappingModelInfosMap) throws Exception {
        return new HashMap<String, Map<String, List<DWEAIHeader>>>();
    }

    @Override
    public List<TechEaiData> getTechEaiData(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        return new ArrayList<TechEaiData>();
    }

    public void updateBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders, List<BindApi> bmdApiListConfig) {
        Map<String, BMCode> newBMCodes = BMCodeUtil.getBMBusinessLayerBMCodes(eaiService, eaiHeaders, bmdApiListConfig, BMRole.bm);
        this.bmCodes.putAll(newBMCodes);
    }

    @Override
    public void clearEaiHeaders() {
        this.bmEaiMethodRepository.getEaiHeaders().clear();
    }
}

