/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.utils;

import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BMDataModelSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(BMDataModelSqlGenerator.class);
    private static final String CLASS_LOG_TAG = "[" + BMDataModelSqlGenerator.class.getSimpleName() + "]";

    public static SqlParam generateInsertServiceMappingSql() {
        ModelDTO model = ModelDrivenContext.getContext().getPublishedModel();
        ModelSchemaDTO modelSchema = model.getSchema();
        ModelTable modelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema, false);
        String tableName = modelTable.getName();
        String appProd = model.getAppInfo().getProd();
        String targetProd = model.getAppInfo().getTargetProd();
        String modelDrivenProdPrefix = EaiServiceNameUtil.convertEaiIdTypeForServiceMapping(appProd);
        String eaiIdOfServiceMapping = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, tableName);
        log.debug("{}[generateInsertServiceMappingSql] *** BMD *** get eaiIdOfServiceMapping {}", (Object)CLASS_LOG_TAG, (Object)eaiIdOfServiceMapping);
        SqlParam returnValue = new SqlParam(BMConstants.BM_INSERT_SERVICE_MAPPING_ON_DUPLICATE_KEY, new Object[]{tableName, eaiIdOfServiceMapping, targetProd, tableName, eaiIdOfServiceMapping, targetProd});
        return returnValue;
    }
}

