/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eai.builder;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.enums.ModelApiTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.pojo.TechEaiData;
import com.digiwin.lcdp.modeldriven.utils.BMCodeUtil;
import com.digiwin.lcdp.modeldriven.utils.BindedApiUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ModelStandardEaiHeaderBuilder
implements EaiHeaderBuilder {
    private static final Logger log = LoggerFactory.getLogger(ModelStandardEaiHeaderBuilder.class);
    private static final String CLASS_LOG_TAG = "[" + ModelStandardEaiHeaderBuilder.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;

    @Override
    public List<DWEAIHeader> getEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        HashMap<String, Object> childrenBindApi = new HashMap<String, Object>();
        int serviceMapCount = 0;
        for (DWServiceMapping eaiService : serviceMappings) {
            ++serviceMapCount;
            String eaiTableName = eaiService.getTableName();
            String modelCode = eaiService.getCode();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = eaiService.getProd();
            String eaiServiceInfo = eaiService.toSimpleString();
            log.debug("{} serviceMapping record[{}]: prod({}), eaiService({}) ... process userExposePrefixEaiId({})", new Object[]{CLASS_LOG_TAG, serviceMapCount, eaiProd, eaiServiceInfo, userExposePrefixEaiId});
            String modelSchemaStr = eaiService.getModelSchema();
            ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr, modelCode);
            if (Objects.isNull(modelSchema)) {
                String errorMessage = String.format("%s[getEaiHeaders] serviceMapping record[%s]: prod(%s), code(%s), cause modelSchema wrong", CLASS_LOG_TAG, serviceMapCount, eaiProd, modelCode);
                log.error(errorMessage);
                ModelDTO draftModel = ModelDrivenContext.getContext().getDraftModel();
                if (Objects.isNull(draftModel)) continue;
                throw new DWBusinessException(errorMessage);
            }
            List<DWEAIHeader> stdEaiHeaders = this.generateStdEaiHeader(modelSchema, setMappingMethod, eaiService);
            if (CollectionUtils.isNotEmpty(stdEaiHeaders) && this.bmCodes != null) {
                this.updateStdBMCodes(eaiService, stdEaiHeaders);
            }
            newEaiHeaders.addAll(stdEaiHeaders);
            List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(modelSchema.getChildren());
            allChildrenSchemas.stream().filter(childModelSchema -> BindedApiUtil.hasBindApiConfig(childModelSchema.getBindApiListConfig())).forEach(childModelSchema -> {
                childrenBindApi.put(childModelSchema.getName(), childModelSchema.getBindApiListConfig());
                List childrenBindApiList = childModelSchema.getBindApiListConfig().stream().map(BindApi::getApiName).collect(Collectors.toList());
                log.info("{} code({}) table_name({}) children bindApiList({})", new Object[]{CLASS_LOG_TAG, modelCode, eaiTableName, childrenBindApiList});
            });
            if (!log.isDebugEnabled()) continue;
            List eaiHeaderNames = stdEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
            log.debug("{} code({}) gen EAIHeaders --> master table_name({}), eaiHeaderNames({})", new Object[]{CLASS_LOG_TAG, modelCode, eaiTableName, eaiHeaderNames});
        }
        if (CollectionUtils.isNotEmpty(mappingModelInfos)) {
            List<DWEAIHeader> stdListGetHeaders = this.getStdListGetEAIHeaders(setMappingMethod, stdEaiCrudClazz, mappingModelInfos, childrenBindApi);
            newEaiHeaders.addAll(stdListGetHeaders);
            if (log.isDebugEnabled()) {
                List childrenEaiHeaderNames = stdListGetHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
                log.debug("{} gen children eaiHeaderName({})", (Object)CLASS_LOG_TAG, childrenEaiHeaderNames);
            }
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getStdEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, ModelDrivenEaiMethodRepository mdEaiMethodRepo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = mdEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> optionalEaiClazz = mdEaiMethodRepo.getEaiClazz();
        if (!optionalEaiClazz.isPresent()) {
            log.warn("{}[getStdEaiHeaders] *** STD *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
            return newEaiHeaders;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String eaiProd = eaiService.getProd();
        String eaiServiceInfo = eaiService.toSimpleString();
        log.debug("{}[getStdEaiHeaders] serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({})", new Object[]{CLASS_LOG_TAG, eaiProd, eaiServiceInfo, eaiTableName, userExposePrefixEaiId});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz);
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
        }
        log.debug("{}[getStdEaiHeaders] serviceMapping: prod({}) eaiService({}) process table_name({}) expose_eai_id({})", new Object[]{CLASS_LOG_TAG, eaiProd, eaiServiceInfo, eaiTableName, newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList())});
        return newEaiHeaders;
    }

    private List<DWEAIHeader> getBindApiEAIHeader(Method setMappingMethod, ModelDrivenEaiMethodRepository eaiMethodRepo, List<BindApi> bindApiListConfig) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = eaiMethodRepo.getEaiMethodRepo();
        List mdServiceNames = mdEaiMethods.keySet().stream().collect(Collectors.toList());
        Optional<Class<?>> eaiClazz = eaiMethodRepo.getEaiClazz();
        for (BindApi bindApi : bindApiListConfig) {
            String apiNameOfBindApi = bindApi.getApiName();
            String apiTypeOfBindApi = bindApi.getApiType();
            Optional<String> optMatchServiceName = mdServiceNames.stream().filter(mdServiceName -> mdServiceName.contains("." + apiTypeOfBindApi)).findFirst();
            if (optMatchServiceName.isPresent()) {
                String actualEaiId = optMatchServiceName.get();
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethods.get(actualEaiId);
                DWEAIHeader headerV = new DWEAIHeader("commons", apiNameOfBindApi, eaiClazz.get());
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                continue;
            }
            log.info("{}[getBindApiStdEAIHeader] can't find lcdp base method, bindApi({}) ", (Object)CLASS_LOG_TAG, (Object)bindApi);
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getStdListGetEAIHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
        return this.getStdListGetHeaders(setMappingMethod, eaiClazz, stdListGetMethod, mappingModelInfos, childrenBindApi);
    }

    public List<DWEAIHeader> getStdListGetHeaders(Method setMappingMethod, Optional<Class<?>> optionalEaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> returnValue = new ArrayList<DWEAIHeader>();
        if (!optionalEaiClazz.isPresent()) {
            log.warn("{}[getStdListGetHeaders] *** STD *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
            return returnValue;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        log.info("{}[getStdListGetHeaders] mappingModelInfos size:{}", (Object)CLASS_LOG_TAG, (Object)mappingModelInfos.size());
        if (CollectionUtils.isNotEmpty(mappingModelInfos) && listGetMethod != null) {
            int modelinfoCount = 0;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ++modelinfoCount;
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String modelCode = mappingModelInfo.getCode();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] serviceMapping-child: prod({}), child table({}), tableName({}), code({})", new Object[]{CLASS_LOG_TAG, modelinfoCount++, eaiProd, childTableName, eaiTableName, modelCode});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && CollectionUtils.isNotEmpty((Collection)((List)childBindApiObj))) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, modelCode});
                        } else if (childBindApiObj != null && CollectionUtils.isEmpty((Collection)((List)childBindApiObj))) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)modelCode);
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child Std Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, modelCode});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz);
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    returnValue.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("  --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)modelCode);
                    }
                    BMCode bmCode = new BMCode(modelCode, mappingModelInfo.getTargetProd(), eaiTableName, true, childTableName);
                    bmCode.setApiType(ModelApiTypeEnum.LIST.getApiTypeName());
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, bmCode);
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("{}[getStdListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)returnValue.size());
        } else {
            log.warn("{}[getStdListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
        }
        return returnValue;
    }

    @Override
    public List<DWEAIHeader> getSubListGetHeaders(Method setMappingMethod, List<MappingModelInfo> mappingModelInfos, ModelSchemaDTO modelSchema) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> returnValue = new ArrayList<DWEAIHeader>();
        Method listGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
        Optional<Class<?>> optionalEaiClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        if (!optionalEaiClazz.isPresent()) {
            log.warn("{}[getBMListGetHeadersByProd] *** BM *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
            return returnValue;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        if (CollectionUtils.isNotEmpty(mappingModelInfos) && listGetMethod != null) {
            log.info("{}[getStdSubListGetHeaders] enter children .list.get", (Object)CLASS_LOG_TAG);
            Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
            int modelinfoCount = 0;
            HashMap<String, BMCode> currentBMCodes = new HashMap<String, BMCode>();
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ++modelinfoCount;
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String modelCode = mappingModelInfo.getCode();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] code({}) serviceMapping-child: prod({}), child table({}), masterTableName({})", new Object[]{CLASS_LOG_TAG, modelinfoCount, modelCode, eaiProd, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    ModelSchemaDTO subModelSchema = modelSchemaMap.get(childTableName);
                    if (subModelSchema != null) {
                        List<BindApi> subBmdApiListConfig = subModelSchema.getBmdApiListConfig();
                        boolean hasChildrenBindApi = BindedApiUtil.hasBindApiConfig(subBmdApiListConfig);
                        if (hasChildrenBindApi) {
                            for (BindApi bindApi : subBmdApiListConfig) {
                                String apiName = bindApi.getApiName();
                                String apiType = bindApi.getApiType();
                                DWEAIHeader headerV = new DWEAIHeader("commons", apiName, eaiClazz);
                                setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                                returnValue.add(headerV);
                                log.debug("{}[{}] code({}]) child Bind Aapi: hasBindApiList({}) child Bind Api({}), eaiTableName({})", new Object[]{CLASS_LOG_TAG, modelinfoCount, modelCode, hasChildrenBindApi, headerV.getEAIServiceId(), eaiTableName});
                                BMCode bmCode = new BMCode(modelCode, null, eaiTableName, true, childTableName);
                                bmCode.setApiType(apiType);
                                currentBMCodes.put(apiName, bmCode);
                            }
                            continue;
                        }
                        String childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz);
                        setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                        returnValue.add(headerV);
                        if (log.isDebugEnabled()) {
                            log.debug("{} code({})  --->> add eai service id:({})", new Object[]{CLASS_LOG_TAG, modelCode, headerV.getEAIServiceId()});
                        }
                        BMCode bmCode = new BMCode(modelCode, mappingModelInfo.getTargetProd(), eaiTableName, true, childTableName);
                        bmCode.setApiType(ModelApiTypeEnum.LIST.getApiTypeName());
                        currentBMCodes.put(childEaiServiceIdForServiceMapping, bmCode);
                        continue;
                    }
                    log.error("{}[getSubListGetHeaders] code({}) ignored to generate children .list.get, cause child({} in model_info) not exists in modelSchemaMap({})", new Object[]{CLASS_LOG_TAG, modelCode, childTableName, modelSchemaMap.keySet()});
                    continue;
                }
                log.warn("{}[getSubListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
            }
            this.bmCodes.putAll(currentBMCodes);
        }
        return returnValue;
    }

    public Map<String, Map<String, List<DWEAIHeader>>> getStdListGetHeadersByProd(Method setMappingMethod, Optional<Class<?>> optionalEaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Map<String, List<DWEAIHeader>>> childTableListGetHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        if (!optionalEaiClazz.isPresent()) {
            log.warn("{}[getStdListGetHeadersByProd] *** STD *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
            return childTableListGetHeadersMap;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        if (CollectionUtils.isNotEmpty(mappingModelInfos) && listGetMethod != null) {
            log.info("{}[getStdListGetHeaders] enter children .list.get", (Object)CLASS_LOG_TAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] serviceMapping-child: prod({}), child table({}), tableName({}), code({})", new Object[]{CLASS_LOG_TAG, modelinfoCount++, eaiProd, childTableName, eaiTableName, mappingModelInfo.getCode()});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && CollectionUtils.isNotEmpty((Collection)((List)childBindApiObj))) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                        } else if (childBindApiObj != null && CollectionUtils.isEmpty((Collection)((List)childBindApiObj))) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child Std Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz);
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    String regProdName = BMEaiServiceNameUtil.getAppProd(userExposePrefixEaiId, eaiTableName);
                    Map prodEaiHeaders = childTableListGetHeadersMap.getOrDefault(regProdName, new HashMap());
                    List prodEspEaiHeaders = prodEaiHeaders.getOrDefault(RegisterServiceTechTypeEnum.ESP.getTechType(), new ArrayList());
                    prodEspEaiHeaders.addAll(childTableListGetHeaders);
                    prodEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), prodEspEaiHeaders);
                    childTableListGetHeadersMap.put(regProdName, prodEaiHeaders);
                    if (log.isDebugEnabled()) {
                        log.debug("{}[getStdListGetHeadersByProd] BM()  --->> ESP add prod{} eai service id:({}) by code [{}] ", new Object[]{CLASS_LOG_TAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo.getCode()});
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("  --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                    if (BMProperties.getProperties() != null && BMProperties.getProperties().getRole() == BMRole.bm) {
                        this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo.getCode(), mappingModelInfo.getTargetProd(), eaiTableName, true, childTableName));
                    }
                } else {
                    log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
                }
                log.info("{}[getStdListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)childTableListGetHeaders.size());
            }
        } else {
            log.warn("{}[getStdListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
        }
        return childTableListGetHeadersMap;
    }

    public Map<String, List<DWEAIHeader>> getTechStdListGetHeaders(Method setMappingMethod, Optional<Class<?>> optionalEaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos, Map<String, Object> childrenBindApi) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, List<DWEAIHeader>> childTableListGetHeadersMap = new HashMap<String, List<DWEAIHeader>>();
        if (!optionalEaiClazz.isPresent()) {
            log.warn("{}[getTechStdListGetHeaders] *** STD *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
            return childTableListGetHeadersMap;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        ArrayList espEaiHeaders = new ArrayList();
        if (CollectionUtils.isNotEmpty(mappingModelInfos) && listGetMethod != null) {
            log.info("{}[getStdListGetHeaders] enter children .list.get", (Object)CLASS_LOG_TAG);
            int modelinfoCount = 1;
            boolean hasChildrenBindApi = MapUtils.isNotEmpty(childrenBindApi);
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("{}[{}] serviceMapping-child: prod({}), child table({}), tableName({}), code({})", new Object[]{CLASS_LOG_TAG, modelinfoCount++, eaiProd, childTableName, eaiTableName, mappingModelInfo.getCode()});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = "";
                    if (hasChildrenBindApi && childrenBindApi.containsKey(childTableName)) {
                        Object childBindApiObj = childrenBindApi.get(childTableName);
                        if (childBindApiObj != null && CollectionUtils.isNotEmpty((Collection)((List)childBindApiObj))) {
                            BindApi childBindApi = (BindApi)((List)childBindApiObj).get(0);
                            childEaiServiceIdForServiceMapping = childBindApi.getApiName();
                            log.debug(" --->> child Bind Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                        } else if (childBindApiObj != null && CollectionUtils.isEmpty((Collection)((List)childBindApiObj))) {
                            log.info(" --->> ignored gen DWEAIHeader, cause child BindApi is empty, eaiTableName({}) of code [{}] ", (Object)eaiTableName, (Object)mappingModelInfo.getCode());
                            continue;
                        }
                    } else {
                        childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                        log.debug(" --->> child Std Api({}), eaiTableName({}) of code [{}] ", new Object[]{childEaiServiceIdForServiceMapping, eaiTableName, mappingModelInfo.getCode()});
                    }
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz);
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    String regProdName = BMEaiServiceNameUtil.getAppProd(userExposePrefixEaiId, eaiTableName);
                    espEaiHeaders.addAll(childTableListGetHeaders);
                    if (log.isDebugEnabled()) {
                        log.debug("{}[getStdListGetHeadersByProd] BM()  --->> ESP add prod{} eai service id:({}) by code [{}] ", new Object[]{CLASS_LOG_TAG, regProdName, headerV.getEAIServiceId(), mappingModelInfo.getCode()});
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("  --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo.getCode(), mappingModelInfo.getTargetProd(), eaiTableName, true, childTableName));
                } else {
                    log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
                }
                log.info("{}[getStdListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)CLASS_LOG_TAG, (Object)childTableListGetHeaders.size());
            }
        } else {
            log.warn("{}[getStdListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", new Object[]{CLASS_LOG_TAG, 0, listGetMethod});
        }
        childTableListGetHeadersMap.put(RegisterServiceTechTypeEnum.ESP.getTechType(), espEaiHeaders);
        return childTableListGetHeadersMap;
    }

    @Override
    public Map<String, List<DWEAIHeader>> getTechEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        List<DWEAIHeader> newESPEaiHeaders = this.getEaiHeaders(serviceMappings, mappingModelInfos);
        HashMap<String, List<DWEAIHeader>> techEaiHeaders = new HashMap<String, List<DWEAIHeader>>();
        techEaiHeaders.put(RegisterServiceTechTypeEnum.ESP.getTechType(), newESPEaiHeaders);
        return techEaiHeaders;
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdTechEaiHeaders(Map<String, List<DWServiceMapping>> serviceMappings, Map<String, List<MappingModelInfo>> mappingModelInfos) throws Exception {
        return new HashMap<String, Map<String, List<DWEAIHeader>>>();
    }

    @Override
    public Map<String, Map<String, List<DWEAIHeader>>> getProdEaiHeadersByService(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        return new HashMap<String, Map<String, List<DWEAIHeader>>>();
    }

    public void addIgnoreIntercepter(List<DWEAIHeader> dweaiHeaders) {
        List ignoreInterceptorEaiNames = dweaiHeaders.stream().filter(newEaiHeader -> BMConstants.getBmdOldModelServiceName().stream().noneMatch(existedName -> StringUtils.equals((CharSequence)existedName, (CharSequence)newEaiHeader.getEAIServiceId()))).map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        BMConstants.getBmdOldModelServiceName().addAll(ignoreInterceptorEaiNames);
    }

    public void addIgnoreIntercepter(DWEAIHeader dweaiHeader) {
        ArrayList<DWEAIHeader> ignoreInterceptorEaiHeaders = new ArrayList<DWEAIHeader>();
        ignoreInterceptorEaiHeaders.add(dweaiHeader);
        this.addIgnoreIntercepter(ignoreInterceptorEaiHeaders);
    }

    @Override
    public void clearEaiHeaders() {
    }

    @Override
    public List<TechEaiData> getTechEaiData(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        return new ArrayList<TechEaiData>();
    }

    public List<DWEAIHeader> generateStdEaiHeader(ModelSchemaDTO modelSchema, Method setMappingMethod, DWServiceMapping eaiService) throws InvocationTargetException, IllegalAccessException {
        String eaiTableName = eaiService.getTableName();
        String modelCode = eaiService.getCode();
        List<BindApi> bindApiListConfig = modelSchema.getBindApiListConfig();
        boolean hasBindApiList = BindedApiUtil.hasBindApiConfig(bindApiListConfig);
        List<DWEAIHeader> newStdEaiHeaders = hasBindApiList ? this.getBindApiEAIHeader(setMappingMethod, this.modelDrivenEaiMethodRepo, bindApiListConfig) : this.getStdEaiHeaders(setMappingMethod, eaiService, this.modelDrivenEaiMethodRepo);
        log.debug("{}[getStdEaiHeader] stdEaiHeaders({}) <== code({}), table_name({}), hasBindApiList({})", new Object[]{CLASS_LOG_TAG, CollectionUtils.isNotEmpty(newStdEaiHeaders) ? newStdEaiHeaders.size() : 0, modelCode, eaiTableName, hasBindApiList});
        return newStdEaiHeaders;
    }

    public void updateStdBMCodes(DWServiceMapping eaiService, List<DWEAIHeader> eaiHeaders) {
        Map<String, BMCode> newBMCodes = BMCodeUtil.getStandardBMCodes(eaiService, eaiHeaders);
        this.bmCodes.putAll(newBMCodes);
    }
}

