/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionElementDeserializer;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDrivenDataPermission
extends DWDataPermission {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenDataPermission.class);
    private static Gson customGson = null;

    public static Object getDataPermission(String moduleId, String actionId, String sysId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        Object userId = profile.get("userId");
        String userToken = DWServiceContext.getContext().getToken();
        boolean selfTag = true;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sysId", sysId);
        params.put("userId", userId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        params.put("self", selfTag);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data");
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        Object returnValue = ModelDrivenDataPermission.invokeDataPermission(serviceModel);
        return returnValue;
    }

    private static synchronized Gson getCustomGson() {
        if (customGson == null) {
            GsonBuilder builder = new GsonBuilder().serializeNulls();
            builder.registerTypeAdapter(DWRowPermissionElement.class, (Object)new DWRowPermissionElementDeserializer());
            customGson = builder.create();
        }
        return customGson;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object invokeDataPermission(ServiceModel serviceModel) throws Exception {
        void var2_7;
        Map serviceModelParams = serviceModel.getParams();
        DWUserPermission dWUserPermission = new DWUserPermission();
        Gson gson = ModelDrivenDataPermission.getCustomGson();
        boolean selfTag = serviceModelParams.getOrDefault("self", true);
        try {
            HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
            String iamResponseBody = iamResponseModel.getResponseBody();
            int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
            if (iamResponseStatusCode == 200) {
                Object object = gson.fromJson(iamResponseBody, DWUserPermission.class);
                return var2_7;
            }
            if (!selfTag) {
                String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCode, iamResponseBody);
                log.warn("invokeDataPermission failed (self={}), cause:{}", (Object)selfTag, (Object)errorMessage);
                throw new DWException(errorMessage);
            }
            selfTag = false;
            serviceModelParams.put("self", selfTag);
            Object responseObj = ModelDrivenDataPermission.invokeDataPermission(serviceModel);
            HttpResponseModel iamResponseModelSelfFalse = (HttpResponseModel)responseObj;
            String iamResponseBodySelfFalse = iamResponseModelSelfFalse.getResponseBody();
            int iamResponseStatusCodeSelfFalse = iamResponseModelSelfFalse.getHttpStatusCode();
            if (iamResponseStatusCodeSelfFalse != 200) {
                String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCodeSelfFalse, iamResponseBodySelfFalse);
                log.warn("invokeDataPermission failed (self={}), cause:{}", (Object)selfTag, (Object)errorMessage);
                throw new DWException(errorMessage);
            }
            Object object = gson.fromJson(iamResponseBodySelfFalse, DWUserPermission.class);
            return var2_7;
        }
        catch (Exception e) {
            if (!selfTag) {
                log.warn("invokeDataPermission failed(self={}) in Exception, cause:{}", (Object)selfTag, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                throw e;
            }
            selfTag = false;
            serviceModelParams.put("self", selfTag);
            Object responseObj = ModelDrivenDataPermission.invokeDataPermission(serviceModel);
            HttpResponseModel iamResponseModelSelfFalse = (HttpResponseModel)responseObj;
            String iamResponseBodySelfFalse = iamResponseModelSelfFalse.getResponseBody();
            int iamResponseStatusCodeSelfFalse = iamResponseModelSelfFalse.getHttpStatusCode();
            if (iamResponseStatusCodeSelfFalse != 200) {
                String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCodeSelfFalse, iamResponseBodySelfFalse);
                log.warn("invokeDataPermission failed(self={}) in Exception, cause:{}", (Object)selfTag, (Object)errorMessage);
                throw new DWException(errorMessage);
            }
            Object object = gson.fromJson(iamResponseBodySelfFalse, DWUserPermission.class);
            return var2_7;
        }
    }
}

