/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import com.digiwin.lcdp.modeldriven.utils.ModelTableSqlGenerator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ModelPublishHelper {
    private static final Logger log = LoggerFactory.getLogger(ModelPublishHelper.class);
    private static final String CLASS_LOG_TAG = "[" + ModelPublishHelper.class.getSimpleName() + "]";
    @Autowired
    private ModelTableHelperExpress modelTableHelperExpress;

    public ModelPublishedEspResult alterTableExpress() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        ModelDTO publishedModel = modelDrivenContext.getPublishedModel();
        ModelSchemaDTO publishedModelSchema = publishedModel.getSchema();
        String code = draftModel.getCode();
        return this.alterTableExpress(draftModelSchema, publishedModelSchema, code);
    }

    public ModelPublishedEspResult createOrAlterCustomizeTableExpress() throws Exception {
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        log.debug("{}[createOrAlterCustomizeTableExpress] code({}) useExistedTable={}", new Object[]{CLASS_LOG_TAG, draftModel.getCode(), draftModel.getUseExistedTable().getTypeChar()});
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        ModelSchemaUtil.checkModelSchema(draftModelSchema, true);
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        List<ModelTable> draftModelTables = draftModelTableMap.values().stream().collect(Collectors.toList());
        AtomicReference<PublishStatusEnum> createStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        DWServiceResult serviceResult = this.modelTableHelperExpress.createCustomizeTableExpress(draftModelTables);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("[createOrAlterCustomizeTableExpress] expected(%b) actual(%b), description:(%s)", createStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            createStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            createStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(createStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    public ModelPublishedEspResult alterTableExpress(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema, String code) throws Exception {
        String masterTableName = draftModelSchema.getName();
        log.debug("=============== alterTable ====== {} =========", (Object)masterTableName);
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        Map<String, LinkedHashMap<String, List<SqlParam>>> alterMasterTableMap = ModelTableSqlGenerator.filterAlterTableCommand();
        LinkedHashMap<String, List<SqlParam>> alterMap = alterMasterTableMap.get(publishedModelSchema.getName());
        LinkedList alterDDLSqlParam = (LinkedList)alterMap.get("ddl");
        LinkedList alterDMLSqlParam = (LinkedList)alterMap.get("dml");
        alterStatus.set(PublishStatusEnum.CHANGED);
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> alterTableMap = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        String tableName = publishedModelSchema.getName();
        Map<String, LinkedHashMap<String, List<SqlParam>>> alterChildrenTableMap = ModelTableSqlGenerator.getChildrenFullLevelAlterTableCommands(tableName, draftModelSchema.getChildren(), publishedModelSchema.getChildren());
        List<SqlParam> updateModelSqlParam = ModelSqlGenerator.generateUpdateModelSql(draftModel);
        alterDMLSqlParam.addAll(updateModelSqlParam);
        if (!CollectionUtils.isEmpty((Collection)alterDMLSqlParam) || !CollectionUtils.isEmpty((Collection)alterDDLSqlParam)) {
            alterMap.put("dml", alterDMLSqlParam);
            alterMap.put("ddl", alterDDLSqlParam);
            alterTableMap.put(publishedModelSchema.getName(), alterMap);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        Map draftModelTableMap = (Map)modelDrivenContext.getExtraMap().get("draftModelTables");
        List<ModelTable> modelAllTables = draftModelTableMap.values().stream().collect(Collectors.toList());
        List<SqlParam> updateModelInfoParams = ModelSqlGenerator.generateUpdateModelInfoSql(modelAllTables, code);
        alterDMLSqlParam.addAll(updateModelInfoParams);
        List<SqlParam> updateServiceMappingParam = ModelSqlGenerator.getInsertOrUpdateServiceMapping(draftModel);
        alterDMLSqlParam.addAll(updateServiceMappingParam);
        alterTableMap.putAll(alterChildrenTableMap);
        if (MapUtils.isNotEmpty(alterChildrenTableMap)) {
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        DWServiceResult serviceResult = this.modelTableHelperExpress.alterTableExpress(alterTableMap);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("create: expected(%b) actual(%b), description:(%s)", alterStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            alterStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            alterStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(alterStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    public DWSQLExecutionResult deletePublished(ModelDTO model, DWDataRow publishedDataRow) throws Exception {
        Assert.hasText((String)model.getCode(), (String)"model code must not be null or empty");
        Assert.hasText((String)model.getAppId(), (String)"model appid must not be null or empty");
        String code = model.getCode();
        DWSQLExecutionResult returnResult = new DWSQLExecutionResult();
        if (publishedDataRow != null && MapUtils.isNotEmpty((Map)publishedDataRow.getData())) {
            ModelSchemaDTO modelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
            AtomicReference<PublishStatusEnum> dropStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
            List<String> tableNames = ModelSchemaUtil.getTableNames(modelSchema);
            boolean dropRunStatus = this.modelTableHelperExpress.dropTableExpress(tableNames, model);
            if (dropRunStatus) {
                dropStatus.set(PublishStatusEnum.SUCCESS);
                returnResult.addDeleteCount(code, 1);
            } else {
                dropStatus.set(PublishStatusEnum.FAILURE);
                returnResult.addDeleteCount(code, 0);
            }
            if (log.isDebugEnabled()) {
                log.debug("code({}) drop status: expected({}) actual({})", new Object[]{code, dropStatus, dropRunStatus});
            }
            ModelDrivenMetadataUtil.removeRdbmsMetadata(code, tableNames);
        }
        return returnResult;
    }
}

