/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBColumnUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelIndexUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.google.gson.Gson;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSchemaUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelSchemaUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ModelSchemaUtil.class.getSimpleName() + "]";

    public static List<String> getChildrenName(List<ModelSchemaDTO> childrenSchemas) {
        List<String> childrenModelSchemaNames = new ArrayList<String>();
        List<ModelSchemaDTO> childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas);
        if (CollectionUtils.isNotEmpty(childrenModelSchema)) {
            childrenModelSchemaNames = childrenModelSchema.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
        }
        return childrenModelSchemaNames;
    }

    public static List<ModelSchemaDTO> getChildrenModelSchema(List<ModelSchemaDTO> childrenSchemas) {
        if (CollectionUtils.isEmpty(childrenSchemas)) {
            return new ArrayList<ModelSchemaDTO>();
        }
        return ModelSchemaUtil.getChildrenModelSchema(childrenSchemas, 1);
    }

    protected static List<ModelSchemaDTO> getChildrenModelSchema(List<ModelSchemaDTO> childrenSchemas, int level) {
        ArrayList<ModelSchemaDTO> childrenModelSchema = new ArrayList<ModelSchemaDTO>();
        if (level <= 5 && !CollectionUtils.isEmpty(childrenSchemas)) {
            List childrenModelSchemaNames = childrenSchemas.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
            log.debug("process children at level {} , current childrenModelSchema {}", (Object)level, childrenModelSchemaNames);
            childrenModelSchema.addAll(childrenSchemas);
            for (ModelSchemaDTO childModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> modelSchemaDTOList = ModelSchemaUtil.getChildrenModelSchema(childModelSchema.getChildren(), level + 1);
                childrenModelSchema.addAll(modelSchemaDTOList);
            }
        } else {
            log.debug("end: level {} over maxlevel or empty children({})", (Object)level, (Object)childrenSchemas.size());
        }
        return childrenModelSchema;
    }

    public static List<ModelTable> getModelTables(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (BooleanUtils.isTrue((Boolean)includeCollection)) {
            return ModelSchemaUtil.getModelTables(modelSchema);
        }
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
        ArrayList<ModelTable> modelTables = new ArrayList<ModelTable>();
        for (ModelSchemaDTO tempModelSchema : modelSchemaMap.values()) {
            ModelTable tempModelTable = ModelSchemaUtil.getCurrentLevelModelTable(tempModelSchema, includeCollection);
            modelTables.add(tempModelTable);
        }
        return modelTables;
    }

    public static ModelTable getCurrentLevelModelTable(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (modelSchema == null) {
            return null;
        }
        return ModelSchemaUtil.convertToSimpleModelTable(modelSchema, includeCollection);
    }

    public static List<String> getCurrentLevelChildNames(ModelSchemaDTO modelSchema) {
        return ModelSchemaUtil.getCurrentLevelChildNames(modelSchema.getChildren());
    }

    public static List<String> getCurrentLevelChildNames(List<ModelSchemaDTO> childrenModelSchema) {
        return childrenModelSchema.stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
    }

    public static List<ModelTable> getModelTables(ModelSchemaDTO modelSchema) {
        List<ModelSchemaDTO> childrenModelSchema;
        ArrayList<ModelSchemaDTO> modelSchemas = new ArrayList<ModelSchemaDTO>();
        modelSchemas.add(modelSchema);
        ArrayList<ModelTable> modelTables = new ArrayList<ModelTable>();
        List<ModelSchemaDTO> childrenSchemas = modelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenSchemas) && !CollectionUtils.isEmpty(childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas))) {
            modelSchemas.addAll(childrenModelSchema);
        }
        for (ModelSchemaDTO tempModelSchema : modelSchemas) {
            ModelTable tempModelTable = ModelSchemaUtil.getCurrentLevelModelTable(tempModelSchema);
            modelTables.add(tempModelTable);
        }
        return modelTables;
    }

    public static ModelTable getCurrentLevelModelTable(ModelSchemaDTO modelSchema) {
        if (modelSchema == null) {
            return null;
        }
        return ModelSchemaUtil.getCurrentLevelModelTable(modelSchema, false);
    }

    public static TableIndex convertModelIndexToTable(ModelIndexDTO modelIndex) {
        if (modelIndex == null) {
            return null;
        }
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(modelIndex.getId());
        tableIndex.setMember(modelIndex.getMember());
        if (modelIndex.getType() != null) {
            tableIndex.setType(IndexTypeEnum.getIndexType(modelIndex.getType()));
        }
        return tableIndex;
    }

    public static TableIndex convertTableColumnToTableUniqueIndex(TableColumn tableColumn) {
        if (tableColumn == null) {
            return null;
        }
        String columnName = tableColumn.getColumnName();
        ArrayList<String> members = new ArrayList<String>();
        members.add(columnName);
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(columnName);
        tableIndex.setMember(members);
        tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
        log.debug("[ModelSchemaUtil] found column unique index({})", (Object)columnName);
        return tableIndex;
    }

    public static TableIndex convertModelIndexToTableIndex(ModelIndexDTO modelIndex) {
        return ModelSchemaUtil.convertModelIndexToTable(modelIndex);
    }

    public static ModelIndexDTO convertTableIndexToModelIndex(TableIndex tableIndex) {
        if (tableIndex == null) {
            return null;
        }
        ModelIndexDTO modelIndexDTO = new ModelIndexDTO();
        modelIndexDTO.setId(tableIndex.getName());
        modelIndexDTO.setMember(tableIndex.getMember());
        if (tableIndex.getType() != null) {
            modelIndexDTO.setType(tableIndex.getType().getIndexChar());
        }
        return modelIndexDTO;
    }

    public static TableColumn convertModelFieldToTableColumn(ModelFieldDTO modelField) {
        if (modelField == null) {
            return null;
        }
        String fieldType = modelField.getType();
        ModelFieldRelationTypeEnum relationTypeEnum = ModelFieldRelationTypeEnum.valueOf(fieldType);
        if (log.isDebugEnabled() && relationTypeEnum == ModelFieldRelationTypeEnum.COLLECTION) {
            log.debug("{}[convertModelFieldToTableColumn] modelField '{}' is {}", new Object[]{CLASS_LOG_TAG, modelField.getFieldId(), fieldType});
        }
        return DBColumnUtil.convertToTableColumn(modelField);
    }

    public static TableColumn convertToTableColumn(ModelFieldDTO modelField) {
        return DBColumnUtil.convertToTableColumn(modelField);
    }

    public static List<String> getTableNames(ModelSchemaDTO modelSchemaDTO) {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(modelSchemaDTO.getName());
        List<ModelSchemaDTO> childrenSchemas = modelSchemaDTO.getChildren();
        if (CollectionUtils.isNotEmpty(childrenSchemas)) {
            List<ModelSchemaDTO> childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas);
            childrenModelSchema.stream().forEach(cModelSchema -> tableNames.add(cModelSchema.getName()));
        }
        return tableNames;
    }

    public static ModelTable convertToSimpleModelTable(ModelSchemaDTO modelSchema) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = new ModelTable();
        modelTable.setName(modelSchema.getName());
        modelTable.setComment(modelSchema.getComment());
        List<TableColumn> tableColumns = modelSchema.getFields().stream().map(ModelSchemaUtil::convertModelFieldToTableColumn).collect(Collectors.toList());
        modelTable.setColumns(tableColumns);
        return modelTable;
    }

    public static ModelTable convertToSimpleModelTable(ModelSchemaDTO modelSchema, boolean includeCollection) {
        String msPk;
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = new ModelTable();
        modelTable.setName(modelSchema.getName());
        modelTable.setComment(modelSchema.getComment());
        List<TableColumn> allTableColumns = BooleanUtils.isTrue((Boolean)includeCollection) ? modelSchema.getFields().stream().map(ModelSchemaUtil::convertModelFieldToTableColumn).collect(Collectors.toList()) : modelSchema.getFields().stream().filter(DBColumnUtil::checkValidType).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        modelTable.setColumns(allTableColumns);
        List<TableColumn> collectColumns = modelSchema.getFields().stream().filter(modelField -> StringUtils.equals((CharSequence)ModelFieldRelationTypeEnum.COLLECTION.getValue(), (CharSequence)modelField.getType())).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collectColumns)) {
            modelTable.setCollectionColumns(collectColumns);
        }
        List<TableIndex> tableIndexes = new ArrayList<TableIndex>();
        List<ModelIndexDTO> modelIndexes = modelSchema.getIndex();
        if (!CollectionUtils.isEmpty(modelIndexes)) {
            List<ModelIndexDTO> columnUniqueIndexOfModelIndexes = ModelIndexUtil.getColumnUniqueIndexOfModelIndexes(modelIndexes);
            columnUniqueIndexOfModelIndexes.stream().forEach(modelIndex -> allTableColumns.stream().filter(tableColumn -> modelIndex.getId().equals(tableColumn.getColumnName())).findFirst().ifPresent(tableColumn -> tableColumn.setUnique(true)));
            log.debug("[ModelSchemaUtil] modelSchema({}) index({}) reset to column unique", (Object)modelSchema.getName(), columnUniqueIndexOfModelIndexes);
            modelIndexes.removeAll(columnUniqueIndexOfModelIndexes);
            tableIndexes = modelIndexes.stream().map(ModelSchemaUtil::convertModelIndexToTable).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)(msPk = modelSchema.getPk()))) {
            modelTable.setPk(msPk);
            List<String> pks = Arrays.stream(msPk.split(",")).map(String::trim).collect(Collectors.toList());
            TableIndex pkTableIndex = new TableIndex();
            pkTableIndex.setName("PRIMARY KEY");
            pkTableIndex.setMember(pks);
            pkTableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
            tableIndexes.add(pkTableIndex);
        }
        modelTable.setIndexes(tableIndexes);
        return modelTable;
    }

    public static void checkModelSchema(ModelSchemaDTO modelSchema, boolean isCreate) {
        ModelDataUtil.preCheckSchema(modelSchema);
        List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenModelSchema)) {
            childrenModelSchema.forEach(childFormSchema -> ModelSchemaUtil.checkModelSchema(childFormSchema, isCreate));
        }
    }

    public static Map<AlterColumnEnum, List<TableColumn>> getAlterColumnsMap(ModelTable draftModelTable) {
        String tableName = draftModelTable.getName();
        if (log.isDebugEnabled()) {
            log.debug("publishing model (comparing fields) -> draftModelTable = {}", (Object)tableName);
        }
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map dbModelTables = (Map)modelDrivenContext.getExtraMap().get("actualModelTablesFromDB");
        ModelTable actualModelTable = (ModelTable)MapUtils.getObject((Map)dbModelTables, (Object)tableName);
        Assert.notNull((Object)actualModelTable, (String)"master table is not existed in database(get from cache of actualModelTablesFromDB");
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        List<TableColumn> addColumns = ColumnCompareUtil.getAddColumns(draftTableColumns, actualTableColumns);
        List<TableColumn> modifyColumns = ColumnCompareUtil.getModifyColumns(draftTableColumns, actualTableColumns);
        List<TableColumn> dropColumns = null;
        if (!modelDrivenContext.isNewModelPublish()) {
            log.info("modified model -> process drop columns in draftTable({})", (Object)tableName);
            Map publishedModelTables = (Map)ModelDrivenContext.getContext().getExtraMap().get("publishedModelTables");
            ModelTable publishedModelTable = (ModelTable)MapUtils.getObject((Map)publishedModelTables, (Object)tableName, (Object)new ModelTable());
            List<TableColumn> publishTableColumns = publishedModelTable.getColumns();
            List<TableColumn> draftCollectionColumns = draftModelTable.getCollectionColumns();
            dropColumns = ColumnCompareUtil.getDropColumns(draftTableColumns, actualTableColumns, publishTableColumns, draftCollectionColumns);
        } else {
            List<TableColumn> draftCollectionColumns = draftModelTable.getCollectionColumns();
            if (CollectionUtils.isNotEmpty(draftCollectionColumns)) {
                dropColumns = ColumnCompareUtil.getDropCollectionColumns(actualTableColumns, draftCollectionColumns);
                log.info("{}[getAlterColumnsMap] new model(drop Collection Columns({})) in draftTable({})", new Object[]{CLASS_LOG_TAG, dropColumns.stream().map(Field::getColumnName).collect(Collectors.toList()), tableName});
            }
            log.info("new model -> drop columns only collection in draftTable({})", (Object)tableName);
        }
        EnumMap<AlterColumnEnum, List<TableColumn>> alterTableColumnsMap = new EnumMap<AlterColumnEnum, List<TableColumn>>(AlterColumnEnum.class);
        if (CollectionUtils.isNotEmpty(dropColumns)) {
            alterTableColumnsMap.put(AlterColumnEnum.DROP_COLUMN, dropColumns);
        }
        if (CollectionUtils.isNotEmpty(addColumns)) {
            alterTableColumnsMap.put(AlterColumnEnum.ADD_COLUMN, addColumns);
        }
        if (CollectionUtils.isNotEmpty(modifyColumns)) {
            alterTableColumnsMap.put(AlterColumnEnum.MODIFY_COLUMN, modifyColumns);
        }
        return alterTableColumnsMap;
    }

    public static ModelSchemaDTO getModelSchema(String modelSchemaJsonStr) {
        ModelSchemaDTO modelSchema = null;
        try {
            modelSchema = (ModelSchemaDTO)DWGsonProvider.getGson().fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            log.error("{}[getModelSchema] modelSchema json format wrong({})", (Object)CLASS_LOG_TAG, (Object)rootCauseMessage);
        }
        return modelSchema;
    }

    public static ModelSchemaDTO getModelSchema(String modelSchemaJsonStr, String code) {
        ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaJsonStr);
        if (Objects.isNull(modelSchema)) {
            log.debug("{}[getModelSchema] code({}) modelSchema is null, maybe bad format.", (Object)CLASS_LOG_TAG, (Object)code);
        }
        return modelSchema;
    }

    public static ModelDTO getModel(DWDataRow dataRow) {
        ModelDTO newModel = new ModelDTO();
        newModel.setTargetTenantId((String)dataRow.get("target_tenant_id"));
        newModel.setCode((String)dataRow.get("code"));
        newModel.setDescription((String)dataRow.get("description"));
        newModel.setAppId((String)dataRow.get("app_id"));
        ModelSchemaDTO modelSchemaDTO = ModelSchemaUtil.parseModelSchema(dataRow);
        newModel.setSchema(modelSchemaDTO);
        return newModel;
    }

    public static ModelSchemaDTO parseModelSchema(DWDataRow dataRow) {
        String code = (String)dataRow.get("code");
        String modelSchemaJsonStr = (String)dataRow.get("model_schema");
        if (StringUtils.isEmpty((CharSequence)modelSchemaJsonStr)) {
            throw new IllegalArgumentException(String.format("\u6a21\u578b %s \u7d00\u9304\u7684\u7d50\u69cb\u70ba\u7a7a", code));
        }
        Gson gson = DWGsonProvider.getGson();
        return (ModelSchemaDTO)gson.fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
    }

    public static Map<String, ModelSchemaDTO> getModelSchemaMap(ModelSchemaDTO masterModelSchema) {
        HashMap<String, ModelSchemaDTO> result = new HashMap<String, ModelSchemaDTO>();
        result.put(masterModelSchema.getName(), masterModelSchema);
        List<ModelSchemaDTO> childrenModelSchemas = masterModelSchema.getChildren();
        List<ModelSchemaDTO> validChildrenModelSchemas = ModelSchemaUtil.getChildrenModelSchema(childrenModelSchemas);
        if (CollectionUtils.isNotEmpty(validChildrenModelSchemas)) {
            validChildrenModelSchemas.stream().forEach(childrenModelSchema -> result.put(childrenModelSchema.getName(), (ModelSchemaDTO)childrenModelSchema));
        }
        return result;
    }

    public static Map<String, ModelTable> getModelTableMap(List<ModelTable> modelTables) {
        HashMap<String, ModelTable> returnValue = new HashMap<String, ModelTable>();
        if (!CollectionUtils.isEmpty(modelTables)) {
            modelTables.forEach(modelTable -> returnValue.put(modelTable.getName(), (ModelTable)modelTable));
        }
        return returnValue;
    }

    public static List<String> getPrimaryKeys(List<TableColumn> customColumns) {
        List<TableColumn> getPrimaryKeyColumns = ModelSchemaUtil.getPrimaryKeyColumns(customColumns);
        return getPrimaryKeyColumns.stream().map(Field::getColumnName).collect(Collectors.toList());
    }

    public static List<TableColumn> getPrimaryKeyColumns(List<TableColumn> customColumns) {
        return customColumns.stream().filter(Field::isPK).collect(Collectors.toList());
    }

    public static ModelTableSchemaCache getModelTableSchemaCache(ModelTable actualModelTable) {
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        Map<String, Object> actualRemainTableIndexeMap = ModelIndexUtil.getAllTableIndexes(actualModelTable);
        List<ModelIndexDTO> actualColumnUniqueIndexes = ModelIndexUtil.getColumnUniqueIndexes(actualModelTable);
        actualColumnUniqueIndexes.stream().forEach(columnUniqueIndex -> actualRemainTableIndexeMap.put(columnUniqueIndex.getId(), ModelSchemaUtil.convertModelIndexToTableIndex(columnUniqueIndex)));
        ModelTableSchemaCache publishedTableSchemaCache = new ModelTableSchemaCache();
        publishedTableSchemaCache.setPublishedRemainIndexes(actualRemainTableIndexeMap);
        TableColumn actualAutoIncrmtColumn = DBColumnUtil.getAutoIncrementColumn(actualTableColumns);
        if (actualAutoIncrmtColumn != null) {
            publishedTableSchemaCache.setAutoIncrementColumn(actualAutoIncrmtColumn);
        }
        publishedTableSchemaCache.setTableName(actualModelTable.getName());
        return publishedTableSchemaCache;
    }

    public static void reorganize(ModelSchemaDTO masterModelSchema) {
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(masterModelSchema);
        for (Map.Entry<String, ModelSchemaDTO> entry : modelSchemaMap.entrySet()) {
            ModelSchemaDTO modelSchema = entry.getValue();
            List<ModelFieldDTO> modelFields = modelSchema.getFields();
            modelFields.stream().filter(modelField -> ModelDBConstants.MODEL_DATATYPE_NEED_COVERT_JSON.contains(modelField.getFieldType())).forEach(modelField -> modelField.setFieldType(DataTypeEnum.JSON.getName()));
        }
    }
}

