/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class SqlParserUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlParserUtil.class);
    private static final String CLASS_LOG_TAG = "[" + SqlParserUtil.class.getSimpleName() + "]";

    public static List<String> getSql(String sqlFilePath) {
        List<String> sqlArr = new ArrayList<String>();
        try {
            InputStreamReader isr = new InputStreamReader(SqlParserUtil.class.getClassLoader().getResourceAsStream(sqlFilePath), StandardCharsets.UTF_8);
            String sqlStr = FileCopyUtils.copyToString((Reader)isr);
            sqlArr = Arrays.asList(sqlStr.split(";\r\n"));
        }
        catch (IOException e) {
            logger.error("{}[getSql] {}", (Object)CLASS_LOG_TAG, (Object)ExceptionUtils.getRootCause((Throwable)e));
        }
        return sqlArr;
    }

    public static Table getTableObj(String sql) throws JSQLParserException {
        Table targetTable = null;
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            FromItem fromItem = select.getFromItem();
            if (fromItem instanceof Table) {
                targetTable = (Table)fromItem;
            } else {
                while (fromItem instanceof SubSelect && ((SubSelect)fromItem).getSelectBody() != null) {
                    SubSelect subSelect = (SubSelect)fromItem;
                    PlainSelect ssubSelect = (PlainSelect)subSelect.getSelectBody();
                    if (ssubSelect.getFromItem() instanceof Table) {
                        targetTable = (Table)ssubSelect.getFromItem();
                        break;
                    }
                    if (!(ssubSelect.getFromItem() instanceof SubSelect)) continue;
                    fromItem = ssubSelect.getFromItem();
                }
            }
        } else {
            String errorMessage = String.format("sql is not a select statement:'%s'", sql);
            throw new IllegalArgumentException(errorMessage);
        }
        logger.debug("{} get tableName '{}' from sql '{}'", new Object[]{CLASS_LOG_TAG, targetTable, sql});
        return targetTable;
    }

    public static String getMainTable(String sql) throws JSQLParserException {
        String tableName = "";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            Table table = SqlParserUtil.getTableObj(sql);
            Assert.notNull((Object)table, (String)("table is null from sql '" + sql + "'"));
            tableName = table.getName();
            logger.debug("{} get tableName '{}' from sql '{}'", new Object[]{CLASS_LOG_TAG, tableName, sql});
            return tableName;
        }
        String errorMessage = String.format("%s sql is not a select statement:'%s'", CLASS_LOG_TAG, sql);
        throw new IllegalArgumentException(errorMessage);
    }
}

