/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.compare;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.ColumnNullableEnum;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.utils.DBColumnUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnCompareUtil {
    private static final Logger log = LoggerFactory.getLogger(ColumnCompareUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ColumnCompareUtil.class.getSimpleName() + "]";

    private ColumnCompareUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static List<TableColumn> getAddColumns(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns) {
        return draftTableColumns.stream().filter(draftTableColumn -> DBColumnUtil.checkValidType(draftTableColumn) && actualTableColumns.stream().noneMatch(actualColumn -> Objects.equals(draftTableColumn.getColumnName(), actualColumn.getColumnName()))).collect(Collectors.toList());
    }

    public static List<TableColumn> getModifyColumns(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns) {
        return draftTableColumns.stream().filter(draftTableColumn -> DBColumnUtil.checkValidType(draftTableColumn) && actualTableColumns.stream().anyMatch(actualColumn -> draftTableColumn.getColumnName().equals(actualColumn.getColumnName()) && !draftTableColumn.equalsIgnoredUnique(actualColumn))).collect(Collectors.toList());
    }

    public static List<TableColumn> getDropColumns(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns, List<TableColumn> publishTableColumns, List<TableColumn> draftCollectionColumns) {
        List dropColumnsByComparedModel = publishTableColumns.stream().filter(publishedColumn -> DBColumnUtil.checkValidType(publishedColumn) && draftTableColumns.stream().noneMatch(draftModelField -> Objects.equals(publishedColumn.getColumnName(), draftModelField.getColumnName()))).collect(Collectors.toList());
        List<TableColumn> validDropColumns = dropColumnsByComparedModel.stream().filter(dropColumn -> actualTableColumns.stream().anyMatch(actualTableColumn -> Objects.equals(dropColumn.getColumnName(), actualTableColumn.getColumnName()))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(draftCollectionColumns)) {
            List<TableColumn> candidateDropCollectionColumns = ColumnCompareUtil.getDropCollectionColumns(actualTableColumns, draftCollectionColumns);
            List validDropColumnNames = validDropColumns.stream().map(Field::getColumnName).collect(Collectors.toList());
            candidateDropCollectionColumns.stream().forEach(candidateDraftCollectionColumn -> {
                String candidateDraftCollectionColumnName = candidateDraftCollectionColumn.getColumnName();
                if (!validDropColumnNames.contains(candidateDraftCollectionColumnName)) {
                    validDropColumns.add((TableColumn)((Object)candidateDraftCollectionColumn));
                    log.info("{} validDropColumns, drop ({}) COLLECTION column, cause exists column in table", (Object)CLASS_LOG_TAG, (Object)candidateDraftCollectionColumnName);
                }
            });
        }
        log.info("{} validDropColumns({}) = dropColumnsByComparedModel({}) anyMatch in actualTableColumns:({})", new Object[]{CLASS_LOG_TAG, validDropColumns.stream().map(Field::getColumnName).collect(Collectors.toList()), dropColumnsByComparedModel.stream().map(Field::getColumnName).collect(Collectors.toList()), actualTableColumns.stream().map(Field::getColumnName).collect(Collectors.toList())});
        return validDropColumns;
    }

    public static List<TableColumn> getDropCollectionColumns(List<TableColumn> actualTableColumns, List<TableColumn> draftCollectionColumns) {
        ArrayList<TableColumn> candidateDropCollectionColumns = new ArrayList();
        if (CollectionUtils.isNotEmpty(draftCollectionColumns)) {
            candidateDropCollectionColumns = draftCollectionColumns.stream().filter(candidateDraftCollectionColumn -> actualTableColumns.stream().anyMatch(actualTableColumn -> Objects.equals(candidateDraftCollectionColumn.getColumnName(), actualTableColumn.getColumnName()))).collect(Collectors.toList());
        }
        log.debug("{}[getDropCollectionColumns] candidateDropCollectionColumns({})", (Object)CLASS_LOG_TAG, candidateDropCollectionColumns.stream().map(Field::getColumnName).collect(Collectors.toList()));
        return candidateDropCollectionColumns;
    }

    public static Map<AlterAutoIncrementEnum, TableColumn> getChangeAutoIncrementColumn(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns) {
        LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changeMap = new LinkedHashMap<AlterAutoIncrementEnum, TableColumn>();
        boolean isActualHasAutoIncrementColumn = true;
        TableColumn actualColumnWithAutoIncrement = DBColumnUtil.getAutoIncrementColumn(actualTableColumns);
        if (actualColumnWithAutoIncrement == null) {
            isActualHasAutoIncrementColumn = false;
        }
        boolean isDraftHasAutoIncrementColumn = true;
        TableColumn draftColumnWithAutoIncrement = DBColumnUtil.getAutoIncrementColumn(draftTableColumns);
        if (draftColumnWithAutoIncrement == null) {
            isDraftHasAutoIncrementColumn = false;
        }
        log.debug("{} autoIncrement status, draft({}),actual({})", new Object[]{CLASS_LOG_TAG, draftColumnWithAutoIncrement, actualColumnWithAutoIncrement});
        if (isActualHasAutoIncrementColumn) {
            if (isDraftHasAutoIncrementColumn) {
                if (!StringUtils.equals((CharSequence)actualColumnWithAutoIncrement.getColumnName(), (CharSequence)draftColumnWithAutoIncrement.getColumnName())) {
                    changeMap.put(AlterAutoIncrementEnum.DROP, actualColumnWithAutoIncrement);
                    changeMap.put(AlterAutoIncrementEnum.ADD, draftColumnWithAutoIncrement);
                    log.info("{} autoIncrement drop actual({}),add draft({})", new Object[]{CLASS_LOG_TAG, actualColumnWithAutoIncrement.getColumnName(), draftColumnWithAutoIncrement.getColumnName()});
                } else {
                    log.info("{} autoIncrement ignore change(same columnName)", (Object)CLASS_LOG_TAG);
                }
            } else {
                changeMap.put(AlterAutoIncrementEnum.DROP, actualColumnWithAutoIncrement);
            }
        } else if (isDraftHasAutoIncrementColumn) {
            changeMap.put(AlterAutoIncrementEnum.ADD, draftColumnWithAutoIncrement);
        }
        log.debug("{}[getChangeAutoIncrementColumn] changeMap ({})", (Object)CLASS_LOG_TAG, changeMap);
        return changeMap;
    }

    public static String getTypeDDL(TableColumn field) {
        DataTypeEnum dataType = field.getDataType();
        String type = dataType.getType();
        String name = dataType.getName();
        Integer size = field.getSize();
        if (Objects.isNull(size)) {
            size = dataType.getDefaultSize();
        }
        if ("TEXT".equals(type) && ModelDBConstants.SQL_DATATYPE_NAME_WITHOUT_SIZE.contains(name)) {
            return name + " ";
        }
        String[] timeTypeNameWithSize = new String[]{"DATETIME", "TIME", "TIMESTAMP"};
        if ("TIME".equals(type) && Arrays.stream(timeTypeNameWithSize).anyMatch(timeType -> name.equals(timeType) && field.getSize() != null)) {
            return String.format("%s(%s) ", name, size);
        }
        if ("TIME".equals(type)) {
            return name + " ";
        }
        if ("REAL".equals(type)) {
            Integer scale = field.getScale();
            if (Objects.isNull(scale)) {
                scale = dataType.getDefaultScale();
            }
            return String.format("%s(%s,%s) ", name, size, scale);
        }
        return String.format("%s(%s) ", name, size);
    }

    public static ColumnNullableEnum getNullableEnum(boolean bool) {
        return bool ? ColumnNullableEnum.NULL : ColumnNullableEnum.NOT_NULL;
    }

    public static String booleanToYN(boolean bool) {
        return bool ? "Y" : "N";
    }

    public static String columnUniqueValue(boolean bool) {
        return bool ? "UNIQUE" : "";
    }

    public static String getSqlByAutoIncrementOrDefaultValue(TableColumn tableColumn) {
        return ColumnCompareUtil.getSqlByAutoIncrementOrDefaultValue(tableColumn, false);
    }

    public static String getSqlByAutoIncrementOrDefaultValue(TableColumn tableColumn, boolean combinePk) {
        Boolean isAutoIncrement = tableColumn.getAutoIncrement();
        if (BooleanUtils.isTrue((Boolean)isAutoIncrement)) {
            return ColumnCompareUtil.getAutoIncrement(combinePk);
        }
        return ColumnCompareUtil.getDefaultValue(tableColumn);
    }

    public static String getAutoIncrement(boolean combinePk) {
        String autoIncrementCmd = "AUTO_INCREMENT";
        if (combinePk) {
            autoIncrementCmd = autoIncrementCmd + " " + "PRIMARY KEY";
        }
        return autoIncrementCmd;
    }

    public static String getDefaultValue(TableColumn tableColumn) {
        String defaultValue = tableColumn.getDefaultValue();
        String defaultValueType = tableColumn.getDefaultValueType();
        boolean defaultValueIsExpr = tableColumn.getDefaultValueIsExpr();
        if (defaultValueIsExpr && defaultValueType.equalsIgnoreCase("expression")) {
            return "DEFAULT " + defaultValue;
        }
        DataTypeEnum dataType = tableColumn.getDataType();
        String defaultValueSqlSyntax = dataType == DataTypeEnum.BIT ? ColumnCompareUtil.getBitDefaultValue(defaultValue) : ColumnCompareUtil.getNotBitDefaultValue(defaultValue);
        return defaultValueSqlSyntax;
    }

    public static String getBitDefaultValue(String defaultValue) {
        boolean isEqualNumberOne;
        String defaultValueSqlSyntax = defaultValue != null ? ((isEqualNumberOne = defaultValue.equalsIgnoreCase("1")) ? "DEFAULT TRUE" : "DEFAULT FALSE") : "";
        return defaultValueSqlSyntax;
    }

    public static String getNotBitDefaultValue(String defaultValue) {
        String defaultValueSqlSyntax;
        if (defaultValue != null) {
            boolean isEqualDoubleQuotes = defaultValue.equals("\"\"");
            String subDefaultValue = isEqualDoubleQuotes ? "" : defaultValue;
            defaultValueSqlSyntax = "DEFAULT '" + subDefaultValue + "'";
        } else {
            defaultValueSqlSyntax = "";
        }
        return defaultValueSqlSyntax;
    }

    public static String getDefaultValue(TableColumn tableColumn, boolean existedTable) {
        if (existedTable) {
            String columnName = tableColumn.getColumnName();
            if (columnName.equals("create_date")) {
                return "DEFAULT current_timestamp()";
            }
            if (columnName.equals("modified_date")) {
                return "DEFAULT NULL ON UPDATE current_timestamp()";
            }
        }
        return ColumnCompareUtil.getDefaultValue(tableColumn);
    }

    public static Integer getUpdateSize(Integer updatedInteger, Integer defaultInteger) {
        if (Objects.isNull(updatedInteger)) {
            if (Objects.isNull(defaultInteger)) {
                return 0;
            }
            return defaultInteger;
        }
        return updatedInteger;
    }
}

