/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.datetime;

import com.digiwin.lcdp.modeldriven.constants.ModelDrivenDataTimeConstants;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class ModelDrivenDateTimeFormatUtil {
    private ModelDrivenDateTimeFormatUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static LocalDateTime parse(String dateTimeStr, DateTimeFormatter formatter) {
        try {
            return LocalDateTime.parse(dateTimeStr, formatter);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u6642\u9593\u683c\u5f0f\u932f\u8aa4\uff1a" + dateTimeStr, e);
        }
    }

    public static String format(LocalDateTime dateTime, DateTimeFormatter formatter) {
        return dateTime.format(formatter);
    }

    public static String dashDateTimeFullFormat(LocalDateTime dateTime) {
        return dateTime.format(ModelDrivenDataTimeConstants.DASH_DATETIME);
    }

    public static String dashY4M2D2Format(LocalDate date) {
        return date.format(ModelDrivenDataTimeConstants.DASH_Y4M2D2_ONLY);
    }

    public static String dashY4M2Format(LocalDate dateTime) {
        return dateTime.format(ModelDrivenDataTimeConstants.DASH_Y4M2_ONLY);
    }

    public static LocalDateTime convertDateToLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.of("UTC+8")).toLocalDateTime();
    }
}

