/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.module.DWServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BMDataCrudUtils {
    private static final String CONF_BMD_CRUD_CREATE = "lcdp.bmd.crud.create";
    private static final String CONF_BMD_CRUD_UPDATE = "lcdp.bmd.crud.update";
    private static final String CONF_BMD_CRUD_DELETE = "lcdp.bmd.crud.delete";
    private static final String CONF_BMD_CRUD_GET = "lcdp.bmd.crud.get";
    private static final String KEY_BMD_INTF_CREATE = "create";
    private static final String KEY_BMD_INTF_UPDATE = "update";
    private static final String KEY_BMD_INTF_DELETE = "delete";
    private static final String KEY_BMD_INTF_GET = "get";

    private BMDataCrudUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, Class<?>> getInterfaceServices() {
        String bmdCrudCreateService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_CREATE);
        String bmdCrudUpdateService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_UPDATE);
        String bmdCrudDeleteService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_DELETE);
        String bmdCrudGetService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_GET);
        String[] createServiceItems = StringUtils.split((String)bmdCrudCreateService, (String)",");
        String[] updateServiceItems = StringUtils.split((String)bmdCrudUpdateService, (String)",");
        String[] deleteServiceItems = StringUtils.split((String)bmdCrudDeleteService, (String)",");
        String[] getServiceItems = StringUtils.split((String)bmdCrudGetService, (String)",");
        String intfCreateServiceName = createServiceItems[0];
        String intfUpdateServiceName = updateServiceItems[0];
        String intfDeleteServiceName = deleteServiceItems[0];
        String intfGetServiceName = getServiceItems[0];
        HashMap bmdInterfaces = new HashMap();
        try {
            Class<?> bmdCreateIntfClazz = Class.forName(intfCreateServiceName);
            Class<?> bmdUpdateIntfClazz = Class.forName(intfUpdateServiceName);
            Class<?> bmdDeleteIntfClazz = Class.forName(intfDeleteServiceName);
            Class<?> bmdGetIntfClazz = Class.forName(intfGetServiceName);
            bmdInterfaces.put(KEY_BMD_INTF_CREATE, bmdCreateIntfClazz);
            bmdInterfaces.put(KEY_BMD_INTF_UPDATE, bmdUpdateIntfClazz);
            bmdInterfaces.put(KEY_BMD_INTF_DELETE, bmdDeleteIntfClazz);
            bmdInterfaces.put(KEY_BMD_INTF_GET, bmdGetIntfClazz);
        }
        catch (ClassNotFoundException e) {
            throw new DWRuntimeException("BMDataCrudUtil getInterfaceServices error", (Throwable)e);
        }
        return bmdInterfaces;
    }

    public static Map<String, DWServiceInfo> getImplementServices(Map<String, Class<?>> bmdInterfs) {
        String bmdCrudCreateService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_CREATE);
        String bmdCrudUpdateService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_UPDATE);
        String bmdCrudDeleteService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_DELETE);
        String bmdCrudGetService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_GET);
        String[] createServiceItems = StringUtils.split((String)bmdCrudCreateService, (String)",");
        String[] updateServiceItems = StringUtils.split((String)bmdCrudUpdateService, (String)",");
        String[] deleteServiceItems = StringUtils.split((String)bmdCrudDeleteService, (String)",");
        String[] getServiceItems = StringUtils.split((String)bmdCrudGetService, (String)",");
        String implCreateServiceName = createServiceItems[1];
        String implUpdateServiceName = updateServiceItems[1];
        String implDeleteServiceName = deleteServiceItems[1];
        String implGetServiceName = getServiceItems[1];
        HashMap<String, DWServiceInfo> bmdImplements = new HashMap<String, DWServiceInfo>();
        try {
            Class<?> bmdCreateImplClazz = Class.forName(implCreateServiceName).newInstance().getClass();
            DWServiceInfo commonBMDataCreateServiceInfo = new DWServiceInfo("commons", bmdInterfs.get(KEY_BMD_INTF_CREATE), bmdCreateImplClazz);
            bmdImplements.put(KEY_BMD_INTF_CREATE, commonBMDataCreateServiceInfo);
            Class<?> bmdUpdateImplClazz = Class.forName(implUpdateServiceName).newInstance().getClass();
            DWServiceInfo commonBMDataUpdateServiceInfo = new DWServiceInfo("commons", bmdInterfs.get(KEY_BMD_INTF_UPDATE), bmdUpdateImplClazz);
            bmdImplements.put(KEY_BMD_INTF_UPDATE, commonBMDataUpdateServiceInfo);
            Class<?> bmdDeleteImplClazz = Class.forName(implDeleteServiceName).newInstance().getClass();
            DWServiceInfo commonBMDataDeleteServiceInfo = new DWServiceInfo("commons", bmdInterfs.get(KEY_BMD_INTF_DELETE), bmdDeleteImplClazz);
            bmdImplements.put(KEY_BMD_INTF_DELETE, commonBMDataDeleteServiceInfo);
            Class<?> bmdGetImplClazz = Class.forName(implGetServiceName).newInstance().getClass();
            DWServiceInfo commonBMDataGetServiceInfo = new DWServiceInfo("commons", bmdInterfs.get(KEY_BMD_INTF_GET), bmdGetImplClazz);
            bmdImplements.put(KEY_BMD_INTF_GET, commonBMDataGetServiceInfo);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new DWRuntimeException("BMDataCrudUtil getImplementServices error", (Throwable)e);
        }
        return bmdImplements;
    }

    public static List<DWServiceInfo> getImplements() {
        ArrayList<DWServiceInfo> impletList = new ArrayList<DWServiceInfo>();
        String bmdCrudCreateService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_CREATE);
        String bmdCrudUpdateService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_UPDATE);
        String bmdCrudDeleteService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_DELETE);
        String bmdCrudGetService = DWApplicationConfigUtils.getProperty((String)CONF_BMD_CRUD_GET);
        String[] createServiceItems = StringUtils.split((String)bmdCrudCreateService, (String)",");
        String[] updateServiceItems = StringUtils.split((String)bmdCrudUpdateService, (String)",");
        String[] deleteServiceItems = StringUtils.split((String)bmdCrudDeleteService, (String)",");
        String[] getServiceItems = StringUtils.split((String)bmdCrudGetService, (String)",");
        String intfCreateServiceName = createServiceItems[0];
        String intfUpdateServiceName = updateServiceItems[0];
        String intfDeleteServiceName = deleteServiceItems[0];
        String intfGetServiceName = getServiceItems[0];
        String implCreateServiceName = createServiceItems[1];
        String implUpdateServiceName = updateServiceItems[1];
        String implDeleteServiceName = deleteServiceItems[1];
        String implGetServiceName = getServiceItems[1];
        try {
            Class<?> bmdCreateIntfClazz = Class.forName(intfCreateServiceName).getClass();
            Class<?> bmdUpdateIntfClazz = Class.forName(intfUpdateServiceName).getClass();
            Class<?> bmdDeleteIntfClazz = Class.forName(intfDeleteServiceName).getClass();
            Class<?> bmdGetIntfClazz = Class.forName(intfGetServiceName).getClass();
            Class<?> bmdCreateImplClazz = Class.forName(implCreateServiceName).newInstance().getClass();
            DWServiceInfo commonBMDataCreateServiceInfo = new DWServiceInfo("commons", bmdCreateIntfClazz, bmdCreateImplClazz);
            impletList.add(commonBMDataCreateServiceInfo);
            Class<?> bmdUpdateImplClazz = Class.forName(implUpdateServiceName).newInstance().getClass();
            DWServiceInfo commonBMDataUpdateServiceInfo = new DWServiceInfo("commons", bmdUpdateIntfClazz, bmdUpdateImplClazz);
            impletList.add(commonBMDataUpdateServiceInfo);
            Class<?> bmdDeleteImplClazz = Class.forName(implDeleteServiceName).newInstance().getClass();
            DWServiceInfo commonBMDataDeleteServiceInfo = new DWServiceInfo("commons", bmdDeleteIntfClazz, bmdDeleteImplClazz);
            impletList.add(commonBMDataDeleteServiceInfo);
            Class<?> bmdGetImplClazz = Class.forName(implGetServiceName).newInstance().getClass();
            DWServiceInfo commonBMDataGetServiceInfo = new DWServiceInfo("commons", bmdGetIntfClazz, bmdGetImplClazz);
            impletList.add(commonBMDataGetServiceInfo);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new DWRuntimeException("BMDataCrudUtil getImplements error", (Throwable)e);
        }
        return impletList;
    }
}

