/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.data.DWDataPermissionOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionElementDeserializer;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDrivenDataPermission
extends DWDataPermission {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenDataPermission.class);
    private static Gson customGson = null;

    public static String getAppId() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-appid", DWDataPermission.getAppId());
    }

    public static DWUserPermission getDataPermission(String moduleId, String actionId, String sysId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        Object userId = profile.get("userId");
        String userToken = DWServiceContext.getContext().getToken();
        boolean selfTag = true;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sysId", sysId);
        params.put("userId", userId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        params.put("self", selfTag);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data");
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        DWUserPermission userPermission = ModelDrivenDataPermission.invokeDataPermission(serviceModel);
        Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContext.getContext().getExtraMap();
        if (userPermission != null) {
            modelDrivenContextExtraMap.put("dataPermission", userPermission);
        }
        return userPermission;
    }

    private static synchronized Gson getCustomGson() {
        if (customGson == null) {
            GsonBuilder builder = new GsonBuilder().serializeNulls();
            builder.registerTypeAdapter(DWRowPermissionElement.class, (Object)new DWRowPermissionElementDeserializer());
            customGson = builder.create();
        }
        return customGson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DWUserPermission invokeDataPermission(ServiceModel serviceModel) throws Exception {
        Map serviceModelParams = serviceModel.getParams();
        DWUserPermission returnValue = new DWUserPermission();
        Gson gson = ModelDrivenDataPermission.getCustomGson();
        boolean selfTag = serviceModelParams.getOrDefault("self", true);
        try {
            log.debug("[invokeDataPermission] serviceModelParams({}) selfTag({})", (Object)serviceModelParams, (Object)selfTag);
            HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
            String iamResponseBody = iamResponseModel.getResponseBody();
            int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
            if (iamResponseStatusCode == 200) return (DWUserPermission)gson.fromJson(iamResponseBody, DWUserPermission.class);
            if (selfTag) {
                selfTag = false;
                serviceModelParams.put("self", selfTag);
                DWUserPermission responseObj = ModelDrivenDataPermission.invokeDataPermission(serviceModel);
                if (responseObj instanceof DWUserPermission) {
                    return responseObj;
                }
                if (!(responseObj instanceof HttpResponseModel)) return returnValue;
                HttpResponseModel iamResponseModelSelfFalse = (HttpResponseModel)responseObj;
                String iamResponseBodySelfFalse = iamResponseModelSelfFalse.getResponseBody();
                int iamResponseStatusCodeSelfFalse = iamResponseModelSelfFalse.getHttpStatusCode();
                if (iamResponseStatusCodeSelfFalse == 200) return (DWUserPermission)gson.fromJson(iamResponseBodySelfFalse, DWUserPermission.class);
                String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCodeSelfFalse, iamResponseBodySelfFalse);
                log.warn("invokeDataPermission failed (self={}), cause:{}", (Object)selfTag, (Object)errorMessage);
                throw new DWException(errorMessage);
            }
            String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCode, iamResponseBody);
            log.warn("invokeDataPermission failed (self={}), cause:{}", (Object)selfTag, (Object)errorMessage);
            throw new DWException(errorMessage);
        }
        catch (Exception e) {
            log.warn("[invokeDataPermission] serviceModelParams({}) selfTag({}) exception:{}", new Object[]{serviceModelParams, selfTag, ExceptionUtils.getMessage((Throwable)e)});
            if (selfTag) {
                return ModelDrivenDataPermission.getPublicUserPermission(serviceModel, serviceModelParams);
            }
            log.warn("invokeDataPermission failed(self={}) in Exception, cause:{}", (Object)selfTag, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw e;
        }
    }

    private static DWUserPermission getPublicUserPermission(ServiceModel serviceModel, Map<String, Object> serviceModelParams) throws Exception {
        DWUserPermission returnValue = new DWUserPermission();
        Gson gson = ModelDrivenDataPermission.getCustomGson();
        serviceModelParams.put("self", false);
        DWUserPermission responseObj = ModelDrivenDataPermission.invokeDataPermission(serviceModel);
        if (responseObj instanceof DWUserPermission) {
            return responseObj;
        }
        HttpResponseModel iamResponseModelSelfFalse = (HttpResponseModel)responseObj;
        String iamResponseBodySelfFalse = iamResponseModelSelfFalse.getResponseBody();
        int iamResponseStatusCodeSelfFalse = iamResponseModelSelfFalse.getHttpStatusCode();
        if (iamResponseStatusCodeSelfFalse != 200) {
            String errorMessage = String.format(ResourceBundleUtils.getString("lcdp.modeldriven.permission.data.failed"), iamResponseStatusCodeSelfFalse, iamResponseBodySelfFalse);
            log.warn("getSelfUserPermission failed(self=false) in Exception, cause:{}", (Object)errorMessage);
            throw new DWException(errorMessage);
        }
        returnValue = (DWUserPermission)gson.fromJson(iamResponseBodySelfFalse, DWUserPermission.class);
        return returnValue;
    }

    public static Object getDataPermission(String moduleId, String actionId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        Object userId = profile.get("userId");
        String userToken = DWServiceContext.getContext().getToken();
        String appId = ModelDrivenDataPermission.getAppId();
        HashMap params = new HashMap();
        params.put("userId", userId);
        params.put("sysId", appId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data");
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "IAM\u56de\u50b3\u72c0\u614b\u78bc\u70ba:%s, \u932f\u8aa4\u8a0a\u606f\u70ba:%s";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Gson gson = ModelDrivenDataPermission.getModelDrivenCustomGson();
        return gson.fromJson(iamResponseBody, DWUserPermission.class);
    }

    public static Object getDataPermission(String api) throws Exception {
        DWUserPermission result = null;
        String userToken = DWServiceContext.getContext().getToken();
        HashMap params = new HashMap();
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data/tempuser");
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "IAM\u56de\u50b3\u72c0\u614b\u78bc\u70ba:%s, \u932f\u8aa4\u8a0a\u606f\u70ba:%s";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Gson gson = customGson;
        List dataPerms = (List)gson.fromJson(iamResponseBody, List.class);
        for (Map dataPerm : dataPerms) {
            String dataPermApi = String.valueOf(dataPerm.get("api"));
            if (!dataPermApi.equals(api)) continue;
            String dataPermRowPermissionStr = String.valueOf(dataPerm.get("rowPermission"));
            Map dataPermRowPermission = (Map)gson.fromJson(dataPermRowPermissionStr, Map.class);
            String dataPermColPermissionStr = String.valueOf(dataPerm.get("colPermission"));
            List dataPermColPermission = (List)gson.fromJson(dataPermColPermissionStr, List.class);
            HashMap<String, Object> dwUserPermissionMap = new HashMap<String, Object>();
            dwUserPermissionMap.put("superadmin", false);
            dwUserPermissionMap.put("rowPermission", dataPermRowPermission);
            dwUserPermissionMap.put("colPermission", dataPermColPermission);
            String gsonPermissionMap = gson.toJson(dwUserPermissionMap);
            result = (DWUserPermission)gson.fromJson(gsonPermissionMap, DWUserPermission.class);
            break;
        }
        return result;
    }

    public static DWUserPermission getDataPermission(IDWSQLOptions options) throws Exception {
        Map<String, Object> modelDrivenContextExtraMap = ModelDrivenContext.getContext().getExtraMap();
        DWUserPermission userPermission = (DWUserPermission)modelDrivenContextExtraMap.get("dataPermission");
        if (userPermission != null) {
            return userPermission;
        }
        DWUserPermission result = null;
        String api = null;
        String moduleId = null;
        String actionId = null;
        if (options instanceof DWDataPermissionOption) {
            DWDataPermissionOption dataPermOption = (DWDataPermissionOption)options;
            api = dataPermOption.getApi();
            moduleId = dataPermOption.getModuleId();
            actionId = dataPermOption.getActionId();
        } else {
            DWServiceContext serviceContext = DWServiceContext.getContext();
            Map requestHeader = serviceContext.getRequestHeader();
            if (requestHeader.containsKey("moduleId")) {
                moduleId = requestHeader.get("moduleId").toString();
            }
            if (requestHeader.containsKey("actionId")) {
                actionId = requestHeader.get("actionId").toString();
            }
            if (serviceContext.getAllowCrossTenant()) {
                api = serviceContext.getRequestURI();
            }
        }
        if (api != null) {
            if (api.startsWith("/")) {
                api = api.substring(1);
            }
            result = (DWUserPermission)DWDataPermission.getDataPermission((String)api);
        } else if (actionId != null && moduleId != null) {
            result = (DWUserPermission)ModelDrivenDataPermission.getDataPermission(moduleId, actionId);
        }
        return result;
    }

    private static synchronized Gson getModelDrivenCustomGson() {
        if (customGson == null) {
            GsonBuilder builder = new GsonBuilder().serializeNulls();
            builder.registerTypeAdapter(DWRowPermissionElement.class, (Object)new DWRowPermissionElementDeserializer());
            customGson = builder.create();
        }
        return customGson;
    }
}

