/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.permission.filter;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.DWDataPermissionSQLFilter;
import com.digiwin.app.data.DWDataPermissionOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.permission.ModelDrivenDataPermission;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDrivenDataPermissionSQLFilter
extends DWDataPermissionSQLFilter {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenDataPermissionSQLFilter.class);
    private static final String CLASS_LOG_TAG = "[" + ModelDrivenDataPermissionSQLFilter.class.getSimpleName() + "]";
    public static final String TAG_DATA_PERM = "${dataPerm}";
    private static final String MATCH_QUOTE_EMPTY = Matcher.quoteReplacement(" ");

    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        String sqlcommand = sqlInfo.getSql();
        List parameters = sqlInfo.getParametersAsList();
        if (sqlcommand.contains(TAG_DATA_PERM)) {
            log.debug("{} doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)],before sql command:{}", (Object)CLASS_LOG_TAG, (Object)sqlcommand);
            DWUserPermission dataPermData = null;
            try {
                dataPermData = ModelDrivenDataPermission.getDataPermission(options);
                if (dataPermData != null && options instanceof DWDataPermissionOption) {
                    DWDataPermissionOption dataPermOption = (DWDataPermissionOption)options;
                    dataPermOption.setColumnPermission(dataPermData.getColumnPermission());
                }
            }
            catch (Exception e) {
                log.error("[ModelDrivenDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)], exception message=" + e.getMessage());
            }
            if (dataPermData != null) {
                String rowPermissionSql;
                DWRowPermissionDefaultMatchOption rowPermissionOption = new DWRowPermissionDefaultMatchOption();
                if (options instanceof DWDataPermissionOption) {
                    rowPermissionOption = ((DWDataPermissionOption)options).getRowPermissionOption();
                }
                sqlcommand = (rowPermissionSql = dataPermData.getRowPermission().getSQLContainValues((DWRowPermissionMatchOption)rowPermissionOption)) != null && !rowPermissionSql.isEmpty() ? sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), Matcher.quoteReplacement(" and " + rowPermissionSql)) : sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), MATCH_QUOTE_EMPTY);
            } else {
                sqlcommand = sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), MATCH_QUOTE_EMPTY);
            }
            log.debug("{} doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)],after sql command:{}", (Object)CLASS_LOG_TAG, (Object)sqlcommand);
            sqlInfo.setSqlAndParameters(sqlcommand, parameters);
        }
    }

    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
        DWUserPermission dataPermData = null;
        try {
            dataPermData = ModelDrivenDataPermission.getDataPermission(options);
        }
        catch (Exception e) {
            log.error("{} doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)], e={}", (Object)CLASS_LOG_TAG, (Object)e.getMessage());
        }
        if (dataPermData != null) {
            DWQueryCondition queryCondition;
            DWRowPermissionDefaultMatchOption rowPermissionOption = new DWRowPermissionDefaultMatchOption();
            if (options instanceof DWDataPermissionOption) {
                rowPermissionOption = ((DWDataPermissionOption)options).getRowPermissionOption();
            }
            if ((queryCondition = dataPermData.getRowPermission().getQueryCondition((DWRowPermissionMatchOption)rowPermissionOption)).size() > 0) {
                DWQueryCondition fixedCondition = queryInfo.getFixedCondition();
                fixedCondition.addCondition(queryCondition);
            }
        }
    }
}

