/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.metadata.DWValueAttribute;
import com.digiwin.app.metadata.rdbms.DWRdbmsAttributes;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.utils.DataEntryDBTableUtil;
import com.google.gson.reflect.TypeToken;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEntryDataUtil {
    private static final Logger log = LoggerFactory.getLogger(DataEntryDataUtil.class);
    private static final String CLASS_LOG_TAG = "[" + DataEntryDataUtil.class.getSimpleName() + "]";

    private DataEntryDataUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Map<String, Object>> convertFromJson(DWDataTable dataTable) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        DWRdbmsMetadata tempTableRdbmsMetadata = DataEntryDBTableUtil.loadRdbmsMetadata(dataTable.getName());
        Iterator rowIt = dataTable.getRows().iterator();
        boolean isFirstDataRow = true;
        HashSet<String> checkedSpecialField = new HashSet<String>();
        while (rowIt.hasNext()) {
            Map rowMap = ((DWDataRow)rowIt.next()).getData();
            for (Map.Entry row : rowMap.entrySet()) {
                String columnName = (String)row.getKey();
                Object fieldValueObject = rowMap.get(columnName);
                boolean isSpecialField = checkedSpecialField.contains(columnName);
                if (!isFirstDataRow && isSpecialField) {
                    boolean fieldValueValid = Objects.nonNull(fieldValueObject);
                    if (!fieldValueValid) continue;
                    Object fieldJsonObj = DataEntryDataUtil.getFromJsonObject(fieldValueObject);
                    rowMap.replace(columnName, fieldJsonObj);
                    continue;
                }
                boolean hasFieldFromTempRdbmsMetadata = tempTableRdbmsMetadata.hasField(columnName);
                if (!isFirstDataRow || !hasFieldFromTempRdbmsMetadata) continue;
                DataEntryDataUtil.updateRowMapForFromJson(rowMap, tempTableRdbmsMetadata, columnName, checkedSpecialField, fieldValueObject);
            }
            isFirstDataRow = false;
            dataList.add(rowMap);
        }
        return dataList;
    }

    public static List<Map<String, Object>> convertToJson(List<Map<String, Object>> params, String targetTableName) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        DWRdbmsMetadata tempTableRdbmsMetadata = DataEntryDBTableUtil.loadRdbmsMetadata(targetTableName);
        List<String> fields = DataEntryDataUtil.getFieldNamesStrings(tempTableRdbmsMetadata);
        String fieldNames = String.join((CharSequence)",", fields);
        log.info("====================={} getRdbmsFields:{} ", (Object)targetTableName, (Object)fieldNames);
        boolean isFirstDataRow = true;
        HashSet<String> checkedSpecialField = new HashSet<String>();
        for (Map<String, Object> rowMap : params) {
            for (Map.Entry<String, Object> row : rowMap.entrySet()) {
                String columnName = row.getKey();
                Object fieldValueObject = rowMap.get(columnName);
                boolean fieldValueValid = Objects.nonNull(fieldValueObject);
                boolean isSpecialField = checkedSpecialField.contains(columnName);
                if (!isFirstDataRow && isSpecialField) {
                    if (!fieldValueValid) continue;
                    String fieldJsonObj = DWGsonProvider.getGson().toJson(fieldValueObject, Object.class);
                    rowMap.replace(columnName, fieldJsonObj);
                    continue;
                }
                boolean hasFieldFromTempRdbmsMetadata = tempTableRdbmsMetadata.hasField(columnName);
                if (!isFirstDataRow || !hasFieldFromTempRdbmsMetadata) continue;
                DataEntryDataUtil.updateRowMapForToJson(rowMap, tempTableRdbmsMetadata, columnName, checkedSpecialField, fieldValueValid, fieldValueObject);
            }
            isFirstDataRow = false;
            dataList.add(rowMap);
        }
        return dataList;
    }

    public static String getSqlValue(String columName, Object valueObject, ModelSchemaDTO currentModelSchema) {
        if (valueObject instanceof Number) {
            return valueObject.toString();
        }
        if (valueObject instanceof Timestamp) {
            String valueObjectStr = valueObject.toString();
            List<ModelFieldDTO> modelFields = currentModelSchema.getFields();
            Optional<ModelFieldDTO> timestampField = modelFields.stream().filter(modelField -> modelField.getFieldId().equalsIgnoreCase(columName) && DataTypeEnum.DATETIME.getName().equalsIgnoreCase(modelField.getFieldType())).findFirst();
            if (timestampField.isPresent() && valueObjectStr.endsWith(".0")) {
                valueObject = valueObjectStr.substring(0, valueObjectStr.lastIndexOf(".0"));
                log.info("{} getSqlValue: replace '.0' ({} -> {}) ", new Object[]{CLASS_LOG_TAG, valueObjectStr, valueObject});
            }
        }
        return "'" + valueObject + "'";
    }

    private static Object getFromJsonObject(Object fieldValueObject) {
        Object fieldJsonObj = fieldValueObject instanceof byte[] ? DWGsonProvider.getGson().fromJson(new String((byte[])fieldValueObject), new TypeToken<Map<String, Object>>(){}.getType()) : DWGsonProvider.getGson().fromJson((String)fieldValueObject, new TypeToken<Map<String, Object>>(){}.getType());
        return fieldJsonObj;
    }

    private static List<String> getFieldNamesStrings(DWRdbmsMetadata tableRdbmsMetadata) {
        ArrayList<String> fields = new ArrayList<String>();
        tableRdbmsMetadata.getFields().forEach(item -> {
            if (item instanceof DWRdbmsField) {
                fields.add(item.getName());
            }
        });
        return fields;
    }

    private static void updateRowMapForFromJson(Map<String, Object> target, DWRdbmsMetadata tempTableRdbmsMetadata, String columnName, Set<String> checkedSpecialField, Object fieldValueObject) {
        DWValueAttribute fieldValueAttr = (DWValueAttribute)((DWRdbmsField)tempTableRdbmsMetadata.getField(columnName)).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE);
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)fieldValueAttr.getValue()), (CharSequence)"JSON")) {
            checkedSpecialField.add(columnName);
            if (Objects.nonNull(fieldValueObject)) {
                Object fieldJsonObj = DataEntryDataUtil.getFromJsonObject(fieldValueObject);
                target.replace(columnName, fieldJsonObj);
            }
        }
    }

    private static void updateRowMapForToJson(Map<String, Object> target, DWRdbmsMetadata tempTableRdbmsMetadata, String columnName, Set<String> checkedSpecialField, boolean fieldValueValid, Object fieldValueObject) {
        DWValueAttribute fieldValueAttr = (DWValueAttribute)((DWRdbmsField)tempTableRdbmsMetadata.getField(columnName)).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE);
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)fieldValueAttr.getValue()), (CharSequence)"JSON")) {
            checkedSpecialField.add(columnName);
            if (fieldValueValid) {
                String fieldJsonObj = DWGsonProvider.getGson().toJson(fieldValueObject, Object.class);
                target.replace(columnName, fieldJsonObj);
            }
        }
    }
}

