/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.eai.builder.EaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.eai.builder.ModelStandardEaiHeaderBuilder;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiHeaderByProdUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiHeaderByProdUtil.class);
    private static final String CLASS_LOG_TAG = "[" + EaiHeaderByProdUtil.class.getSimpleName() + "]";
    private final DWEAIHeaderRepository dwEAIHeaderRepository;
    private final EaiHeaderUtil eaiHeaderUtil;
    private final ModelStandardEaiHeaderBuilder modelStandardEAIHeaderBuilder;
    private final EaiHeaderBuilder customizeEAIHeaderBuilder;
    private final EaiHeaderBuilder bmMixEAIHeaderBuilder;

    @Autowired
    public EaiHeaderByProdUtil(DWEAIHeaderRepository dwEAIHeaderRepository, EaiHeaderUtil eaiHeaderUtil, @Qualifier(value="dw-modeldriven-crud-eai-builder") Optional<ModelStandardEaiHeaderBuilder> optionalModelStandardEAIHeaderBuilder, @Qualifier(value="modeldriven-customize-crud-eai-builder") Optional<EaiHeaderBuilder> optionalCustomizeEAIHeaderBuilder, @Qualifier(value="modeldriven-customize-bmmix-builder") Optional<EaiHeaderBuilder> optionalEaiHeaderBuilder) {
        this.dwEAIHeaderRepository = dwEAIHeaderRepository;
        this.eaiHeaderUtil = eaiHeaderUtil;
        this.modelStandardEAIHeaderBuilder = optionalModelStandardEAIHeaderBuilder.orElse(null);
        this.customizeEAIHeaderBuilder = optionalCustomizeEAIHeaderBuilder.orElse(null);
        this.bmMixEAIHeaderBuilder = optionalEaiHeaderBuilder.orElse(null);
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties == null || !bmProperties.isEnabled()) {
            List<DWEAIHeader> newEaiHeaders = this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.modelStandardEAIHeaderBuilder);
            return newEaiHeaders;
        }
        List<DWEAIHeader> newEaiHeaders = bmProperties.getRole() == BMRole.mix ? this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.bmMixEAIHeaderBuilder) : this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos, this.customizeEAIHeaderBuilder);
        return newEaiHeaders;
    }

    public Map<String, Map<String, List<DWEAIHeader>>> genModelDrivenEaiHeadersByProd(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        BMProperties bmProperties = BMProperties.getProperties();
        Map<String, Map<String, List<DWEAIHeader>>> newEaiHeadersMap = new HashMap<String, Map<String, List<DWEAIHeader>>>();
        HashMap<String, List<DWServiceMapping>> serviceMappingMap = new HashMap<String, List<DWServiceMapping>>();
        if (bmProperties.getRole() == BMRole.mix) {
            serviceMappings.stream().forEach(serviceMapping -> {
                String appInfoProd = BMEaiServiceNameUtil.getAppProd(serviceMapping.getExposeEaiId(), serviceMapping.getTableName());
                if (StringUtils.isNotBlank((CharSequence)appInfoProd)) {
                    if (serviceMappingMap.containsKey(appInfoProd)) {
                        ((List)serviceMappingMap.get(appInfoProd)).add(serviceMapping);
                    } else {
                        ArrayList<DWServiceMapping> serviceMappingList = new ArrayList<DWServiceMapping>();
                        serviceMappingList.add((DWServiceMapping)serviceMapping);
                        serviceMappingMap.put(appInfoProd, serviceMappingList);
                    }
                }
            });
            Map<String, List<MappingModelInfo>> mappingModelInfoMap = EaiHeaderByProdUtil.getModelInfoMap(mappingModelInfos);
            newEaiHeadersMap = this.bmMixEAIHeaderBuilder.getProdTechEaiHeaders(serviceMappingMap, mappingModelInfoMap);
        }
        return newEaiHeadersMap;
    }

    public List<DWEAIHeader> genModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos, EaiHeaderBuilder eaiHeaderBuilder) throws Exception {
        log.info("{} genEaiHeaders using {}", (Object)CLASS_LOG_TAG, (Object)eaiHeaderBuilder);
        return eaiHeaderBuilder.getEaiHeaders(serviceMappings, mappingModelInfos);
    }

    public Map<String, Map<String, List<DWEAIHeader>>> updateAndGetModelDrivenEaiHeadersByProd(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        Map<String, Map<String, List<DWEAIHeader>>> newEaiHeaders = this.genModelDrivenEaiHeadersByProd(serviceMappings, mappingModelInfos);
        this.addAndUpdateDWEaiHeadersByProd(newEaiHeaders);
        return newEaiHeaders;
    }

    private void addAndUpdateDWEaiHeadersByProd(Map<String, Map<String, List<DWEAIHeader>>> newEaiHeaders) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ArrayList<DWEAIHeader> allNewEaiHeaders = new ArrayList<DWEAIHeader>();
        for (Map.Entry<String, Map<String, List<DWEAIHeader>>> entry : newEaiHeaders.entrySet()) {
            String prod = entry.getKey();
            Map<String, List<DWEAIHeader>> prodEaiHeaders = newEaiHeaders.get(prod);
            for (Map.Entry<String, List<DWEAIHeader>> entry2 : prodEaiHeaders.entrySet()) {
                String type = entry2.getKey();
                List<DWEAIHeader> typeEaiHeaders = prodEaiHeaders.get(type);
                if (CollectionUtils.isNotEmpty(typeEaiHeaders)) {
                    List allNewEaiHeaderList = allNewEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
                    List typeNewHeaders = typeEaiHeaders.stream().filter(typeEaiHeader -> !allNewEaiHeaderList.contains(typeEaiHeader.getEAIServiceId())).collect(Collectors.toList());
                    allNewEaiHeaders.addAll(typeNewHeaders);
                    log.debug("{} added: {}", (Object)CLASS_LOG_TAG, typeNewHeaders.stream().map(newEaiHeader -> newEaiHeader.getEAIServiceId()).collect(Collectors.toList()));
                    continue;
                }
                log.info("{}[addAndUpdateDWEaiHeadersByProd] ignored add prod({}) type({}), cause empty newEaiHeaders", new Object[]{CLASS_LOG_TAG, prod, type});
            }
        }
        log.debug("{} get all new DWEAIHeaders({})", (Object)CLASS_LOG_TAG, (Object)allNewEaiHeaders.size());
        this.addAndUpdateDWEaiHeaders(allNewEaiHeaders);
    }

    public void addAndUpdateDWEaiHeaders(List<DWEAIHeader> newEaiHeaders) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        this.eaiHeaderUtil.addAndUpdateCommonsHeaders(newEaiHeaders);
    }

    public List<DWHeader> getDropEaiHeaders(List<DWEAIHeader> draftEaiHeaders, List<DWHeader> actualHeaders) {
        List<Object> dropEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(actualHeaders)) {
            dropEaiHeaders = actualHeaders.stream().filter(actual -> draftEaiHeaders.stream().noneMatch(draft -> ((DWEAIHeader)actual).getEAIServiceId().equals(draft.getEAIServiceId()))).collect(Collectors.toList());
            log.info("{} drop size({}) ({})", new Object[]{CLASS_LOG_TAG, dropEaiHeaders.size(), dropEaiHeaders});
        } else {
            log.info("{} ignored drop any DWEAIHeader", (Object)CLASS_LOG_TAG);
        }
        return dropEaiHeaders;
    }

    public void executeDropExistedEaiHeaders(List<DWHeader> dropEaiHeaders) {
        List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
        int repoBefore = orgDWHeaders.size();
        dropEaiHeaders.stream().forEach(orgDWHeaders::remove);
        List dropList = dropEaiHeaders.stream().map(dropEaiHeader -> ((DWEAIHeader)dropEaiHeader).getEAIServiceId()).collect(Collectors.toList());
        log.info("{} drop DWEAIHeaderRepository--> dropped({},{})(dwEAIHeaderRepo: before({}), after({}))", new Object[]{CLASS_LOG_TAG, dropList.size(), dropList, repoBefore, orgDWHeaders.size()});
    }

    public List<DWEAIHeader> genServiceModelInfoData(ModelSchemaDTO masterModelSchema, String modelDrivenProdPrefix, String code) throws Exception {
        String masterTableName = masterModelSchema.getName();
        String userExposePrefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, masterTableName);
        String modelSchemaStr = ModelDataUtil.getModelSchemaStr(masterModelSchema);
        List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(masterModelSchema.getChildren());
        DWServiceMapping serviceMapping = new DWServiceMapping();
        serviceMapping.setTableName(masterTableName);
        serviceMapping.setExposeEaiId(userExposePrefixEaiId);
        serviceMapping.setModelSchema(modelSchemaStr);
        serviceMapping.setCode(code);
        ArrayList<DWServiceMapping> serviceMappings = new ArrayList<DWServiceMapping>();
        serviceMappings.add(serviceMapping);
        List<MappingModelInfo> mappingModelInfos = ModelDataUtil.getChildrenMappingModelInfo(allChildrenSchemas, masterTableName, userExposePrefixEaiId, code);
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled()) {
            BMCenterUtil.modifyServiceMapping(serviceMappings);
            BMCenterUtil.modifyMappingModelInfo(mappingModelInfos);
        }
        return this.genModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
    }

    public List<DWHeader> getExistedEaiHeaders(List<DWEAIHeader> dweaiHeaders) {
        List<Object> existedEaiHeaders = new ArrayList<DWHeader>();
        if (CollectionUtils.isNotEmpty(dweaiHeaders)) {
            List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            existedEaiHeaders = orgDWHeaders.stream().filter(orgDWHeader -> orgDWHeader instanceof DWEAIHeader && dweaiHeaders.stream().anyMatch(dweaiHeader -> ((DWEAIHeader)orgDWHeader).getEAIServiceId().equals(dweaiHeader.getEAIServiceId()))).collect(Collectors.toList());
            log.info("{} get existedEaiHeaders({} from DWEAIHeaderRepository({}({})))", new Object[]{CLASS_LOG_TAG, existedEaiHeaders.size(), "commons", orgDWHeaders.size()});
        } else {
            log.info("{} ignored get existedEaiHeaders  from DWEAIHeaderRepository", (Object)CLASS_LOG_TAG);
        }
        return existedEaiHeaders;
    }

    public static Map<String, List<MappingModelInfo>> getModelInfoMap(List<MappingModelInfo> mappingModelInfos) {
        HashMap<String, List<MappingModelInfo>> mappingModelInfoMap = new HashMap<String, List<MappingModelInfo>>();
        mappingModelInfos.stream().forEach(mappingModelInfo -> {
            String appInfoProd = BMEaiServiceNameUtil.getAppProd(mappingModelInfo.getEaiid(), mappingModelInfo.getTablename());
            if (StringUtils.isNotBlank((CharSequence)appInfoProd)) {
                if (mappingModelInfoMap.containsKey(appInfoProd)) {
                    ((List)mappingModelInfoMap.get(appInfoProd)).add(mappingModelInfo);
                } else {
                    ArrayList<MappingModelInfo> serviceMappingList = new ArrayList<MappingModelInfo>();
                    serviceMappingList.add((MappingModelInfo)mappingModelInfo);
                    mappingModelInfoMap.put(appInfoProd, serviceMappingList);
                }
            }
        });
        return mappingModelInfoMap;
    }
}

