/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelIndexUtil {
    private ModelIndexUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, Object> getAllTableIndexes(ModelTable modelTable) {
        HashMap<String, Object> indexMap = new HashMap<String, Object>();
        List<TableIndex> tableIndexes = modelTable.getIndexes();
        tableIndexes.stream().forEach(modelIndex -> indexMap.put(modelIndex.getName(), modelIndex));
        return indexMap;
    }

    public static Map<String, Object> getIndexes(List<ModelIndexDTO> modelIndexDTOs) {
        HashMap<String, Object> uniquesPublishedRemain = new HashMap<String, Object>();
        modelIndexDTOs.stream().forEach(modelIndex -> uniquesPublishedRemain.put(modelIndex.getId(), modelIndex));
        return uniquesPublishedRemain;
    }

    public static List<ModelIndexDTO> covertModelIndex(List<TableIndex> tableIndexes) {
        ArrayList<ModelIndexDTO> modelIndexes = new ArrayList<ModelIndexDTO>();
        tableIndexes.stream().forEach(tableIndex -> modelIndexes.add(ModelSchemaUtil.convertTableIndexToModelIndex(tableIndex)));
        return modelIndexes;
    }

    public static List<ModelIndexDTO> getColumnUniqueIndexes(ModelTable modelTable) {
        ArrayList<ModelIndexDTO> columnUniqueIndexes = new ArrayList<ModelIndexDTO>();
        modelTable.getColumns().stream().filter(tableColumn -> tableColumn.isPK() == false && tableColumn.getUnique() != false).forEach(tableColumn -> {
            ArrayList<String> members = new ArrayList<String>();
            String columnName = tableColumn.getColumnName();
            members.add(columnName);
            ModelIndexDTO columnUniqueIndex = new ModelIndexDTO();
            columnUniqueIndex.setId(columnName);
            columnUniqueIndex.setMember(members);
            columnUniqueIndex.setType(IndexTypeEnum.UNIQUE_INDEX.getIndexChar());
            columnUniqueIndexes.add(columnUniqueIndex);
        });
        return columnUniqueIndexes;
    }

    public static List<ModelIndexDTO> getColumnUniqueIndexOfModelIndexes(List<ModelIndexDTO> modelIndexes) {
        return modelIndexes.stream().filter(modelIndex -> modelIndex.getMember().size() == 1 && modelIndex.getId().equals(modelIndex.getMember().get(0)) && modelIndex.getType().equalsIgnoreCase(IndexTypeEnum.UNIQUE_INDEX.getIndexChar())).collect(Collectors.toList());
    }
}

