/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.autoconfigure.DWDaoAutoConfiguration;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.lcdp.modeldriven.dataview.dialect.ModelDrivenMySQLDialect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Import(value={DWDaoAutoConfiguration.class})
@Configuration
public class ModelDriverDaoDialectAutoConfiguration {
    @Primary
    @Bean(name={"dw-sqlDialect"})
    public DWSQLDialect dwSqlDialect(Environment environment) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ModelDrivenMySQLDialect dialect = null;
        String dialectClassName = environment.getProperty("dap.dwdao.default.dialect.class");
        if (dialectClassName == null) {
            dialect = new ModelDrivenMySQLDialect();
        } else {
            Class<?> dialectClass = this.getClass().getClassLoader().loadClass(dialectClassName);
            dialect = (DWSQLDialect)dialectClass.newInstance();
        }
        return dialect;
    }
}

