/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.merge.DWAppMergedInfo;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import com.digiwin.app.merge.DWSourceAppInfo;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.enums.RegisterServiceTechTypeEnum;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderByProdUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MixEaiRegisterUtil {
    private static final Logger log = LoggerFactory.getLogger(MixEaiRegisterUtil.class);
    private static final String CLASS_LOG_TAG = "[" + MixEaiRegisterUtil.class.getSimpleName() + "]";
    private final BMProperties bmProperties;
    private final NacosRegisterUtils nacosRegisterUtils;
    private final EaiRegisterUtil eaiRegisterUtil;
    private final EaiHeaderByProdUtil eaiHeaderByProdUtil;

    @Autowired
    public MixEaiRegisterUtil(@Qualifier(value="modeldriven-bm-properties") Optional<BMProperties> optionalBmProperties, Optional<NacosRegisterUtils> optionalNacosRegisterUtils, Optional<EaiRegisterUtil> optionalEaiRegisterUtil, Optional<EaiHeaderByProdUtil> optionalEaiHeaderByProdUtil) {
        this.bmProperties = optionalBmProperties.orElse(null);
        this.nacosRegisterUtils = optionalNacosRegisterUtils.orElse(null);
        this.eaiRegisterUtil = optionalEaiRegisterUtil.orElse(null);
        this.eaiHeaderByProdUtil = optionalEaiHeaderByProdUtil.orElse(null);
    }

    public void registerService(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        BMRole currentBMRole = this.bmProperties.getRole();
        if (CollectionUtils.isNotEmpty(serviceMappings)) {
            Map<String, Map<String, List<DWEAIHeader>>> bmMixEaiHeaders = this.eaiHeaderByProdUtil.updateAndGetModelDrivenEaiHeadersByProd(serviceMappings, mappingModelInfos);
            DWAppMergedInfo appMergedInfo = DWSourceAppAwareUtils.getAppMergedInfo();
            DWSourceAppInfo targetAppInfo = appMergedInfo.getTargetAppInfo();
            ArrayList<String> mergedAppNames = new ArrayList<String>();
            if (targetAppInfo != null) {
                mergedAppNames.add(targetAppInfo.getAppId());
            }
            List mergedSourceInfo = appMergedInfo.getSourceAppList();
            mergedSourceInfo.stream().forEach(dwSourceAppInfo -> mergedAppNames.add(dwSourceAppInfo.getAppId()));
            for (Map.Entry<String, Map<String, List<DWEAIHeader>>> entry : bmMixEaiHeaders.entrySet()) {
                String prod = entry.getKey();
                if (!mergedAppNames.contains(prod)) {
                    log.info("{} *** BM({}) prod({}) *** ignored process, cause not match merged source info", new Object[]{CLASS_LOG_TAG, currentBMRole.getRole(), prod});
                    continue;
                }
                Map<String, List<DWEAIHeader>> prodEaiHeaders = entry.getValue();
                this.executeRegAllTech(prodEaiHeaders, prod);
            }
        }
    }

    public void executeRegAllTech(Map<String, List<DWEAIHeader>> prodEaiHeaders, String prod) throws InterruptedException {
        log.info("{}[executeReg] *** BM(mix) prod({}) *** process ...", (Object)CLASS_LOG_TAG, (Object)prod);
        this.executeRegEspService(prodEaiHeaders, prod);
        if (prodEaiHeaders.containsKey(RegisterServiceTechTypeEnum.NACOS.getTechType())) {
            String nacosStartLog = String.format("%s *** BM prod(%s) *** NACOS service", CLASS_LOG_TAG, prod);
            List<DWEAIHeader> currentProdEaiHeadersForNacos = prodEaiHeaders.get(RegisterServiceTechTypeEnum.NACOS.getTechType());
            if (CollectionUtils.isNotEmpty(currentProdEaiHeadersForNacos)) {
                this.nacosRegisterUtils.executeRegistryService(prodEaiHeaders, prod);
            } else {
                log.info("{} ignored to register, size(0)", (Object)nacosStartLog);
            }
        }
    }

    public void executeRegEspService(Map<String, List<DWEAIHeader>> prodEaiHeaders, String prod) {
        String espStartLog = String.format("%s *** BM prod(%s) *** ESP service", CLASS_LOG_TAG, prod);
        log.info("{}[executeReg] *** BM(mix) prod({}) *** process ...", (Object)CLASS_LOG_TAG, (Object)prod);
        List<Object> currentProdEaiHeadersForEsp = new ArrayList();
        if (prodEaiHeaders.containsKey(RegisterServiceTechTypeEnum.ESP.getTechType())) {
            currentProdEaiHeadersForEsp = prodEaiHeaders.get(RegisterServiceTechTypeEnum.ESP.getTechType());
        }
        boolean isBmdRegistryNacosToEsp = BMProperties.getProperties().isBmdRegistryNacosToEsp();
        log.debug("{}[executeReg] BmdRegistryNacosToEsp={}", (Object)CLASS_LOG_TAG, (Object)isBmdRegistryNacosToEsp);
        if (isBmdRegistryNacosToEsp) {
            String nacosTech = RegisterServiceTechTypeEnum.NACOS.getTechType();
            List nacosEaiHeaders = prodEaiHeaders.getOrDefault(nacosTech, new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)nacosEaiHeaders)) {
                try {
                    currentProdEaiHeadersForEsp.addAll(nacosEaiHeaders);
                    log.info("{} *** BMD *** nacos updated espEaiHeaders, size:{} when BmdRegistryNacosToEsp={})", new Object[]{CLASS_LOG_TAG, nacosEaiHeaders.size(), isBmdRegistryNacosToEsp});
                }
                catch (Exception e) {
                    String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                    log.error("{} *** BMD *** nacos updated espEaiHeaders failed:{}  when BmdRegistryNacosToEsp={}", new Object[]{CLASS_LOG_TAG, errorRootCauseMessage, isBmdRegistryNacosToEsp});
                }
            } else {
                log.debug("{} *** BMD *** ignored nacos espEaiHeaders, size:{} when BmdRegistryNacosToEsp={})", new Object[]{CLASS_LOG_TAG, nacosEaiHeaders.size(), isBmdRegistryNacosToEsp});
            }
        }
        if (CollectionUtils.isNotEmpty(currentProdEaiHeadersForEsp)) {
            int espServiceSize = currentProdEaiHeadersForEsp.size();
            try {
                this.eaiHeaderByProdUtil.addAndUpdateDWEaiHeaders(currentProdEaiHeadersForEsp);
                List currentProdEaiServiceIdsForEsp = currentProdEaiHeadersForEsp.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
                log.info("{} start register, size({})({})", new Object[]{espStartLog, espServiceSize, currentProdEaiServiceIdsForEsp});
                DWEAIProperties prodEaiProperties = new DWEAIProperties();
                prodEaiProperties.setHostProd(prod);
                this.eaiRegisterUtil.registerService(currentProdEaiHeadersForEsp, prodEaiProperties);
                log.info("{} invoked ESP registerService", (Object)espStartLog);
            }
            catch (Exception e) {
                String errorMessage = String.format("%s register failed", espStartLog);
                throw new IllegalStateException(errorMessage, e);
            }
        } else {
            log.info("{} ignored to register, size(0)", (Object)espStartLog);
        }
    }
}

