/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDrivenMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenMetadataUtil.class);

    private ModelDrivenMetadataUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isExistInRdbmsMetadata(String tableName) {
        try {
            DWMetadata rdbmsMetadata = DWMetadataContainer.get((String)tableName, DWRdbmsMetadata.class);
            return rdbmsMetadata != null;
        }
        catch (DWMetadataNotFoundException e) {
            return false;
        }
    }

    public static DWMetadata<?> loadRdbmsMetadata(String tableName) {
        return DWMetadataContainer.get((String)tableName, DWRdbmsMetadata.class);
    }

    public static void removeRdbmsMetadata(String code, List<String> tableNames) {
        log.info("[ModelDrivenMetadataUtil][removeRdbmsMetadata] code({}) removed metadata ({})", (Object)code, tableNames);
        tableNames.stream().forEach(DWMetadataContainer::remove);
    }
}

