/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.registry;

import com.alibaba.nacos.api.exception.NacosException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.customize.utils.BMMixAppUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationEvent;

public class BMMixRegistryApplicationListener
extends BMAbstractRegistryApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(BMMixRegistryApplicationListener.class);
    private static final String CLASS_LOG_TAG = "[" + BMMixRegistryApplicationListener.class.getSimpleName() + "]";
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-genEaiHeaders")
    Object prodTechEaiDataObj;
    @Autowired(required=false)
    private NacosRegisterUtils nacosRegisterUtils;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;

    @Override
    protected void handleEvent(ApplicationEvent event) {
        log.debug("{}[handleEvent] start ({})", (Object)CLASS_LOG_TAG, event.getClass());
        if (event instanceof InstanceRegisteredEvent) {
            if (BooleanUtils.isTrue((Boolean)this.bmProperties.isInitRegEvent())) {
                log.debug("{} ignore InstanceRegisteredEvent", (Object)CLASS_LOG_TAG);
                return;
            }
            log.debug("{} process InstanceRegisteredEvent", (Object)CLASS_LOG_TAG);
            try {
                List<String> mergedAppNames = BMMixAppUtil.getMergedAppNames();
                Map prodTechEaiData = (Map)this.prodTechEaiDataObj;
                for (Map.Entry entry : prodTechEaiData.entrySet()) {
                    String prod = (String)entry.getKey();
                    if (!mergedAppNames.contains(prod)) {
                        log.info("{} *** BM(mix) prod({}) *** ignored process, cause not match merged source info", (Object)CLASS_LOG_TAG, (Object)prod);
                        continue;
                    }
                    Map techEaiHeader = (Map)prodTechEaiData.get(prod);
                    this.eaiHeaderUtil.getNacosHeadersCombindCommons(techEaiHeader);
                    this.nacosRegisterUtils.executeRegistryService(techEaiHeader, prod);
                }
            }
            catch (InterruptedException e) {
                log.error("{}[handleEvent] InterruptedException cause:{}", (Object)CLASS_LOG_TAG, (Object)ExceptionUtils.getMessage((Throwable)e));
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new DWRuntimeException(ExceptionUtils.getMessage((Throwable)e));
            }
            this.bmProperties.setInitRegEvent(true);
            log.info("{}[handleEvent] finished ({})", (Object)CLASS_LOG_TAG, event.getClass());
        } else if (event instanceof NacosServiceRegisterEvent) {
            try {
                log.debug("{} process NacosServiceRegisterEvent", (Object)CLASS_LOG_TAG);
                this.nacosRegisterUtils.nacosServiceRegister((List)event.getSource());
            }
            catch (NacosException e) {
                throw new IllegalStateException("nacos service register failed", e);
            }
        }
        log.debug("{}[handleEvent] end ({})", (Object)CLASS_LOG_TAG, event.getClass());
    }
}

