/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eai.utils;

import com.digiwin.app.service.eai.EAIService;
import com.digiwin.lcdp.modeldriven.constants.ESPConstants;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EaiMethodRepoUtil {
    private static final Logger logger = LoggerFactory.getLogger(EaiMethodRepoUtil.class);
    private static final String CLASS_LOG_TAG = "[" + EaiMethodRepoUtil.class.getSimpleName() + "]";

    private EaiMethodRepoUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static ModelDrivenEaiMethodDTO genModelDrivenEaiMethodDTO(Method method, String eaiId, String eaiServicePostfix, Optional<Class<?>> eaiClazz) {
        ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = EaiMethodRepoUtil.genModelDrivenEaiMethodDTO(method, eaiId, eaiServicePostfix);
        modelDrivenEaiMethodDTO.setEaiClazz(eaiClazz);
        return modelDrivenEaiMethodDTO;
    }

    public static ModelDrivenEaiMethodDTO genModelDrivenEaiMethodDTO(Method method, String eaiId, String eaiServicePostfix) {
        ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = new ModelDrivenEaiMethodDTO();
        modelDrivenEaiMethodDTO.setEaiId(eaiId);
        modelDrivenEaiMethodDTO.setEaiServicePostfix(eaiServicePostfix);
        modelDrivenEaiMethodDTO.setMethod(method);
        return modelDrivenEaiMethodDTO;
    }

    public static ModelDrivenEaiMethodRepository getMethodRepo(Optional<Class<?>> optionalEaiClazz) {
        ModelDrivenEaiMethodRepository mdEaiMethodRepo = new ModelDrivenEaiMethodRepository();
        if (!optionalEaiClazz.isPresent()) {
            logger.warn("{}[getBMListGetHeadersByProd] *** BM *** optionalEaiClazz is null", (Object)CLASS_LOG_TAG);
            return mdEaiMethodRepo;
        }
        Class<?> eaiClazz = optionalEaiClazz.get();
        Method[] commonsCrudEaiClazzMethods = eaiClazz.getMethods();
        List<String> dapStandardEaiPostFixNames = ESPConstants.EAI_SERVICE_POSTFIX;
        mdEaiMethodRepo.setEaiClazz(optionalEaiClazz);
        for (Method method : commonsCrudEaiClazzMethods) {
            if (!method.isAnnotationPresent(EAIService.class)) continue;
            EAIService methodAnnotation = method.getAnnotation(EAIService.class);
            String methodAnnotEaiId = methodAnnotation.id();
            if (methodAnnotEaiId.endsWith(".eai.list.get")) {
                mdEaiMethodRepo.setListGetMethod(method);
            }
            for (String postFix : dapStandardEaiPostFixNames) {
                if (!methodAnnotEaiId.endsWith(postFix)) continue;
                String eaiServicePostfix = EaiMethodRepoUtil.generatePostfixOfEaiServiceId(postFix);
                ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = EaiMethodRepoUtil.genModelDrivenEaiMethodDTO(method, methodAnnotEaiId, eaiServicePostfix, optionalEaiClazz);
                mdEaiMethodRepo.add(methodAnnotEaiId, modelDrivenEaiMethodDTO);
                logger.debug("{}[getMethodRepo]: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", new Object[]{CLASS_LOG_TAG, methodAnnotEaiId, eaiServicePostfix});
            }
        }
        return mdEaiMethodRepo;
    }

    public static String generatePostfixOfEaiServiceId(String postFix) {
        String[] postFixToken = postFix.split("\\.");
        String eaiServicePostfix = postFixToken[2];
        if (postFixToken.length > 3) {
            for (int i = 3; i < postFixToken.length; ++i) {
                eaiServicePostfix = String.join((CharSequence)".", eaiServicePostfix, postFixToken[i]);
            }
        }
        return eaiServicePostfix;
    }

    public static String getPrefixInBusinessLayer(String methodAnnotEaiId) {
        String methodIdPrefix = "";
        String[] methodIdToken = methodAnnotEaiId.split("\\.");
        for (int i = 0; i < methodIdToken.length - 1; ++i) {
            methodIdPrefix = i != 0 ? String.join((CharSequence)".", methodIdPrefix, methodIdToken[i]) : methodIdToken[i];
        }
        return methodIdPrefix;
    }

    public static void processBMRepo(Method method, String methodAnnotEaiId, BMEaiMethodRepository bmEaiMethodRepo, Optional<Class<?>> bmEaiClazz) {
        for (String postFix : BMConstants.BM_METHOD_POSTFIX_ALL) {
            if (!methodAnnotEaiId.endsWith(postFix)) continue;
            String eaiServicePostfix = EaiMethodRepoUtil.generatePostfixOfEaiServiceId(postFix);
            ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = EaiMethodRepoUtil.genModelDrivenEaiMethodDTO(method, methodAnnotEaiId, eaiServicePostfix, bmEaiClazz);
            logger.debug("{}[processOtherPostfix]: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", new Object[]{CLASS_LOG_TAG, methodAnnotEaiId, eaiServicePostfix});
            bmEaiMethodRepo.add(methodAnnotEaiId, modelDrivenEaiMethodDTO);
        }
        if (methodAnnotEaiId.endsWith(".crud.eai.get")) {
            bmEaiMethodRepo.setListGetMethod(method);
            EaiMethodRepoUtil.extracted(method, methodAnnotEaiId, BMConstants.SERVICE_GET_TYPE_POSTFIX, bmEaiClazz, bmEaiMethodRepo);
        }
        if (methodAnnotEaiId.endsWith(".crud.eai.update")) {
            EaiMethodRepoUtil.extracted(method, methodAnnotEaiId, BMConstants.SERVICE_VALID_TYPE_POSTFIX, bmEaiClazz, bmEaiMethodRepo);
        }
    }

    private static void extracted(Method method, String methodAnnotEaiId, List<String> servicePostfixes, Optional<Class<?>> bmEaiClazz, BMEaiMethodRepository bmEaiMethodRepo) {
        for (String eaiServicePostfix : servicePostfixes) {
            String methodIdPrefix = EaiMethodRepoUtil.getPrefixInBusinessLayer(methodAnnotEaiId);
            String methodRepoId = String.join((CharSequence)".", methodIdPrefix, eaiServicePostfix);
            ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = EaiMethodRepoUtil.genModelDrivenEaiMethodDTO(method, methodRepoId, eaiServicePostfix, bmEaiClazz);
            logger.debug("{} serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", new Object[]{CLASS_LOG_TAG, methodAnnotEaiId, eaiServicePostfix});
            bmEaiMethodRepo.add(methodRepoId, modelDrivenEaiMethodDTO);
        }
    }
}

