/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.event;

import com.digiwin.app.merge.processor.DWSourceAppSwitchProcessor;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.event.EaiRegDataInfo;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterProcessor;
import com.digiwin.lcdp.modeldriven.event.EaiServiceRegisterEvent;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class EaiRegisterApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(EaiRegisterApplicationListener.class);
    private static final String CLASS_LOG_TAG = "[" + EaiRegisterApplicationListener.class.getSimpleName() + "]";
    @Autowired(required=false)
    @Qualifier(value="lcdp-eai-reg-service-processor")
    EaiRegisterProcessor eaiRegisterProcessor;

    @Async(value="lcdp-eai-reg-event-executor")
    @EventListener
    public void onApplicationEvent(EaiServiceRegisterEvent eaiServiceRegisterEvent) {
        log.debug("{}[{}] enter onApplicationEvent", (Object)CLASS_LOG_TAG, (Object)Thread.currentThread().getName());
        if (Objects.isNull((Object)eaiServiceRegisterEvent)) {
            return;
        }
        EaiRegDataInfo dataInfo = eaiServiceRegisterEvent.getDataInfo();
        String code = dataInfo.getModelCodeName();
        ThreadContext.put((String)"traceId", (String)((String)dataInfo.getExtraInfo().get("traceId")));
        if (log.isDebugEnabled()) {
            log.debug("{}[{}] regEaiService, code={}, dataInfo={}", new Object[]{CLASS_LOG_TAG, Thread.currentThread().getName(), code, dataInfo});
        }
        try {
            DWSourceAppSwitchProcessor switchContextAppIdProcessor = new DWSourceAppSwitchProcessor();
            switchContextAppIdProcessor.process(() -> dataInfo.getEaiProperties().getHostProd(), () -> {
                this.eaiRegisterProcessor.execute(dataInfo);
                List eaiServiceIds = dataInfo.getEaiHeaders().stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
                if (log.isDebugEnabled()) {
                    log.debug("{} regEaiService finished. dataInfo ==> {}", (Object)CLASS_LOG_TAG, eaiServiceIds);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.error("{} error:{}", (Object)CLASS_LOG_TAG, (Object)e.fillInStackTrace().toString());
        }
    }
}

