/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.utils.ModelDataTypeUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DBColumnUtil {
    private DBColumnUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static TableColumn convertToTableColumn(ModelFieldDTO modelField) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setColumnName(modelField.getFieldId());
        tableColumn.setComment(modelField.getFieldName());
        tableColumn.setDataType(DataTypeEnum.valueOf((String)ModelDataTypeUtil.getDatabaseDataType(modelField.getFieldType())));
        tableColumn.setNullable(Optional.ofNullable(modelField.getNotNull()).orElse(true) == false);
        tableColumn.setDefaultValue(modelField.getDefaultValue());
        tableColumn.setAutoIncrement(modelField.getAutoIncrement());
        tableColumn.setPK(modelField.isPk());
        tableColumn.setLang(modelField.getLang());
        if (!StringUtils.isEmpty((CharSequence)modelField.getSize())) {
            tableColumn.setSize(new Integer(modelField.getSize()));
        }
        if (!StringUtils.isEmpty((CharSequence)modelField.getScale())) {
            tableColumn.setScale(new Integer(modelField.getScale()));
        }
        if (StringUtils.isNotBlank((CharSequence)modelField.getDefaultValueType())) {
            String defaultValueType = modelField.getDefaultValueType();
            if (defaultValueType.equalsIgnoreCase("expression")) {
                tableColumn.setDefaultValueIsExpr(true);
            }
            tableColumn.setDefaultValueType(defaultValueType);
        }
        tableColumn.setUnique(modelField.getUnique());
        tableColumn.setRelationTypeEnum(ModelFieldRelationTypeEnum.valueOf(modelField.getType()));
        return tableColumn;
    }

    public static TableColumn getAutoIncrementColumn(List<TableColumn> tableColumns) {
        return tableColumns.stream().filter(Field::getAutoIncrement).findFirst().orElse(null);
    }

    public static String getMessageLang(TableColumn tableColumn, String locale) {
        String columnComment = "";
        Map<String, Map<String, String>> langMap = tableColumn.getLang();
        if (tableColumn.getLang() != null && langMap.containsKey("fieldName")) {
            Map<String, String> fieldNameLang = langMap.get("fieldName");
            columnComment = fieldNameLang.get(locale);
        }
        if (StringUtils.isBlank((CharSequence)columnComment)) {
            columnComment = tableColumn.getComment();
        }
        return columnComment;
    }

    public static boolean checkValidType(ModelFieldDTO modelField) {
        return ModelFieldRelationTypeEnum.valueOf(modelField.getType()) != ModelFieldRelationTypeEnum.COLLECTION;
    }

    public static boolean checkValidType(TableColumn tableColumn) {
        return tableColumn.getRelationTypeEnum() != ModelFieldRelationTypeEnum.COLLECTION;
    }
}

