/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.generator.DWSQLTimestampValueGenerator;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.model.ModelAppInfoDTO;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.DataEntryTokenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ModelDataUtil {
    private ModelDataUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void preCheckSchema(ModelSchemaDTO modelSchema) {
        Assert.notNull((Object)modelSchema, (String)"'modelSchema' must not be null");
        Assert.hasText((String)modelSchema.getName(), (String)"'modelSchema.name' must not be empty");
        Assert.hasText((String)modelSchema.getComment(), (String)"'modelSchema.tableComment' must not be empty");
        Assert.notEmpty(modelSchema.getFields(), (String)"'modelSchema.fields' must not be empty");
        for (int i = 0; i < modelSchema.getFields().size(); ++i) {
            ModelFieldDTO modelFieldDTO = modelSchema.getFields().get(i);
            Assert.hasText((String)modelFieldDTO.getFieldId(), (String)String.format("'modelSchema.fields[%d].fieldId' must not be empty", i));
            Assert.hasText((String)modelFieldDTO.getFieldType(), (String)String.format("'modelSchema.fields[%d].fieldType' must not be empty", i));
        }
    }

    public static DWDataSetOperationOption getDisabledCommonDataSetOperationOption() {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        return option;
    }

    public static String replaceLast(String string, String substring, String replacement) {
        int index = string.lastIndexOf(substring);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index) + replacement + string.substring(index + substring.length());
    }

    public static Map<String, Object> dealInsertMgmtFields(Map<String, Object> param) {
        Object userId = DWServiceContext.getContext().getProfile().get("userId");
        Object userName = DWServiceContext.getContext().getProfile().get("userName");
        String tenantId = DataEntryTokenUtil.getIAMTenantId();
        if (StringUtils.isEmpty((CharSequence)((String)param.get("create_by")))) {
            param.put("create_by", userId);
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("create_date")))) {
            param.put("create_date", DWSQLTimestampValueGenerator.generate());
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("creator_name")))) {
            param.put("creator_name", userName);
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("tenant_id")))) {
            param.put("tenant_id", tenantId);
        }
        return param;
    }

    public static Map<String, Object> dealUpdateMgmtFields(Map<String, Object> param) {
        Object userId = DWServiceContext.getContext().getProfile().get("userId");
        Object userName = DWServiceContext.getContext().getProfile().get("userName");
        if (StringUtils.isEmpty((CharSequence)((String)param.get("modified_by")))) {
            param.put("modified_by", userId);
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("modified_date")))) {
            param.put("modified_date", DWSQLTimestampValueGenerator.generate());
        }
        if (StringUtils.isEmpty((CharSequence)((String)param.get("modifier_name")))) {
            param.put("modifier_name", userName);
        }
        return param;
    }

    public static List<MappingModelInfo> getChildrenMappingModelInfo(List<ModelSchemaDTO> allChildrenSchemas, String masterTableName, String userExposePrefixEaiId, String code) {
        ArrayList<MappingModelInfo> mappingModelInfos = new ArrayList<MappingModelInfo>();
        if (CollectionUtils.isNotEmpty(allChildrenSchemas)) {
            for (ModelSchemaDTO childModelSchema : allChildrenSchemas) {
                String childTableName = childModelSchema.getName();
                if (StringUtils.equals((CharSequence)childTableName, (CharSequence)masterTableName)) continue;
                MappingModelInfo childMappingModelInfo = new MappingModelInfo();
                childMappingModelInfo.setTablename(masterTableName);
                childMappingModelInfo.setChildtbl(childTableName);
                childMappingModelInfo.setEaiid(userExposePrefixEaiId);
                childMappingModelInfo.setCode(code);
                mappingModelInfos.add(childMappingModelInfo);
            }
        }
        return mappingModelInfos;
    }

    public static String getDraftModelSchemaFromContextDraftJson() {
        String modelStr = (String)ModelDrivenContext.getContext().getExtraMap().get("modelStr");
        Assert.hasText((String)modelStr, (String)"modelStr of ModelDriven Context is null or empty");
        return ModelDataUtil.getModelSchemaFromJsonModel(modelStr);
    }

    public static String getModelSchemaFromJsonModel(String modelStr) {
        Map orgModelMap = (Map)DWGsonProvider.getGson().fromJson(modelStr, Map.class);
        Object orgModelSchemaMap = orgModelMap.get("schema");
        return DWGsonProvider.getGson().toJson(orgModelSchemaMap);
    }

    public static String getModelSchemaStr(ModelSchemaDTO modelSchema) {
        return DWGsonProvider.getGson().toJson((Object)modelSchema);
    }

    public static boolean isDataEmpty(Object tableData) {
        boolean isEmptyData = false;
        if (Objects.nonNull(tableData)) {
            if (tableData instanceof List) {
                if (CollectionUtils.isEmpty((Collection)((List)tableData))) {
                    isEmptyData = true;
                }
            } else if (MapUtils.isEmpty((Map)((Map)tableData))) {
                isEmptyData = true;
            }
        }
        return isEmptyData;
    }

    public static String getProd(ModelDTO model, String prod) {
        ModelAppInfoDTO modelAppInfo = model.getAppInfo();
        String modelProd = "";
        modelProd = modelAppInfo != null && StringUtils.isNotBlank((CharSequence)modelAppInfo.getProd()) ? modelAppInfo.getProd() : prod;
        return modelProd;
    }
}

