/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.model.ModelApiField;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.BindApi;
import com.digiwin.lcdp.modeldriven.utils.BindedApiUtil;
import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import io.jsonwebtoken.lang.Assert;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamFilterUtil {
    private static final Logger log = LoggerFactory.getLogger(ParamFilterUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ParamFilterUtil.class.getSimpleName() + "]";

    private ParamFilterUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void filterMgmtParam(Map<String, Object> rowData, List<ModelApiField> modelApiFields) {
        Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String fieldNameOfRowData = next.getKey();
            if (!ModelDBConstants.APICONFIG_MGMT_FIELD.contains(fieldNameOfRowData)) continue;
            Optional<ModelApiField> optionModelApiField = modelApiFields.stream().filter(modelApiField -> modelApiField.getData_name().equals(fieldNameOfRowData)).findFirst();
            if (optionModelApiField.isPresent()) {
                ModelApiField matchedModelApiField = optionModelApiField.get();
                if (!matchedModelApiField.getShow() && !matchedModelApiField.getRequired()) {
                    iterator.remove();
                    log.warn("{} removed mgmt field({}) from requestData, cause apiConfig(show:{},required:{})", new Object[]{CLASS_LOG_TAG, fieldNameOfRowData, matchedModelApiField.getShow(), matchedModelApiField.getRequired()});
                    continue;
                }
                if (matchedModelApiField.getShow() && matchedModelApiField.getRequired() && StringUtils.isEmpty((CharSequence)((String)next.getValue()))) {
                    String mgmtErrorMessage = String.format(ResourceBundleUtils.getString("paramValidate.apiConfig.mgmt.empty"), fieldNameOfRowData);
                    log.error("{} {}", (Object)CLASS_LOG_TAG, (Object)mgmtErrorMessage);
                    throw new IllegalArgumentException(mgmtErrorMessage);
                }
                log.debug("{} retained mgmt field({}) of requestData, cause apiConfig(show:{},required:{})", new Object[]{CLASS_LOG_TAG, fieldNameOfRowData, matchedModelApiField.getShow(), matchedModelApiField.getRequired()});
                continue;
            }
            iterator.remove();
            log.warn("{} removed mgmt field({}) from requestData, cause apiConfig doesn't hava field", (Object)CLASS_LOG_TAG, (Object)fieldNameOfRowData);
        }
    }

    public static void filterMgmtParam(Map<String, Object> rowData, ModelSchemaDTO modelSchema, String apiName) {
        List<ModelApiField> modelApiFields;
        Map<String, List<ModelApiField>> tileApiConfig;
        Assert.hasText((String)apiName, (String)"missing apiName");
        List<BindApi> bindApiListConfigs = modelSchema.getBindApiListConfig();
        if (CollectionUtils.isNotEmpty(bindApiListConfigs) && (tileApiConfig = BindedApiUtil.getBindApiFields(modelSchema, apiName)) != null && CollectionUtils.isNotEmpty(modelApiFields = tileApiConfig.get(modelSchema.getName()))) {
            ParamFilterUtil.filterMgmtParam(rowData, modelApiFields);
        }
    }
}

