/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.json;

import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEnabledCondition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ModelDrivenEnabledCondition.class})
public class ModelDrivenJacksonUtil {
    private static final Logger logger = LoggerFactory.getLogger(ModelDrivenJacksonUtil.class);
    private static final String CLASS_LOG_TAG = "[" + ModelDrivenJacksonUtil.class.getSimpleName() + "]";
    private static ObjectMapper objMapper = new ObjectMapper();

    public static String toJson(Object obj) {
        try {
            return objMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error("{}[fromJson] 1 deSerialize exception\uff1a{}", (Object)CLASS_LOG_TAG, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T fromJson(String jsonStr, TypeReference<T> typeReference) throws JsonProcessingException {
        return (T)objMapper.readValue(jsonStr, typeReference);
    }

    public static <T> T fromJson(String jsonStr, Class<T> clazz) throws JsonProcessingException {
        return (T)objMapper.readValue(jsonStr, clazz);
    }

    static {
        objMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        objMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        logger.debug("{}[init] enable BigDecimal for floats", (Object)CLASS_LOG_TAG);
    }
}

