/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.context;

import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;

public class ModelDrivenContext
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<ModelDrivenContext> currentModelDrivenContextOfThread = new ThreadLocal();
    private String code;
    private boolean newModelPublish = true;
    private ModelDTO draftModel;
    private ModelDTO publishedModel;
    private Map<String, Object> extraMap = new ConcurrentHashMap<String, Object>();
    private Map<String, ModelTableSchemaCache> publishedTableCache = new ConcurrentHashMap<String, ModelTableSchemaCache>();

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isNewModelPublish() {
        return this.newModelPublish;
    }

    public void setNewModelPublish(boolean newModelPublish) {
        this.newModelPublish = newModelPublish;
    }

    public ModelDTO getDraftModel() {
        return this.draftModel;
    }

    public void setDraftModel(ModelDTO draftModel) {
        this.draftModel = draftModel;
    }

    public ModelDTO getPublishedModel() {
        return this.publishedModel;
    }

    public void setPublishedModel(ModelDTO publishedModel) {
        this.publishedModel = publishedModel;
    }

    public Map<String, Object> getExtraMap() {
        return this.extraMap;
    }

    public void setExtraMap(Map<String, Object> extraMap) {
        this.extraMap = extraMap;
    }

    public Map<String, ModelTableSchemaCache> getPublishedTableCache() {
        return this.publishedTableCache;
    }

    public void setPublishedTableCache(Map<String, ModelTableSchemaCache> publishedTableCache) {
        this.publishedTableCache = publishedTableCache;
    }

    public void clear() {
    }

    public ModelDrivenContext clone() throws CloneNotSupportedException {
        ModelDrivenContext modelDrivenContext = (ModelDrivenContext)super.clone();
        return modelDrivenContext;
    }

    public static ThreadLocal<ModelDrivenContext> getCurrentLogContextOfThread() {
        return currentModelDrivenContextOfThread;
    }

    public static ModelDrivenContext getContext() {
        ModelDrivenContext context = currentModelDrivenContextOfThread.get();
        if (context == null) {
            context = new ModelDrivenContext();
            currentModelDrivenContextOfThread.set(context);
        }
        return context;
    }

    public static ModelTable getActualModelTable(String tableName) {
        Map dbModelTables = (Map)ModelDrivenContext.getContext().extraMap.get("actualModelTablesFromDB");
        ModelTable actualModelTable = (ModelTable)MapUtils.getObject((Map)dbModelTables, (Object)tableName);
        return actualModelTable;
    }

    public static ModelTableSchemaCache getPublishedTableCache(String tableName) {
        ModelTableSchemaCache modelTableSchemaCache = ModelDrivenContext.getContext().publishedTableCache.get(tableName);
        return modelTableSchemaCache;
    }

    public void unload() {
        currentModelDrivenContextOfThread.remove();
    }
}

