/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeCrudInterceptor
extends DWEAICommonCrudInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CustomizeCrudInterceptor.class);
    private static final String CLASS_LOG_TAG = "[" + CustomizeCrudInterceptor.class.getSimpleName() + "]";
    Map<String, LinkedList<DWEAICrudInvocationListener>> customizeListeners = new HashMap<String, LinkedList<DWEAICrudInvocationListener>>();

    @Override
    public Map<String, LinkedList<DWEAICrudInvocationListener>> getCustomizeListeners() {
        return this.customizeListeners;
    }

    @Override
    public void setCustomizeListeners(Map<String, LinkedList<DWEAICrudInvocationListener>> customizeListeners) {
        this.customizeListeners = customizeListeners;
    }

    @Override
    public void register(String eaiId, DWEAICrudInvocationListener listener) {
        LinkedList<DWEAICrudInvocationListener> linkedLists = this.customizeListeners.getOrDefault(eaiId, new LinkedList());
        linkedLists.add(listener);
        this.customizeListeners.put(eaiId, linkedLists);
        logger.debug("{} add eaiId({}), listener({})", new Object[]{CLASS_LOG_TAG, eaiId, listener.getClass().getTypeName()});
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result;
        block10: {
            String digiServiceName;
            block9: {
                digiServiceName = DWServiceContext.getContext().getDigiServiceName();
                logger.debug("{} invoke eaiId({})", (Object)CLASS_LOG_TAG, (Object)digiServiceName);
                LinkedList<DWEAICrudInvocationListener> serviceListeners = this.customizeListeners.get(digiServiceName);
                result = null;
                if (!CollectionUtils.isNotEmpty(serviceListeners)) break block9;
                Object[] objects = invocation.getArguments();
                Map headers = (Map)objects[0];
                Object messageBody = objects[1];
                StopWatch stopWatch = StopWatch.createStarted();
                StringBuilder timeRecord = new StringBuilder();
                try {
                    String messageBeforeInvoke = String.format("beforeInvoke(%d) ", stopWatch.getTime());
                    timeRecord.append(messageBeforeInvoke);
                    logger.debug(messageBeforeInvoke);
                    CustomizeCrudInterceptor.executeListenerBeforeInvoke(serviceListeners, digiServiceName, headers, messageBody);
                    timeRecord.append(String.format("afterBeforeInvoke(%d) ", stopWatch.getTime()));
                    result = invocation.proceed();
                    timeRecord.append(String.format("invocation.proceed()(%d) ", stopWatch.getTime()));
                    CustomizeCrudInterceptor.executeListenerAfterProceed(serviceListeners, digiServiceName, headers, messageBody);
                }
                catch (Throwable e) {
                    try {
                        timeRecord.append(String.format("before doException(%d) ", stopWatch.getTime()));
                        CustomizeCrudInterceptor.executeListenerExceptionBeforeInvoke(e, serviceListeners, digiServiceName);
                        timeRecord.append(String.format("after doException(%d) ", stopWatch.getTime()));
                        if (!stopWatch.isStopped()) {
                            stopWatch.stop();
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                            logger.debug("{} invoke service({}) interceptor({}) afterInvoke ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
                            targetListener.afterInvoke(invocation, result);
                        }
                        if (!stopWatch.isStopped()) {
                            stopWatch.stop();
                        }
                        throw throwable;
                    }
                }
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug("{} invoke service({}) interceptor({}) afterInvoke ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
                    targetListener.afterInvoke(invocation, result);
                }
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                break block10;
            }
            logger.debug("{} didn't have registered interceptor when invoke eaiId({})", (Object)CLASS_LOG_TAG, (Object)digiServiceName);
            result = invocation.proceed();
        }
        return result;
    }

    private static void executeListenerAfterProceed(LinkedList<DWEAICrudInvocationListener> serviceListeners, String digiServiceName, Map<String, Object> headers, Object messageBody) {
        for (DWEAICrudInvocationListener targetListener : serviceListeners) {
            logger.debug("{} invoke service({}) interceptor({}) around ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
            targetListener.around(headers, messageBody);
        }
    }

    private static void executeListenerBeforeInvoke(LinkedList<DWEAICrudInvocationListener> serviceListeners, String digiServiceName, Map<String, Object> headers, Object messageBody) {
        for (DWEAICrudInvocationListener targetListener : serviceListeners) {
            logger.debug("{} invoke, service({}) interceptor({}) beforeInvoke ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
            targetListener.beforeInvoke(headers, messageBody);
        }
    }

    private static void executeListenerExceptionBeforeInvoke(Throwable e, LinkedList<DWEAICrudInvocationListener> serviceListeners, String digiServiceName) throws Exception {
        for (DWEAICrudInvocationListener targetListener : serviceListeners) {
            logger.debug("{} invoke service({}) interceptor({}) doException ", new Object[]{CLASS_LOG_TAG, digiServiceName, targetListener.getClass().getTypeName()});
            targetListener.doException(e);
        }
    }
}

