/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.registry;

import com.alibaba.nacos.api.exception.NacosException;
import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.customize.registry.BMAbstractRegistryApplicationListener;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BMBusinessLayerRegistryApplicationListener
extends BMAbstractRegistryApplicationListener<NacosServiceRegisterEvent> {
    private static final Logger log = LoggerFactory.getLogger(BMBusinessLayerRegistryApplicationListener.class);
    private static final String CLASS_LOG_TAG = "[" + BMBusinessLayerRegistryApplicationListener.class.getSimpleName() + "]";
    @Autowired
    NacosRegisterUtils nacosRegisterUtils;

    @Override
    protected void handleEvent(NacosServiceRegisterEvent event) {
        log.debug("{}[handleEvent] start ({})", (Object)CLASS_LOG_TAG, ((Object)((Object)event)).getClass());
        try {
            log.debug("{} process NacosServiceRegisterEvent", (Object)CLASS_LOG_TAG);
            this.nacosRegisterUtils.nacosServiceRegister((List)event.getSource());
        }
        catch (NacosException e) {
            String errorRootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            log.error("{} nacos service register failed:{}", (Object)CLASS_LOG_TAG, (Object)errorRootCauseMessage);
            throw new IllegalStateException("nacos service register failed", e);
        }
        log.debug("{}[handleEvent] end ({})", (Object)CLASS_LOG_TAG, ((Object)((Object)event)).getClass());
    }
}

