/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.utils;

import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.customize.BMDInvoker;
import com.digiwin.lcdp.modeldriven.customize.utils.BMEaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BMPublishHelper {
    private static final Logger log = LoggerFactory.getLogger(BMPublishHelper.class);
    private static final String CLASS_LOG_TAG = "[" + BMPublishHelper.class.getSimpleName() + "]";
    @Autowired
    private EaiRegisterUtil eaiRegisterUtil;
    @Autowired
    private EaiHeaderUtil eaiHeaderUtil;
    @Autowired
    NacosRegisterUtils nacosRegisterUtils;
    @Autowired(required=false)
    BMDInvoker bmdInvoker;

    public DWEAIResult registerServiceAndCallBmdService(ModelDTO draftModel, Map<String, Object> messageBody) throws Exception {
        String code = draftModel.getCode();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        String modelDrivenProdPrefix = BMEaiServiceNameUtil.getBMEaiPrefixProdOfServiceMapping();
        log.info("[ModelPublishService][publishDraft] *** BM *** code({}), get modelDrivenProdPrefix {}", (Object)code, (Object)modelDrivenProdPrefix);
        ModelCreateTypeEnum useExistedTable = draftModel.getUseExistedTable();
        if (useExistedTable != ModelCreateTypeEnum.EXISTED_TABLE) {
            List<DWEAIHeader> newEAIHeaders = this.eaiHeaderUtil.refreshEaiService(draftModelSchema, modelDrivenProdPrefix, code);
            Object regResult = this.eaiRegisterUtil.autoRegisterEAI(newEAIHeaders, code);
            log.info("{}[publishDraft] *** BM *** code({}) finished call register esp service result({})", new Object[]{CLASS_LOG_TAG, code, regResult});
            this.nacosRegisterUtils.nacosServiceRegister(newEAIHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
            log.info("{}[publishDraft] *** BM *** code({}) finished call register nacos service", (Object)CLASS_LOG_TAG, (Object)code);
        } else {
            log.debug("{}[publishDraft] code({}) ignored to registered esp/nacos(isUseExistedTable({}))", new Object[]{CLASS_LOG_TAG, code, useExistedTable});
        }
        log.info("[ModelPublishService][publishDraft] *** BM *** code({}) call bmd starting...", (Object)code);
        DWEAIResult publishResult = this.callBmdService(code, messageBody);
        log.info("[ModelPublishService][publishDraft] *** BM *** code({}) call bmd finished.", (Object)code);
        return publishResult;
    }

    public DWEAIResult callBmdService(String modelCode, Map<String, Object> messageBody) throws Exception {
        log.info("[ModelPublishService][callBmdService] *** BM *** code({}) call bmd starting...", (Object)modelCode);
        DWEAIResult publishResult = (DWEAIResult)this.bmdInvoker.invoker(DWServiceContext.getContext().getRequestHeader(), messageBody);
        log.info("[ModelPublishService][publishDraft] *** BM *** code({}) call bmd finished.", (Object)modelCode);
        return publishResult;
    }

    public Map<String, Object> deleteModelSchema(Map<String, Object> messageBody) throws Exception {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        DWEAIResult bmdDeleteResult = (DWEAIResult)this.bmdInvoker.invoker(DWServiceContext.getContext().getRequestHeader(), messageBody);
        String eaiResutlCode = bmdDeleteResult.getCode();
        if (!NumberUtils.isDigits((String)eaiResutlCode) || !eaiResutlCode.equals("0")) {
            Map parameter = bmdDeleteResult.getParameter();
            log.debug("deleteModelSchema: error code({}), parameter({})", (Object)eaiResutlCode, (Object)parameter);
            returnData.putAll(parameter);
        } else {
            returnData.put("model", 1);
        }
        return returnData;
    }
}

