/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.dialect;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryGroupBy;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.DWUnionInfo;
import com.digiwin.app.dao.dialect.DWCommonSQLDialect;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.springframework.util.CollectionUtils;

public class ModelDrivenMySQLDialect
extends DWMySQLDialect {
    private static final String PARSE_ERROR_MESSAGE = "ModelDrivenMySQLDialect.parse error";

    public DWSqlInfo parse(DWDataSetOperationOption option, DWQueryInfo queryInfo, String sql) {
        boolean isIgnoreOrderBy;
        DWQueryGroupBy groupBy;
        DWSqlInfo conditionSqlInfo;
        Method parse;
        StringBuilder sqlBuilder = new StringBuilder();
        List parameters = new ArrayList();
        if (sql == null) {
            DWSqlInfo selectSqlInfo = this.parseSelectSql(option, queryInfo);
            sql = selectSqlInfo.getSql();
            parameters.addAll(selectSqlInfo.getParametersAsList());
        }
        sqlBuilder.append(sql);
        this.dwsqlFilterChain.doFilter(queryInfo, (IDWSQLOptions)option);
        queryInfo.getCondition().setTableName(queryInfo.getTableName());
        try {
            parse = DWCommonSQLDialect.class.getDeclaredMethod("parse", DWDataSetOperationOption.class, DWQueryCondition.class, DWQueryCondition.class);
            if (parse == null) {
                throw new IllegalArgumentException("ModelDrivenMySQLDialect.parse error: DWCommonSQLDialect.parse null");
            }
            parse.setAccessible(true);
            conditionSqlInfo = (DWSqlInfo)parse.invoke((Object)this, option, queryInfo.getCondition(), queryInfo.getFixedCondition());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(PARSE_ERROR_MESSAGE, e);
        }
        if (conditionSqlInfo != null) {
            boolean hasWhere;
            boolean bl = hasWhere = sql != null && sql.toUpperCase().contains(" WHERE ");
            if (queryInfo.getFromInfo() != null) {
                try {
                    Statement selectSql = CCJSqlParserUtil.parse((String)sql, null);
                    if (selectSql instanceof Select) {
                        PlainSelect selectBody = (PlainSelect)((Select)selectSql).getSelectBody();
                        hasWhere = selectBody.getWhere() != null;
                    }
                }
                catch (JSQLParserException e) {
                    throw new DWRuntimeException(PARSE_ERROR_MESSAGE, (Throwable)e);
                }
            }
            if (hasWhere) {
                sqlBuilder.append(" ").append(queryInfo.getCondition().getJoinOperator()).append(" ");
            } else {
                sqlBuilder.append(" WHERE ");
            }
            sqlBuilder.append(conditionSqlInfo.getSql());
            parameters = conditionSqlInfo.getParametersAsList();
            if (queryInfo.getFromInfo() != null) {
                try {
                    DWSqlInfo subQuerySqlInfo = (DWSqlInfo)parse.invoke((Object)this, option, queryInfo.getFromInfo().getCondition(), queryInfo.getFromInfo().getFixedCondition());
                    parameters = subQuerySqlInfo.getParametersAsList();
                    parameters.addAll(conditionSqlInfo.getParametersAsList());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new DWRuntimeException(PARSE_ERROR_MESSAGE, (Throwable)e);
                }
            }
        }
        if ((groupBy = queryInfo.getGroupBy()) != null && !CollectionUtils.isEmpty((Collection)groupBy.getFields())) {
            List groupFields = groupBy.getFields();
            sqlBuilder.append(" GROUP BY ").append(String.join((CharSequence)",", groupFields.toArray(new String[groupFields.size()])));
            if (!CollectionUtils.isEmpty((Collection)groupBy.getHavingCondition().getItems())) {
                DWSqlInfo havingSqlInfo = this.parse(option, groupBy.getHavingCondition());
                sqlBuilder.append(" HAVING " + havingSqlInfo.getSql());
                parameters.addAll(havingSqlInfo.getParametersAsList());
            }
        }
        String parsedSql = sqlBuilder.toString();
        LinkedList joinParameters = new LinkedList();
        try {
            Method attachJoin = DWCommonSQLDialect.class.getDeclaredMethod("attachJoin", DWDataSetOperationOption.class, String.class, DWQueryInfo.class, LinkedList.class, String.class);
            attachJoin.setAccessible(true);
            parsedSql = attachJoin.invoke((Object)this, option, parsedSql, queryInfo, joinParameters, sql).toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DWRuntimeException(PARSE_ERROR_MESSAGE, (Throwable)e);
        }
        String[] sqlParts = parsedSql.toUpperCase().split(" JOIN ");
        int count = (int)sqlParts[0].chars().filter(ch -> ch == 63).count();
        ArrayList newParameters = new ArrayList();
        if (count == 0) {
            for (Object parameter : joinParameters) {
                newParameters.add(parameter);
            }
            for (Object parameter : parameters) {
                newParameters.add(parameter);
            }
        } else {
            for (int i = 0; i < parameters.size(); ++i) {
                newParameters.add(parameters.get(i));
                if (i + 1 != count) continue;
                for (Object parameter : joinParameters) {
                    newParameters.add(parameter);
                }
            }
        }
        List unions = queryInfo.getUnions();
        for (DWUnionInfo union : unions) {
            DWSqlInfo unionResultInfo = this.parse(option, union.getQueryInfo(), sql);
            parsedSql = String.format("%s %s %s", parsedSql, union.getOpeartor().getValue(), unionResultInfo.getSql());
            newParameters.addAll(unionResultInfo.getParametersAsList());
        }
        boolean bl = isIgnoreOrderBy = option.get("optionIgnoreOrderBy") != null && (Boolean)option.get("optionIgnoreOrderBy") != false;
        if (!isIgnoreOrderBy && null != queryInfo.getOrderfields() && !queryInfo.getOrderfields().isEmpty()) {
            StringBuilder orderbyStringBuilder = new StringBuilder(parsedSql);
            orderbyStringBuilder.append(" ORDER BY ");
            for (DWQueryOrderby queryOrderbyMap : queryInfo.getOrderfields()) {
                String fieldName = queryOrderbyMap.getName();
                String custFieldPrefix = null;
                try {
                    Field custFieldPrefixField = DWCommonSQLDialect.class.getDeclaredField("custFieldPrefix");
                    custFieldPrefixField.setAccessible(true);
                    custFieldPrefix = custFieldPrefixField.get((Object)this).toString();
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new DWRuntimeException(PARSE_ERROR_MESSAGE, (Throwable)e);
                }
                if (custFieldPrefix != null && fieldName.startsWith(custFieldPrefix)) {
                    String searchCustFieldKey = this.custFieldSqlForEqual(fieldName);
                    orderbyStringBuilder.append(searchCustFieldKey + " " + queryOrderbyMap.getOrderby()).append(",");
                    continue;
                }
                orderbyStringBuilder.append(queryOrderbyMap.getName()).append(" ").append(queryOrderbyMap.getOrderby()).append(",");
            }
            if (!CollectionUtils.isEmpty((Collection)queryInfo.getOrderfields())) {
                orderbyStringBuilder.deleteCharAt(orderbyStringBuilder.lastIndexOf(","));
            }
            parsedSql = orderbyStringBuilder.toString();
        }
        return new DWSqlInfo(parsedSql, newParameters);
    }
}

